/*
 * TableSorterIcons.java
 *
 * Copyright (c) 2004-2011 Gregory Kotsaftis
 * gregkotsaftis@yahoo.com
 * http://zeus-jscl.sourceforge.net/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package gr.zeus.ui.table;

import javax.swing.ImageIcon;

/**
 * Icon constants.
 * <p>
 * @author Gregory Kotsaftis
 * @since 1.50
 */
public final class TableSorterIcons {

    /**
     * Up image icon 1.
     */
    public static final ImageIcon UP1_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/up1.gif"));

    /**
     * Down image icon 1.
     */
    public static final ImageIcon DOWN1_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/down1.gif"));

    /**
     * Up image icon 2.
     */
    public static final ImageIcon UP2_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/up2.gif"));

    /**
     * Down image icon 2.
     */
    public static final ImageIcon DOWN2_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/down2.gif"));

    /**
     * Up image icon 3.
     */
    public static final ImageIcon UP3_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/up3.gif"));

    /**
     * Down image icon 3.
     */
    public static final ImageIcon DOWN3_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/down3.gif"));

    /**
     * Up image icon 4.
     */
    public static final ImageIcon UP4_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/top.png"));

    /**
     * Down image icon 4.
     */
    public static final ImageIcon DOWN4_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/bottom.png"));

    /**
     * Up image icon 5.
     */
    public static final ImageIcon UP5_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/up.png"));

    /**
     * Down image icon 5.
     */
    public static final ImageIcon DOWN5_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/down.png"));

    /**
     * Up image icon 6.
     */
    public static final ImageIcon UP6_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/1uparrow.png"));

    /**
     * Down image icon 6.
     */
    public static final ImageIcon DOWN6_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/1downarrow.png"));

    /**
     * Up image icon 7.
     */
    public static final ImageIcon UP7_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/2uparrow.png"));

    /**
     * Down image icon 7.
     */
    public static final ImageIcon DOWN7_ICON = new ImageIcon(
        TableSorterIcons.class.getResource("/gr/zeus/res/2downarrow.png"));

}
