# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 815;

my $class = "Math::BigRat";
use_ok($class);

note("bmfac() as a class method");

while (<DATA>) {
    s/^\s+//;
    next if /^#/ || !/\S/;

    my ($x, $y, $want) = split;

    # bmfac() as an instance method

    {
        my $z;
        my $test = qq|\$z = $class -> new("$x") -> bmfac("$y");|;
        note("\n$test\n\n");
        eval $test;
        die $@ if $@;
        is($z, $want);
    }

    # bmfac() as a class method

    {
        my $z;
        my $test = qq|\$z = $class -> bmfac("$x", "$y");|;
        note("\n$test\n\n");
        eval $test;
        die $@ if $@;
        is($z, $want);
    }

    # bmfac() as a function does not work, since objectify() converts the
    # scalar to a Math::BigInt, which is the name of the package in which
    # objectify() is defined.

#    {
#        my $z;
#        my $test = qq|\$z = $ {class}::bmfac("$x");|;
#        note("\n$test\n\n");
#        eval $test;
#        die $@ if $@;
#        is($y, $want);
#    }

}

__DATA__

# Tests only for Math::BigRat

-3/2 1 NaN
-1/2 1 NaN
3/2 1 NaN
5/2 1 NaN

1 -3/2 NaN
1 -1/2 NaN
1 3/2 NaN
1 5/2 NaN

# Common tests for Math::BigInt, Math::BigFloat, and Math::BigRat:

-inf 1 NaN
-inf -inf NaN
1 -inf NaN

1 inf 1
5 inf 5
50 inf 50
inf inf inf

-5 -1 NaN
-5 0 NaN
-5 1 NaN
-5 2 NaN
-5 3 NaN
-5 4 NaN
-5 5 NaN

-4 -1 NaN
-4 0 NaN
-4 1 NaN
-4 2 NaN
-4 3 NaN
-4 4 NaN
-4 5 1

-3 -1 NaN
-3 0 NaN
-3 1 NaN
-3 2 NaN
-3 3 NaN
-3 4 1
-3 5 1

-2 -1 NaN
-2 0 NaN
-2 1 NaN
-2 2 NaN
-2 3 1
-2 4 1
-2 5 1

-1 -1 NaN
-1 0 NaN
-1 1 NaN
-1 2 1
-1 3 1
-1 4 1
-1 5 1

0 -1 NaN
0 0 NaN
0 1 1
0 2 1
0 3 1
0 4 1
0 5 1

1 -1 NaN
1 0 NaN
1 1 1
1 2 1
1 3 1
1 4 1
1 5 1

2 -1 NaN
2 0 NaN
2 1 2
2 2 2
2 3 2
2 4 2
2 5 2

3 -1 NaN
3 0 NaN
3 1 6
3 2 3
3 3 3
3 4 3
3 5 3

4 -1 NaN
4 0 NaN
4 1 24
4 2 8
4 3 4
4 4 4
4 5 4

5 -1 NaN
5 0 NaN
5 1 120
5 2 15
5 3 10
5 4 5
5 5 5

6 -1 NaN
6 0 NaN
6 1 720
6 2 48
6 3 18
6 4 12
6 5 6

7 -1 NaN
7 0 NaN
7 1 5040
7 2 105
7 3 28
7 4 21
7 5 14

8 -1 NaN
8 0 NaN
8 1 40320
8 2 384
8 3 80
8 4 32
8 5 24

9 -1 NaN
9 0 NaN
9 1 362880
9 2 945
9 3 162
9 4 45
9 5 36

10 -1 NaN
10 0 NaN
10 1 3628800
10 2 3840
10 3 280
10 4 120
10 5 50

11 -1 NaN
11 0 NaN
11 1 39916800
11 2 10395
11 3 880
11 4 231
11 5 66

12 -1 NaN
12 0 NaN
12 1 479001600
12 2 46080
12 3 1944
12 4 384
12 5 168

13 -1 NaN
13 0 NaN
13 1 6227020800
13 2 135135
13 3 3640
13 4 585
13 5 312

14 -1 NaN
14 0 NaN
14 1 87178291200
14 2 645120
14 3 12320
14 4 1680
14 5 504

15 -1 NaN
15 0 NaN
15 1 1307674368000
15 2 2027025
15 3 29160
15 4 3465
15 5 750

16 -1 NaN
16 0 NaN
16 1 20922789888000
16 2 10321920
16 3 58240
16 4 6144
16 5 1056

17 -1 NaN
17 0 NaN
17 1 355687428096000
17 2 34459425
17 3 209440
17 4 9945
17 5 2856

18 -1 NaN
18 0 NaN
18 1 6402373705728000
18 2 185794560
18 3 524880
18 4 30240
18 5 5616

19 -1 NaN
19 0 NaN
19 1 121645100408832000
19 2 654729075
19 3 1106560
19 4 65835
19 5 9576

20 -1 NaN
20 0 NaN
20 1 2432902008176640000
20 2 3715891200
20 3 4188800
20 4 122880
20 5 15000

21 -1 NaN
21 0 NaN
21 1 51090942171709440000
21 2 13749310575
21 3 11022480
21 4 208845
21 5 22176

22 -1 NaN
22 0 NaN
22 1 1124000727777607680000
22 2 81749606400
22 3 24344320
22 4 665280
22 5 62832

23 -1 NaN
23 0 NaN
23 1 25852016738884976640000
23 2 316234143225
23 3 96342400
23 4 1514205
23 5 129168

24 -1 NaN
24 0 NaN
24 1 620448401733239439360000
24 2 1961990553600
24 3 264539520
24 4 2949120
24 5 229824

25 -1 NaN
25 0 NaN
25 1 15511210043330985984000000
25 2 7905853580625
25 3 608608000
25 4 5221125
25 5 375000

26 -1 NaN
26 0 NaN
26 1 403291461126605635584000000
26 2 51011754393600
26 3 2504902400
26 4 17297280
26 5 576576

27 -1 NaN
27 0 NaN
27 1 10888869450418352160768000000
27 2 213458046676875
27 3 7142567040
27 4 40883535
27 5 1696464

28 -1 NaN
28 0 NaN
28 1 304888344611713860501504000000
28 2 1428329123020800
28 3 17041024000
28 4 82575360
28 5 3616704

29 -1 NaN
29 0 NaN
29 1 8841761993739701954543616000000
29 2 6190283353629375
29 3 72642169600
29 4 151412625
29 5 6664896

30 -1 NaN
30 0 NaN
30 1 265252859812191058636308480000000
30 2 42849873690624000
30 3 214277011200
30 4 518918400
30 5 11250000

31 -1 NaN
31 0 NaN
31 1 8222838654177922817725562880000000
31 2 191898783962510625
31 3 528271744000
31 4 1267389585
31 5 17873856

32 -1 NaN
32 0 NaN
32 1 263130836933693530167218012160000000
32 2 1371195958099968000
32 3 2324549427200
32 4 2642411520
32 5 54286848

33 -1 NaN
33 0 NaN
33 1 8683317618811886495518194401280000000
33 2 6332659870762850625
33 3 7071141369600
33 4 4996616625
33 5 119351232

34 -1 NaN
34 0 NaN
34 1 295232799039604140847618609643520000000
34 2 46620662575398912000
34 3 17961239296000
34 4 17643225600
34 5 226606464

35 -1 NaN
35 0 NaN
35 1 10333147966386144929666651337523200000000
35 2 221643095476699771875
35 3 81359229952000
35 4 44358635475
35 5 393750000

36 -1 NaN
36 0 NaN
36 1 371993326789901217467999448150835200000000
36 2 1678343852714360832000
36 3 254561089305600
36 4 95126814720
36 5 643458816

37 -1 NaN
37 0 NaN
37 1 13763753091226345046315979581580902400000000
37 2 8200794532637891559375
37 3 664565853952000
37 4 184874815125
37 5 2008613376

38 -1 NaN
38 0 NaN
38 1 523022617466601111760007224100074291200000000
38 2 63777066403145711616000
38 3 3091650738176000
38 4 670442572800
38 5 4535346816

39 -1 NaN
39 0 NaN
39 1 20397882081197443358640281739902897356800000000
39 2 319830986772877770815625
39 3 9927882482918400
39 4 1729986783525
39 5 8837652096

40 -1 NaN
40 0 NaN
40 1 815915283247897734345611269596115894272000000000
40 2 2551082656125828464640000
40 3 26582634158080000
40 4 3805072588800
40 5 15750000000

41 -1 NaN
41 0 NaN
41 1 33452526613163807108170062053440751665152000000000
41 2 13113070457687988603440625
41 3 126757680265216000
41 4 7579867420125
41 5 26381811456

42 -1 NaN
42 0 NaN
42 1 1405006117752879898543142606244511569936384000000000
42 2 107145471557284795514880000
42 3 416971064282572800
42 4 28158588057600
42 5 84361761792

43 -1 NaN
43 0 NaN
43 1 60415263063373835637355132068513997507264512000000000
43 2 563862029680583509947946875
43 3 1143053268797440000
43 4 74389431691575
43 5 195019913088

44 -1 NaN
44 0 NaN
44 1 2658271574788448768043625811014615890319638528000000000
44 2 4714400748520531002654720000
44 3 5577337931669504000
44 4 167423193907200
44 5 388856692224

45 -1 NaN
45 0 NaN
45 1 119622220865480194561963161495657715064383733760000000000
45 2 25373791335626257947657609375
45 3 18763697892715776000
45 4 341094033905625
45 5 708750000000

46 -1 NaN
46 0 NaN
46 1 5502622159812088949850305428800254892961651752960000000000
46 2 216862434431944426122117120000
46 3 52580450364682240000
46 4 1295295050649600
46 5 1213563326976

47 -1 NaN
47 0 NaN
47 1 258623241511168180642964355153611979969197632389120000000000
47 2 1192568192774434123539907640625
47 3 262134882788466688000
47 4 3496303289504025
47 5 3965002804224

48 -1 NaN
48 0 NaN
48 1 12413915592536072670862289047373375038521486354677760000000000
48 2 10409396852733332453861621760000
48 3 900657498850357248000
48 4 8036313307545600
48 5 9360955828224

49 -1 NaN
49 0 NaN
49 1 608281864034267560872252163321295376887552831379210240000000000
49 2 58435841445947272053455474390625
49 3 2576442067869429760000
49 4 16713607661375625
49 5 19053977918976

50 -1 NaN
50 0 NaN
50 1 30414093201713378043612608166064768844377641568960512000000000000
50 2 520469842636666622693081088000000
50 3 13106744139423334400000
50 4 64764752532480000
50 5 35437500000000
