//start of PostLz5Encoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLz5Encoder.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;

/**
 * -lz5- kp PostLzssEncoderB
 * 
 * <pre>
 * -- revision history --
 * $Log: PostLz5Encoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     -lz5-  MaxMatch  16 łȂ 18 B
 *     flush() ŏo͂łf[^o͂ĂȂ̂CB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PostLz5Encoder implements PostLzssEncoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 4096;

    /** őv */
    private static final int MaxMatch       = 18;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private OutputStream out
    //------------------------------------------------------------------
    /**
     * -lz5- kf[^o͂Xg[
     */
    private OutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  buffer
    //------------------------------------------------------------------
    //  private byte[] buf
    //  private int index
    //  private int flagIndex
    //  private int flagBit
    //------------------------------------------------------------------
    /** kf[^̈ꎞi[pobt@ */
    private byte[] buf;

    /** buf̌ݏʒu */
    private int index;

    /** buf LzsskA񈳏ktÖʒu */
    private int flagIndex;

    /** LzsskA񈳏ktO */
    private int flagBit;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //------------------------------------------------------------------
    /**
     * Xg[ݏʒu 
     * lha  offset  larc  offset ւ̕ϊɕKv
     */
    private int position;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PostLz5Encoder()
    //  public PostLz5Encoder( OutputStream out )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gps
     */
    private PostLz5Encoder(){ }

    /**
     * -lz5- kp PostLzssEncoder \zB<br>
     * 
     * @param out kf[^o͂o̓Xg[
     */
    public PostLz5Encoder( OutputStream out ){
        if( out != null ){
            this.out       = out;
            this.position  = 0;
            this.buf       = new byte[1024];
            this.index     = 0;
            this.flagIndex = 0;
            this.flagBit   = 0x100;
        }else{
            throw new NullPointerException( "out" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        if( this.flagBit == 0x100 ){
            if( this.buf.length - ( 2 * 8 + 1 ) < this.index ){
                this.out.write( this.buf, 0, this.index );                      //throws IOException
                this.index = 0;
            }
            this.flagBit = 0x01;
            this.flagIndex = this.index++;
            this.buf[ this.flagIndex ] = 0;
        }

        if( code < 0x100 ){
            this.buf[ this.flagIndex ] |= this.flagBit;
            this.buf[ this.index++ ]    = (byte)code;
            this.position++;
        }else{
            this.buf[ this.index++ ]    = (byte)code;
        }
        this.flagBit <<= 1;
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ){
        int pos = ( this.position - offset - 1 
                  - PostLz5Encoder.MaxMatch )
                & ( PostLz5Encoder.DictionarySize - 1 );

        int matchlen  = this.buf[ --this.index ] & 0x0F;
        this.buf[ this.index++ ] = (byte)pos;
        this.buf[ this.index++ ] = (byte)( ( ( pos >> 4 ) & 0xF0 ) | matchlen );

        this.position += matchlen + this.Threshold;

    }


    //------------------------------------------------------------------
    //  method jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂ
     * o͉\ȃf[^o͐ OutputStream ɏo͂A
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͏o͕s\ ő15oCg̃f[^
     * obt@O܂ o͂ȂB<br>
     * ̃\bh͈kωȂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     */
    public void flush() throws IOException {
        if( this.flagBit == 0x100 ){
            this.out.write( this.buf, 0, this.index );                          //throws IOException
            this.out.flush();                                                   //throws IOException

            this.index = 0;
            this.flagBit               = 0x01;
            this.flagIndex             = this.index++;
            this.buf[ this.flagIndex ] = 0;
        }else{
            this.out.write( this.buf, 0, this.flagIndex );                      //throws IOException
            this.out.flush();                                                   //throws IOException

            System.arraycopy( this.buf, this.flagIndex,
                              this.buf, 0,
                              this.index - this.flagIndex );
            this.index     -= this.flagIndex;
            this.flagIndex  = 0;
        }
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.out.write( this.buf, 0, this.index );                              //throws IOException
        this.out.close();                                                       //throws IOException

        this.out = null;
        this.buf = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lz5-` LZSS̃TCY𓾂B
     * 
     * @return -lz5-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PostLz5Encoder.DictionarySize;
    }

    /**
     * -lz5-` LZSS̍Œv𓾂B
     * 
     * @return -lz5-` LZSS̍Œv
     */
    public int getMaxMatch(){
        return PostLz5Encoder.MaxMatch;
    }

    /**
     * -lz5-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lz5-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PostLz5Encoder.Threshold;
    }

}
//end of PostLz5Encoder.java
