/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.AnnotationElementValue;
import org.gjt.jclasslib.structures.elementvalues.ArrayElementValue;
import org.gjt.jclasslib.structures.elementvalues.ClassElementValue;
import org.gjt.jclasslib.structures.elementvalues.ConstElementValue;
import org.gjt.jclasslib.structures.elementvalues.EnumElementValue;

public abstract class ElementValue
extends AbstractStructure {
    public static final char BYTE_TAG = 'B';
    public static final char CHAR_TAG = 'C';
    public static final char DOUBLE_TAG = 'D';
    public static final char FLOAT_TAG = 'F';
    public static final char INT_TAG = 'I';
    public static final char LONG_TAG = 'J';
    public static final char SHORT_TAG = 'S';
    public static final char BOOL_TAG = 'Z';
    public static final char STRING_TAG = 's';
    public static final char ENUM_TAG = 'e';
    public static final char CLASS_TAG = 'c';
    public static final char ARRAY_TAG = '[';
    public static final char ANNOTATION_TAG = '@';
    public static final String BYTE_TAG_VERBOSE = "byte";
    public static final String CHAR_TAG_VERBOSE = "String";
    public static final String DOUBLE_TAG_VERBOSE = "double";
    public static final String FLOAT_TAG_VERBOSE = "float";
    public static final String INT_TAG_VERBOSE = "int";
    public static final String LONG_TAG_VERBOSE = "long";
    public static final String SHORT_TAG_VERBOSE = "short";
    public static final String BOOL_TAG_VERBOSE = "boolean";
    public static final String STRING_TAG_VERBOSE = "String";
    public static final String ENUM_TAG_VERBOSE = "Enum";
    public static final String CLASS_TAG_VERBOSE = "Class";
    public static final String ARRAY_TAG_VERBOSE = "Array";
    public static final String ANNOTATION_TAG_VERBOSE = "Annotation";
    protected static final int INITIAL_LENGTH = 1;
    private int tag;

    public ElementValue(int n) {
        this.tag = n;
    }

    public static ElementValue create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedByte();
        ElementValue elementValue = null;
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                elementValue = new ConstElementValue(n);
                break;
            }
            case 101: {
                elementValue = new EnumElementValue();
                break;
            }
            case 99: {
                elementValue = new ClassElementValue();
                break;
            }
            case 64: {
                elementValue = new AnnotationElementValue();
                break;
            }
            case 91: {
                elementValue = new ArrayElementValue();
                break;
            }
            default: {
                throw new InvalidByteCodeException("Unknown tag " + (char)n);
            }
        }
        elementValue.setClassFile(classFile);
        elementValue.read(dataInput);
        return elementValue;
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this.tag);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected abstract int getSpecificLength();

    public final int getLength() {
        return 1 + this.getSpecificLength();
    }

    public abstract String getEntryName();

    protected String printAccessFlagsVerbose(int n) {
        if (n != 0) {
            throw new RuntimeException("Access flags should be zero: " + Integer.toHexString(n));
        }
        return "";
    }

    public int getTag() {
        return this.tag;
    }

    public static String getTagDescription(int n) {
        switch (n) {
            case 90: {
                return BOOL_TAG_VERBOSE;
            }
            case 66: {
                return BYTE_TAG_VERBOSE;
            }
            case 67: {
                return "String";
            }
            case 68: {
                return DOUBLE_TAG_VERBOSE;
            }
            case 70: {
                return FLOAT_TAG_VERBOSE;
            }
            case 83: {
                return SHORT_TAG_VERBOSE;
            }
            case 73: {
                return INT_TAG_VERBOSE;
            }
            case 74: {
                return LONG_TAG_VERBOSE;
            }
            case 115: {
                return "String";
            }
            case 101: {
                return ENUM_TAG_VERBOSE;
            }
            case 99: {
                return CLASS_TAG_VERBOSE;
            }
            case 64: {
                return ANNOTATION_TAG_VERBOSE;
            }
            case 91: {
                return ARRAY_TAG_VERBOSE;
            }
        }
        return "Unknown";
    }
}

