#
# Copyright 2017 Mycroft AI Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from collections import OrderedDict


_NUM_STRING_PL = {
    0: 'zero',
    1: 'jeden',
    2: 'dwa',
    3: 'trzy',
    4: 'cztery',
    5: 'pięć',
    6: 'sześć',
    7: 'siedem',
    8: 'osiem',
    9: 'dziewięć',
    10: 'dziesięć',
    11: 'jedenaście',
    12: 'dwanaście',
    13: 'trzynaście',
    14: 'czternaście',
    15: 'piętnaście',
    16: 'szesnaście',
    17: 'siedemnaście',
    18: 'osiemnaście',
    19: 'dziewiętnaście',
    20: 'dwadzieścia',
    30: 'trzydzieści',
    40: 'czterdzieści',
    50: 'pięćdziesiąt',
    60: 'sześćdziesiąt',
    70: 'siedemdziesiąt',
    80: 'osiemdziesiąt',
    90: 'dziewięćdziesiąt',
    100: 'sto',
    200: 'dwieście',
    300: 'trzysta',
    400: 'czterysta',
    500: 'pięćset',
    600: 'sześćset',
    700: 'siedemset',
    800: 'osiemset',
    900: 'dziewięćset',
}


_FRACTION_STRING_PL = {
    1: 'jedna',
    2: 'druga',
    3: 'trzecia',
    4: 'czwarta',
    5: 'piąta',
    6: 'szósta',
    7: 'siódma',
    8: 'ósma',
    9: 'dziewiąta',
    10: 'dziesiąta',
    11: 'jedenasta',
    12: 'dwunasta',
    13: 'trzynasta',
    14: 'czternasta',
    15: 'piętnasta',
    16: 'szesnasta',
    17: 'siedemnasta',
    18: 'osiemnasta',
    19: 'dziewiętnasta',
    20: 'dwudziesta',
    30: 'trzydziesta',
    40: 'czterdziesta',
    50: 'pięćdziesiąta',
    60: 'sześćdziesiąta',
    70: 'siedemdziesiąta',
    80: 'osiemdziesiąta',
    90: 'dziewięćdziesiąta',
    100: 'setna',
    200: 'dwusetna',
    300: 'trzysetna',
    400: 'czterysetna',
    500: 'pięćsetna',
    600: 'sześćsetna',
    700: 'siedemsetna',
    800: 'osiemsetna',
    900: 'dziewięćsetna',
    1000: 'tysięczna',
}

_SHORT_SCALE_PL = OrderedDict([
    (100, 'sto'),
    (200, 'dwieście'),
    (300, 'trzysta'),
    (400, 'czterysta'),
    (500, 'pięćset'),
    (600, 'sześćset'),
    (700, 'siedemset'),
    (800, 'osiemset'),
    (900, 'dziewięćset'),
    (1000, 'tysiąc'),
    (1000000, 'milion'),
    (1e9, "miliard"),
    (1e12, 'bilion'),
    (1e15, "biliard"),
    (1e18, "trylion"),
    (1e21, "sekstilion"),
    (1e24, "kwadrylion"),
    (1e27, "kwadryliard"),
    (1e30, "kwintylion"),
    (1e33, "kwintyliard"),
    (1e36, "sekstylion"),
    (1e39, "sekstyliard"),
    (1e42, "septylion"),
    (1e45, "septyliard"),
    (1e48, "oktylion"),
    (1e51, "oktyliard"),
    (1e54, "nonilion"),
    (1e57, "noniliard"),
    (1e60, "decylion"),
    (1e63, "decyliard"),
    (1e66, "undecylion"),
    (1e69, "undecyliard"),
    (1e72, "duodecylion"),
    (1e75, "duodecyliard"),
    (1e78, "tredecylion"),
    (1e81, "tredecyliard"),
    (1e84, "kwartyduodecylion"),
    (1e87, "kwartyduodecyliard"),
    (1e90, "kwintyduodecylion"),
    (1e93, "kwintyduodecyliard"),
    (1e96, "seksdecylion"),
    (1e99, "seksdecyliard"),
    (1e102, "septydecylion"),
    (1e105, "septydecyliard"),
    (1e108, "oktodecylion"),
    (1e111, "oktodecyliard"),
    (1e114, "nondecylion"),
    (1e117, "nondecyliard"),
    (1e120, "wigintylion"),
    (1e123, "wigintyliard"),
    (1e153, "quinquagintylion"),
    (1e183, "trycyliard"),
    (1e213, "septuagintylion"),
    (1e243, "kwadragiliard"),
    (1e273, "nonagintylion"),
    (1e303, "centezylion"),
    (1e306, "uncentylion"),
    (1e309, "duocentylion"),
    (1e312, "trescentylion"),
    (1e333, "decicentylion"),
    (1e336, "undecicentylion"),
    (1e363, "viginticentylion"),
    (1e366, "unviginticentylion"),
    (1e393, "trigintacentylion"),
    (1e423, "quadragintacentylion"),
    (1e453, "quinquagintacentylion"),
    (1e483, "sexagintacentylion"),
    (1e513, "septuagintacentylion"),
    (1e543, "ctogintacentylion"),
    (1e573, "nonagintacentylion"),
    (1e603, "centyliard"),
    (1e903, "trecentylion"),
    (1e1203, "quadringentylion"),
    (1e1503, "quingentylion"),
    (1e1803, "sescentylion"),
    (1e2103, "septingentylion"),
    (1e2403, "octingentylion"),
    (1e2703, "nongentylion"),
    (1e3003, "milinylion")
])


_ORDINAL_BASE_PL = {
    1: 'pierwszy',
    2: 'drugi',
    3: 'trzeci',
    4: 'czwarty',
    5: 'piąty',
    6: 'szósty',
    7: 'siódmy',
    8: 'ósmy',
    9: 'dziewiąty',
    10: 'dziesiąty',
    11: 'jedenasty',
    12: 'dwunasty',
    13: 'trzynasty',
    14: 'czternasty',
    15: 'piętnasty',
    16: 'szesnasty',
    17: 'siedemnasty',
    18: 'osiemnasty',
    19: 'dziewiętnasty',
    20: 'dwudziesty',
    30: 'trzydziesty',
    40: "czterdziesty",
    50: "pięćdziesiąty",
    60: "sześćdziesiąty",
    70: "siedemdziesiąty",
    80: "osiemdziesiąty",
    90: "dziewięćdziesiąty",
    1e2: "setny",
    1e3: "tysięczny"
}


_SHORT_ORDINAL_PL = {
    1e6: "milionowy",
    1e9: "miliardowy",
    1e12: "bilionowy",
    1e15: "biliardowy",
    1e18: "trylionowy",
    1e21: "tryliardowy",
    1e24: "kwadrylionowy",
    1e27: "kwadryliardowy",
    1e30: "kwintylionowy",
    1e33: "kwintyliardowy",
    1e36: "sektylionowy",
    1e42: "septylionowy",
    1e48: "oktylionowy",
    1e54: "nonylionowy",
    1e60: "decylionowy"
    # TODO > 1e-33
}
_SHORT_ORDINAL_PL.update(_ORDINAL_BASE_PL)

_ALT_ORDINALS_PL = {
    1: 'pierwszej',
    2: 'drugiej',
    3: 'trzeciej',
    4: 'czwartej',
    5: 'piątej',
    6: 'szóstej',
    7: 'siódmej',
    8: 'ósmej',
    9: 'dziewiątej',
    10: 'dziesięcio',
    11: 'jedenasto',
    12: 'dwunasto',
    13: 'trzynasto',
    14: 'czternasto',
    15: 'piętnasto',
    16: 'szesnasto',
    17: 'siedemnasto',
    18: 'osiemnasto',
    19: 'dziewiętnasto',
    20: 'dwudziesto',
    30: 'trzydziesto',
    40: 'czterdziesto',
    50: 'pięćdziesiecio',
    60: 'sześćdziesięcio',
    70: 'siedemdziesięcio',
    80: 'osiemdziesięcio',
    90: 'dziewięćdziesięcio',
}

_TIME_UNITS_CONVERSION = {
    'mikrosekund': 'microseconds',
    'mikrosekundy': 'microseconds',
    'milisekund': 'milliseconds',
    'milisekundy': 'milliseconds',
    'sekunda': 'seconds',
    'sekundy': 'seconds',
    'sekund': 'seconds',
    'minuta': 'minutes',
    'minuty': 'minutes',
    'minut': 'minutes',
    'godzina': 'hours',
    'godziny': 'hours',
    'godzin': 'hours',
    'dzień': 'days',
    'dni': 'days',
    'tydzień': 'weeks',
    'tygodni': 'weeks',
    'tygodnie': 'weeks',
    'tygodniu': 'weeks',
}

_TIME_UNITS_NORMALIZATION = {
    'mikrosekunda': 'mikrosekunda',
    'mikrosekundę': 'mikrosekunda',
    'mikrosekund': 'mikrosekunda',
    'mikrosekundy': 'mikrosekunda',
    'milisekunda': 'milisekunda',
    'milisekundę': 'milisekunda',
    'milisekund': 'milisekunda',
    'milisekundy': 'milisekunda',
    'sekunda': 'sekunda',
    'sekundę': 'sekunda',
    'sekundy': 'sekunda',
    'sekund': 'sekunda',
    'minuta': 'minuta',
    'minutę': 'minuta',
    'minut': 'minuta',
    'minuty': 'minuta',
    'godzina': 'godzina',
    'godzinę': 'godzina',
    'godzin': 'godzina',
    'godziny': 'godzina',
    'dzień': 'dzień',
    'dni': 'dzień',
    'tydzień': 'tydzień',
    'tygodni': 'tydzień',
    'tygodnie': 'tydzień',
    'tygodniu': 'tydzień',
    'miesiąc': 'miesiąc',
    'miesiące': 'miesiąc',
    'miesięcy': 'miesiąc',
    'rok': 'rok',
    'lata': 'rok',
    'lat': 'rok',
    'dekada': 'dekada',
    'dekad': 'dekada',
    'dekady': 'dekada',
    'dekadę': 'dekada',
    'wiek': 'wiek',
    'wieki': 'wiek',
    'milenia': 'milenia',
    'milenium': 'milenia',
}

_MONTHS_TO_EN = {
    'styczeń': 'January',
    'stycznia': 'January',
    'luty': 'February',
    'lutego': 'February',
    'marzec': 'March',
    'marca': 'March',
    'kwiecień': 'April',
    'kwietnia': 'April',
    'maj': 'May',
    'maja': 'May',
    'czerwiec': 'June',
    'czerwca': 'June',
    'lipiec': 'July',
    'lipca': 'July',
    'sierpień': 'August',
    'sierpnia': 'August',
    'wrzesień': 'September',
    'września': 'September',
    'październik': 'October',
    'października': 'October',
    'listopad': 'November',
    'listopada': 'November',
    'grudzień': 'December',
    'grudnia': 'December',
}

_DAYS_TO_EN = {
    'poniedziałek': 0,
    'poniedziałkach': 0,
    'poniedziałkami': 0,
    'poniedziałki': 0,
    'poniedziałkiem': 0,
    'poniedziałkom': 0,
    'poniedziałkowa': 0,
    'poniedziałkową': 0,
    'poniedziałkowe': 0,
    'poniedziałkowego': 0,
    'poniedziałkowej': 0,
    'poniedziałkowemu': 0,
    'poniedziałkowi': 0,
    'poniedziałkowy': 0,
    'poniedziałkowych': 0,
    'poniedziałkowym': 0,
    'poniedziałkowymi': 0,
    'poniedziałków': 0,
    'poniedziałku': 0,
    'wtorek': 1,
    'wtorkach': 1,
    'wtorkami': 1,
    'wtorki': 1,
    'wtorkiem': 1,
    'wtorkom': 1,
    'wtorkowa': 1,
    'wtorkową': 1,
    'wtorkowe': 1,
    'wtorkowego': 1,
    'wtorkowej': 1,
    'wtorkowemu': 1,
    'wtorkowi': 1,
    'wtorkowy': 1,
    'wtorkowych': 1,
    'wtorkowym': 1,
    'wtorkowymi': 1,
    'wtorków': 1,
    'wtorku': 1,
    'środa': 2,
    'środach': 2,
    'środami': 2,
    'środą': 2,
    'środę': 2,
    'środo': 2,
    'środom': 2,
    'środowa': 2,
    'środową': 2,
    'środowe': 2,
    'środowego': 2,
    'środowej': 2,
    'środowemu': 2,
    'środowi': 2,
    'środowy': 2,
    'środowych': 2,
    'środowym': 2,
    'środowymi': 2,
    'środy': 2,
    'środzie': 2,
    'śród': 2,
    'czwartek': 3,
    'czwartkach': 3,
    'czwartkami': 3,
    'czwartki': 3,
    'czwartkiem': 3,
    'czwartkom': 3,
    'czwartkowa': 3,
    'czwartkową': 3,
    'czwartkowe': 3,
    'czwartkowego': 3,
    'czwartkowej': 3,
    'czwartkowemu': 3,
    'czwartkowi': 3,
    'czwartkowy': 3,
    'czwartkowych': 3,
    'czwartkowym': 3,
    'czwartkowymi': 3,
    'czwartków': 3,
    'czwartku': 3,
    'piątek': 4,
    'piątkach': 4,
    'piątkami': 4,
    'piątki': 4,
    'piątkiem': 4,
    'piątkom': 4,
    'piątkowa': 4,
    'piątkową': 4,
    'piątkowe': 4,
    'piątkowego': 4,
    'piątkowej': 4,
    'piątkowemu': 4,
    'piątkowi': 4,
    'piątkowy': 4,
    'piątkowych': 4,
    'piątkowym': 4,
    'piątkowymi': 4,
    'piątków': 4,
    'piątku': 4,
    'sobocie': 5,
    'sobota': 5,
    'sobotach': 5,
    'sobotami': 5,
    'sobotą': 5,
    'sobotę': 5,
    'sobotni': 5,
    'sobotnia': 5,
    'sobotnią': 5,
    'sobotnich': 5,
    'sobotnie': 5,
    'sobotniego': 5,
    'sobotniej': 5,
    'sobotniemu': 5,
    'sobotnim': 5,
    'sobotnimi': 5,
    'soboto': 5,
    'sobotom': 5,
    'soboty': 5,
    'sobót': 5,
    'niedziel': 6,
    'niedziela': 6,
    'niedzielach': 6,
    'niedzielami': 6,
    'niedzielą': 6,
    'niedziele': 6,
    'niedzielę': 6,
    'niedzieli': 6,
    'niedzielna': 6,
    'niedzielną': 6,
    'niedzielne': 6,
    'niedzielnego': 6,
    'niedzielnej': 6,
    'niedzielnemu': 6,
    'niedzielni': 6,
    'niedzielny': 6,
    'niedzielnych': 6,
    'niedzielnym': 6,
    'niedzielnymi': 6,
    'niedzielo': 6,
    'niedzielom': 6
}
