/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_PASSWORD_HEADER
#define LIFEOGRAPH_DIALOG_PASSWORD_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>

#include "helpers.hpp"


namespace LIFEO
{

// PASSWORD DIALOG =================================================================================
class DialogPassword : public DialogEvent
{
    public:
        enum OperationType
        // Build blocks: cur=1, new=2, check=4, set=8
        {
            // blocks:
            OT_CHECK=1,
            OT_SET=2,
            OT_CURRENT=4,
            OT_NEW=8,
            // composites:
            OT_AUTHENTICATE = 5,
            OT_OPEN = 6,
            OT_ADD = 10,
            OT_CHANGE = 15,
        };

                                    DialogPassword(
                                            BaseObjectType*,
                                            const Glib::RefPtr< Gtk::Builder >& );

        static int                  launch( OperationType, Diary*, bool = false );

    protected:
        void                        handle_entry_changed( void );
        void                        authenticate( void );
        void                        check_match( void );

        Gtk::Button                 *m_button_go;
        EntryClear                  *m_entry_current;
        Gtk::Label                  *m_label_msg;
        Gtk::Label                  *m_label_path;

        Gtk::Grid                   *m_grid_new;
        Gtk::Grid                   *m_grid_authenticate;
        Gtk::Button                 *m_button_authenticate;
        EntryClear                  *m_entry_new;
        EntryClear                  *m_entry_confirm;
        Gtk::Image                  *m_image_new;
        Gtk::Image                  *m_image_confirm;

        Diary                       *m_ptr2diary;
        OperationType               m_ot;

        static DialogPassword       *ptr;

        static const int            SLEEP_DURATION = 2;
};

} // end of namespace LIFEO

#endif

