*** Settings ***
Default Tags    regression  pybot  jybot
Resource        rebot_cli_resource.robot


*** Test Cases ***

Default Name, Doc & Metadata
    [Documentation]  Using default values (read from xml) for name, doc and metadata. Tests are run together to have less Rebot runs with same input i.e. to have faster execution.
    Run Rebot  ${EMPTY}  ${MYINPUT}
    Check Names  ${SUITE}  Normal
    Check Names  ${SUITE.tests[0]}  First One  Normal.
    Check Names  ${SUITE.tests[1]}  Second One  Normal.
    Should Be Equal  ${SUITE.doc}  Normal test cases
    Should Be Equal  ${SUITE.metadata['Something']}  My Value

Overriding Name, Doc & Metadata And Escaping
    [Documentation]  Overriding name, doc and metadata. Also testing escaping values. Tests are run together to have less Rebot runs with same input i.e. to have faster execution.
    ${bs} =  Set Variable If  __import__('os').name == 'nt'  \\  \\\\
    Run Rebot  -N this_is_overridden_next --name my_COOL_NameEXEX --doc Even_${bs}cooooler${bs}_docEXQU --metadata something:New --metadata two_parts:three_parts_here -M path:c:${bs}temp${bs}new.txt -M esc:STQUDOAMHAEXEX --escape star:ST -E quest:QU -E dollar:DO -E amp:AM -E hash:HA -E exclam:EX  ${MYINPUT}
    Check Names  ${SUITE}  my COOL Name!!
    Check Names  ${SUITE.tests[0]}  First One  my COOL Name!!.
    Check Names  ${SUITE.tests[1]}  Second One  my COOL Name!!.
    Should Be Equal  ${SUITE.doc}  Even \\cooooler\\ doc!?
    Should Be Equal  ${SUITE.metadata['Something']}  New
    Should Be Equal  ${SUITE.metadata['two parts']}  three parts here
    Should Be Equal  ${SUITE.metadata['path']}  c:\\temp\\new.txt
    Should Be Equal  ${SUITE.metadata['esc']}  *?$&#!!
