*** Settings ***
Documentation  On Windows colors are never actually written to output. Testing
...            colors thus really works only on non-Windows machines.
Force Tags     regression   pybot  jybot
Resource       monitor_resource.robot


*** Test Cases ***

Monitor Colors Auto
    Run Tests With Colors  --monitorcolors auto
    Outputs should not have ANSI colors

Monitor Colors Off
    Run Tests With Colors  --monitorcolors OFF
    Outputs should not have ANSI colors

Monitor Colors Force
    [Documentation]  Backwards compatibility with 2.5.5 and earlier
    Run Tests With Colors  -C force
    Outputs should have ANSI colors when not on Windows

Monitor Colors On
    Run Tests With Colors  --MonitorCol on
    Outputs should have ANSI colors when not on Windows

Monitor Colors ANSI
    Run Tests With Colors  --MonitorColors AnSi
    Outputs should have ANSI colors

Invalid Monitor Colors
    [Documentation]  Invalid color mapped to 'auto' (default)
    Run Tests With Colors  -C INVALID
    Outputs should not have ANSI colors

Monitor Width
    ${name} =  Evaluate  'Start-' + '0123456789' * 9 + '-end'
    Run Tests  --monitorwidth 105 --name ${name} --doc x  misc/pass_and_fail.robot
    Check Stdout Contains  ${SEP_CHAR1 * 105}\n ${name} :: x\n ${SEP_CHAR1 * 105}\n
    Check Stdout Contains  ${SEP_CHAR2 * 105}\n ${name[:-7]}... | FAIL |\n ${MSG_211}\n ${SEP_CHAR1 * 105}\n
    ${statuts} =  Create Status Line  Pass  93  PASS
    Check Stdout Contains  ${SEP_CHAR1 * 105}\n ${statuts}\n ${SEP_CHAR2 * 105}\n
    ${statuts} =  Create Status Line  Fail :: FAIL Expected failure  68  FAIL
    Check Stdout Contains  ${SEP_CHAR2 * 105}\n ${statuts}\n Expected failure\n ${SEP_CHAR2 * 105}\n
    Run Tests  -W 20 --name ${name}  misc/pass_and_fail.robot
    Check Stdout Contains  ${SEP_CHAR1 * 20}\n Start-01234567890...\n ${SEP_CHAR1 * 20}\n
    Check Stdout Contains  ${SEP_CHAR2 * 20}\n Start-01... | FAIL |\n ${MSG_211}\n ${SEP_CHAR1 * 20}\n
    Check Stdout Contains  ${SEP_CHAR1 * 20}\n Pass${SPACE * 8}| PASS |\n ${SEP_CHAR2 * 20}\n
    Check Stdout Contains  ${SEP_CHAR2 * 20}\n Fail :: ... | FAIL |\n Expected failure\n ${SEP_CHAR2 * 20}\n


*** Keywords ***

Run Tests With Colors  [Arguments]  ${colors}
    Run Tests  ${colors} --variable LEVEL1:WARN  misc/pass_and_fail.robot

Outputs should not have ANSI colors
    Check Stdout Contains  | PASS |
    Check Stdout Contains  | FAIL |
    Check Stderr Contains  [ WARN ]

Outputs should have ANSI colors when not on Windows
    Run Keyword If      os.sep == '/'  Outputs should have ANSI colors
    Run Keyword Unless  os.sep == '/'  Outputs should not have ANSI colors

Outputs should have ANSI colors
    Check Stdout Does Not Contain  | PASS |
    Check Stdout Does Not Contain  | FAIL |
    Check Stderr Does Not Contain  [ WARN ]
    Check Stdout Contains  PASS
    Check Stdout Contains  FAIL
    Check Stderr Contains  WARN
