//#***************************************************************************
//# *   Copyright (C) 2006 by A Lynch                                         *
//# *   aalynch@users.sourceforge.net                                         *
//# *                                                                         *
//# *   This program is free software; you can redistribute it and/or modify  *
//# *   it under the terms of the GNU General Public License version 2 as published by  *
//# *   the Free Software Foundation;                                         *
//# *                                                                         *
//# *   This program is distributed in the hope that it will be useful,       *
//# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
//# *   GNU General Public License for more details.                          *
//# *                                                                         *
//# *   You should have received a copy of the GNU General Public License     *
//# *   along with this program; if not, write to the                         *
//# *   Free Software Foundation, Inc.,                                       *
//# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
//# ***************************************************************************/

header {
    import nodesubclasses
}

options {
        language="Python";
}

class MaximaParser extends Parser;
options {
	buildAST = true;
    k=3;
}

tokens {
    NOOP<AST=nodesubclasses.NOOPNode>;
    FOR<AST=nodesubclasses.PROGCONTROLNode>;
    IF<AST=nodesubclasses.PROGCONTROLNode>;
    THEN<AST=nodesubclasses.PROGCONTROLNode>;
    ELSE<AST=nodesubclasses.PROGCONTROLNode>;
    THRU<AST=nodesubclasses.PROGCONTROLNode>;
    WHILE<AST=nodesubclasses.PROGCONTROLNode>;
    UNLESS<AST=nodesubclasses.PROGCONTROLNode>;
    DO<AST=nodesubclasses.PROGCONTROLNode>;
    STEP<AST=nodesubclasses.PROGCONTROLNode>;
    IN<AST=nodesubclasses.PROGCONTROLNode>;
    LABEL<AST=nodesubclasses.LABELNode>;
    COMMA<AST=nodesubclasses.COMMANode>;
    ASSIGN<AST=nodesubclasses.EQUALSNode>;
    ASSIGN2<AST=nodesubclasses.EQUALSNode>;
    MACRODEF<AST=nodesubclasses.EQUALSNode>;
    FUNCDEF<AST=nodesubclasses.EQUALSNode>;
    COMPARE<AST=nodesubclasses.EQUALSNode>;
    OR<AST=nodesubclasses.EQUALSNode>;
    AND<AST=nodesubclasses.EQUALSNode>;
    NOT<AST=nodesubclasses.NEGNode>;
    POWER<AST=nodesubclasses.POWERNode>;
    POWER2<AST=nodesubclasses.POWERNode>;
    TIMES<AST=nodesubclasses.TIMESNode>;
    DIVIDE<AST=nodesubclasses.DIVIDENode>;
    MINUS<AST=nodesubclasses.PLUSMINUSNode>;
    PLUS<AST=nodesubclasses.PLUSMINUSNode>;
    DOT<AST=nodesubclasses.PLUSMINUSNode>;
    EQUALS<AST=nodesubclasses.EQUALSNode>;
    NOTEQUALS<AST=nodesubclasses.EQUALSNode>;
    MATRIX<AST=nodesubclasses.MATRIXNode>;
    NUM<AST=nodesubclasses.NUMNode>;
    BRACKET<AST=nodesubclasses.BRACKETNode>;
    SQBRACKET<AST=nodesubclasses.BRACKETNode>;
    VAR<AST=nodesubclasses.VARNode>;
    INTEGRATE<AST=nodesubclasses.INTEGRATENode>;
    DIFFERENTIATE<AST=nodesubclasses.DIFFERENTIATENode>;
    SUM<AST=nodesubclasses.SUMNode>;
    SQRT<AST=nodesubclasses.SQRTNode>;
    NEG<AST=nodesubclasses.NEGNode>;
    FACTORIAL<AST=nodesubclasses.FACTORIALNode>;
    FUNCTION<AST=nodesubclasses.FUNCTIONNode>;
    LIMIT<AST=nodesubclasses.LIMITNode>;
}


sentence
    : ! (VAR ASSIGN) => a:VAR ASSIGN e:comma {#sentence = #([LABEL],a,e) }
    | comma
    ;

comma     
    :   forop (COMMA^ forop)*
    ;

flattenedcomma
    :   forop (COMMA! forop)*
    ;

forop
    : FOR^ orop (IN | STEP orop)? thru
    | thru
    ;

thru
    :(THRU^ | WHILE^ | UNLESS^) orop (STEP orop)? doop
    | doop
    ;

doop
    : DO ifop
    | ifop
    ;

ifop
    : IF^ orop THEN ifop (ELSE ifop)?
    | orop
    ;

orop
    :   OR^ andop
    |   andop
    ;

andop
    :   AND^ notop
    |   notop
    ;

notop
    :   NOT^ compare
    |   compare
    ;

compare
    :   assign (COMPARE^ assign)*
    ;

assign
    :   equals ((ASSIGN^ | ASSIGN2^ | MACRODEF^ | FUNCDEF^) equals)*
    ;

equals
    : (expr (EQUALS | NOTEQUALS)) => expr (EQUALS^ | NOTEQUALS^) expr  
    | expr
    ;

expr
	:	mexpr ((MINUS^ | PLUS^ ) mexpr)*
	;

mexpr
	:	dot ((TIMES^ | DIVIDE^) dot)*
	;

dot
	:	powr (DOT^  powr)*
	;

powr
    :   pfactorial ((POWER^ | POWER2^) pfactorial)*
    ;

pfactorial
    :   atom (FACTORIAL^)*
    ;


atom:	NUM 
    |   SQRT^ BRACKET! comma RPAREN!
    |   (BRACKET^ | SQBRACKET^) comma RPAREN!
    | ! MATRIX^ m:matrixcontents {#atom = #([SQBRACKET],#([MATRIX],m))}
    |   (INTEGRATE^ | DIFFERENTIATE^)  BRACKET! flattenedcomma RPAREN! 
    |   SUM^ BRACKET! flattenedcomma RPAREN!
    | ! MINUS e:atom {#atom = #([NEG,"-"],e)}
    |   LIMIT^ BRACKET! flattenedcomma RPAREN!
    | ! (VAR BRACKET) => VAR BRACKET a:comma RPAREN {#atom = #([FUNCTION,"FUNCTION"], #VAR, #([BRACKET],a))}
    |   VAR
    ;

matrixcontents
    :   BRACKET! flattenedsqbracket (COMMA! flattenedsqbracket)* RPAREN!
    ;

flattenedsqbracket
    :  ! SQBRACKET^ f:flattenedcomma RPAREN! {#flattenedsqbracket = #([NOOP,"NOOP"],f)}
    ;
        

class MaximaLexer extends Lexer;

options {
        k=8;
        testLiterals=true;
        caseSensitive=false;
        caseSensitiveLiterals=false;
}

WS
        : ( ' '
          | '\t'
          | '\n' { $newline }
          | "\r\n" { $newline }
          | '\r' { $newline }
          )
         { $skip }
        ;


protected
DIGIT   :       '0'..'9' ;

protected
INT
        :       (DIGIT)+
        ;

NUM
        :       INT (DOT INT)?
        ;

protected
LOWER
        :       'a'..'z'
        ;

protected
UPPER
        :       'A'..'Z'
        ;

protected
LETTER
        :       UPPER
        |       LOWER
        ;

protected
PERCENT      : '%' ;

VAR
        :  PERCENT LETTER (LETTER|DIGIT)*
        |  LETTER (LETTER|DIGIT)*
        ;

ASSIGN       : ":" ;
ASSIGN2      : "::" ;
MACRODEF     : "::=" ;
FUNCDEF      : ":=" ;
AND          : "and" WS!;
OR           : "or" WS!; 
NOT          : "not" WS!; 
COMPARE      : ">" | "<" | ">=" | "<=" ;
DOT          : '.' ;
BRACKET      : '(' ;
RPAREN       : ')' | ']' ;
SQBRACKET    : '[' ;
POWER        : '^' ;
POWER2       : "^^" ;
COMMA        : ',' ;
TIMES        : '*' ;
DIVIDE       : '/' ;
PLUS         : '+' ;
MINUS        : '-' ;
SEMICOLON    : ';' ;
EQUALS       : '=' ;
NOTEQUALS    : '#' ;
FACTORIAL    : '!' ;
LIMIT        : "limit" ;
SQRT         : "sqrt" ;
MATRIX       : "matrix" ;
INTEGRATE    : "integrate" | "'integrate" | "defint" ;
DIFFERENTIATE   :  "diff" | "'diff" ;
SUM          : "sum" | "'sum" ;

FOR          :  "for" WS!;
IN           :  "in" WS!;
DO           :  "do" WS!;
THRU         :  "thru" WS!;
STEP         :  "step" WS!;
WHILE        :  "while" WS!;
UNLESS       :  "unless" WS!;
IF           :  "if" WS!;
THEN         :  "then" WS!;
ELSE         :  "else" WS!;

