package internal

import (
	"testing"

	"github.com/cloudflare/circl/sign/dilithium/internal/common"
)

// Tests specific to the current mode

func TestVectorDeriveUniformLeqEta(t *testing.T) {
	var p common.Poly
	var seed [32]byte
	p2 := common.Poly{
		3, 8380411, 8380413, 8380414, 0, 0, 8380416, 5, 8380411, 8380412,
		2, 6, 2, 8380414, 8380413, 6, 8380413, 0, 8380416, 8380413, 5,
		2, 2, 8380415, 8380414, 8380414, 0, 5, 8380416, 5, 8380416, 0,
		8380413, 3, 8380413, 5, 3, 8380412, 0, 6, 8380416, 8380413,
		8380411, 1, 4, 0, 6, 0, 5, 8380412, 4, 8380414, 5, 8380413, 2,
		3, 8380412, 8380414, 8380411, 0, 8380414, 4, 6, 8380414, 8380412,
		8380415, 8380411, 8380415, 3, 1, 8380413, 5, 8380413, 2, 8380413,
		8380411, 8380414, 8380411, 1, 8380414, 8380414, 5, 2, 1, 8380414,
		8380416, 5, 1, 8380415, 8380414, 4, 3, 5, 8380411, 8380413,
		8380416, 1, 8380415, 6, 5, 8380414, 8380412, 8380412, 2, 2,
		8380411, 8380415, 8380416, 4, 4, 4, 4, 8380413, 8380412, 1,
		8380416, 4, 8380415, 8380413, 8380411, 8380412, 8380415, 8380413,
		8380412, 3, 8380413, 0, 4, 8380413, 3, 1, 4, 2, 8380411, 1,
		8380411, 8380412, 4, 8380414, 1, 8380415, 3, 8380411, 8380411,
		3, 1, 6, 0, 8380415, 6, 5, 1, 8380416, 2, 8380412, 4, 6, 6, 0,
		4, 8380411, 5, 1, 8380411, 1, 4, 1, 1, 8380411, 4, 6, 8380413,
		8380415, 8380413, 6, 4, 0, 6, 6, 5, 0, 2, 6, 6, 8380412, 2, 6,
		8380412, 4, 8380415, 2, 2, 8380416, 8380412, 8380416, 3, 3,
		8380415, 1, 8380412, 8380414, 8380411, 8380412, 4, 8380415, 6,
		8380414, 1, 5, 1, 0, 0, 4, 2, 8380413, 3, 8380414, 8380414,
		8380411, 1, 8380415, 5, 3, 6, 3, 1, 2, 8380413, 8380413, 8380412,
		0, 0, 8380411, 4, 4, 8380411, 2, 4, 5, 8380412, 6, 3, 6, 4, 4,
		8380416, 3, 8380416, 6, 3, 8380411, 4, 5, 4, 8380415, 1,
	}
	for i := 0; i < 32; i++ {
		seed[i] = byte(i)
	}
	PolyDeriveUniformLeqEta(&p, &seed, 30000)
	p.Normalize()
	if p != p2 {
		t.Fatalf("%v != %v", p, p2)
	}
}
