package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DatabaseSQLVulnerabilityAssessmentBaselinesClient is the the Azure SQL Database management API provides a RESTful
// set of web services that interact with Azure SQL Database services to manage your databases. The API enables you to
// create, retrieve, update, and delete databases.
type DatabaseSQLVulnerabilityAssessmentBaselinesClient struct {
	BaseClient
}

// NewDatabaseSQLVulnerabilityAssessmentBaselinesClient creates an instance of the
// DatabaseSQLVulnerabilityAssessmentBaselinesClient client.
func NewDatabaseSQLVulnerabilityAssessmentBaselinesClient(subscriptionID string) DatabaseSQLVulnerabilityAssessmentBaselinesClient {
	return NewDatabaseSQLVulnerabilityAssessmentBaselinesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabaseSQLVulnerabilityAssessmentBaselinesClientWithBaseURI creates an instance of the
// DatabaseSQLVulnerabilityAssessmentBaselinesClient client using a custom endpoint.  Use this when interacting with an
// Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDatabaseSQLVulnerabilityAssessmentBaselinesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseSQLVulnerabilityAssessmentBaselinesClient {
	return DatabaseSQLVulnerabilityAssessmentBaselinesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate add a database's vulnerability assessment rule baseline list.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// parameters - the requested rule baseline resource.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties.LatestScan", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties.Results", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, serverName, databaseName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) CreateOrUpdateResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets a list of database's sql vulnerability assessment rule baselines.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) GetResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySQLVulnerabilityAssessment gets a list of database's sql vulnerability assessment rule baselines.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) ListBySQLVulnerabilityAssessment(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselinesClient.ListBySQLVulnerabilityAssessment")
		defer func() {
			sc := -1
			if result.dsvabslr.Response.Response != nil {
				sc = result.dsvabslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySQLVulnerabilityAssessmentNextResults
	req, err := client.ListBySQLVulnerabilityAssessmentPreparer(ctx, resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "ListBySQLVulnerabilityAssessment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySQLVulnerabilityAssessmentSender(req)
	if err != nil {
		result.dsvabslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "ListBySQLVulnerabilityAssessment", resp, "Failure sending request")
		return
	}

	result.dsvabslr, err = client.ListBySQLVulnerabilityAssessmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "ListBySQLVulnerabilityAssessment", resp, "Failure responding to request")
		return
	}
	if result.dsvabslr.hasNextLink() && result.dsvabslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySQLVulnerabilityAssessmentPreparer prepares the ListBySQLVulnerabilityAssessment request.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) ListBySQLVulnerabilityAssessmentPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySQLVulnerabilityAssessmentSender sends the ListBySQLVulnerabilityAssessment request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) ListBySQLVulnerabilityAssessmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySQLVulnerabilityAssessmentResponder handles the response to the ListBySQLVulnerabilityAssessment request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) ListBySQLVulnerabilityAssessmentResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySQLVulnerabilityAssessmentNextResults retrieves the next set of results, if any.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) listBySQLVulnerabilityAssessmentNextResults(ctx context.Context, lastResults DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, err error) {
	req, err := lastResults.databaseSQLVulnerabilityAssessmentBaselineSetListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "listBySQLVulnerabilityAssessmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySQLVulnerabilityAssessmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "listBySQLVulnerabilityAssessmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySQLVulnerabilityAssessmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentBaselinesClient", "listBySQLVulnerabilityAssessmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySQLVulnerabilityAssessmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseSQLVulnerabilityAssessmentBaselinesClient) ListBySQLVulnerabilityAssessmentComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselinesClient.ListBySQLVulnerabilityAssessment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySQLVulnerabilityAssessment(ctx, resourceGroupName, serverName, databaseName)
	return
}
