/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(adaptive_algorithm.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(a13b47b8abd39d82742a594477210648)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/digital/adaptive_algorithm.h>
// pydoc.h is automatically generated in the build directory
#include <adaptive_algorithm_pydoc.h>

void bind_adaptive_algorithm(py::module& m)
{

    using adaptive_algorithm = ::gr::digital::adaptive_algorithm;


    py::class_<adaptive_algorithm, std::shared_ptr<adaptive_algorithm>>(
        m, "adaptive_algorithm", D(adaptive_algorithm))

        .def("base", &adaptive_algorithm::base, D(adaptive_algorithm, base))


        .def("initialize_taps",
             &adaptive_algorithm::initialize_taps,
             py::arg("taps"),
             D(adaptive_algorithm, initialize_taps))


        .def("error_dd",
             &adaptive_algorithm::error_dd,
             py::arg("wu"),
             py::arg("decision"),
             D(adaptive_algorithm, error_dd))


        .def("error_tr",
             &adaptive_algorithm::error_tr,
             py::arg("wu"),
             py::arg("d_n"),
             D(adaptive_algorithm, error_tr))


        .def("update_tap",
             &adaptive_algorithm::update_tap,
             py::arg("tap"),
             py::arg("in"),
             py::arg("error"),
             py::arg("decision"),
             D(adaptive_algorithm, update_tap))


        .def("update_taps",
             &adaptive_algorithm::update_taps,
             py::arg("taps"),
             py::arg("in"),
             py::arg("error"),
             py::arg("decision"),
             py::arg("num_taps"),
             D(adaptive_algorithm, update_taps))

        ;

    py::enum_<::gr::digital::adaptive_algorithm_t>(m, "adaptive_algorithm_t")
        .value("LMS", ::gr::digital::adaptive_algorithm_t::LMS)   // 0
        .value("NLMS", ::gr::digital::adaptive_algorithm_t::NLMS) // 1
        .value("CMA", ::gr::digital::adaptive_algorithm_t::CMA)   // 2
        .export_values();

    py::implicitly_convertible<int, ::gr::digital::adaptive_algorithm_t>();
}
