// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package config

import (
	ghConfig "github.com/cli/go-gh/v2/pkg/config"
	"sync"
)

// Ensure, that MigrationMock does implement Migration.
// If this is not the case, regenerate this file with moq.
var _ Migration = &MigrationMock{}

// MigrationMock is a mock implementation of Migration.
//
//	func TestSomethingThatUsesMigration(t *testing.T) {
//
//		// make and configure a mocked Migration
//		mockedMigration := &MigrationMock{
//			DoFunc: func(config *ghConfig.Config) error {
//				panic("mock out the Do method")
//			},
//			PostVersionFunc: func() string {
//				panic("mock out the PostVersion method")
//			},
//			PreVersionFunc: func() string {
//				panic("mock out the PreVersion method")
//			},
//		}
//
//		// use mockedMigration in code that requires Migration
//		// and then make assertions.
//
//	}
type MigrationMock struct {
	// DoFunc mocks the Do method.
	DoFunc func(config *ghConfig.Config) error

	// PostVersionFunc mocks the PostVersion method.
	PostVersionFunc func() string

	// PreVersionFunc mocks the PreVersion method.
	PreVersionFunc func() string

	// calls tracks calls to the methods.
	calls struct {
		// Do holds details about calls to the Do method.
		Do []struct {
			// Config is the config argument value.
			Config *ghConfig.Config
		}
		// PostVersion holds details about calls to the PostVersion method.
		PostVersion []struct {
		}
		// PreVersion holds details about calls to the PreVersion method.
		PreVersion []struct {
		}
	}
	lockDo          sync.RWMutex
	lockPostVersion sync.RWMutex
	lockPreVersion  sync.RWMutex
}

// Do calls DoFunc.
func (mock *MigrationMock) Do(config *ghConfig.Config) error {
	if mock.DoFunc == nil {
		panic("MigrationMock.DoFunc: method is nil but Migration.Do was just called")
	}
	callInfo := struct {
		Config *ghConfig.Config
	}{
		Config: config,
	}
	mock.lockDo.Lock()
	mock.calls.Do = append(mock.calls.Do, callInfo)
	mock.lockDo.Unlock()
	return mock.DoFunc(config)
}

// DoCalls gets all the calls that were made to Do.
// Check the length with:
//
//	len(mockedMigration.DoCalls())
func (mock *MigrationMock) DoCalls() []struct {
	Config *ghConfig.Config
} {
	var calls []struct {
		Config *ghConfig.Config
	}
	mock.lockDo.RLock()
	calls = mock.calls.Do
	mock.lockDo.RUnlock()
	return calls
}

// PostVersion calls PostVersionFunc.
func (mock *MigrationMock) PostVersion() string {
	if mock.PostVersionFunc == nil {
		panic("MigrationMock.PostVersionFunc: method is nil but Migration.PostVersion was just called")
	}
	callInfo := struct {
	}{}
	mock.lockPostVersion.Lock()
	mock.calls.PostVersion = append(mock.calls.PostVersion, callInfo)
	mock.lockPostVersion.Unlock()
	return mock.PostVersionFunc()
}

// PostVersionCalls gets all the calls that were made to PostVersion.
// Check the length with:
//
//	len(mockedMigration.PostVersionCalls())
func (mock *MigrationMock) PostVersionCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockPostVersion.RLock()
	calls = mock.calls.PostVersion
	mock.lockPostVersion.RUnlock()
	return calls
}

// PreVersion calls PreVersionFunc.
func (mock *MigrationMock) PreVersion() string {
	if mock.PreVersionFunc == nil {
		panic("MigrationMock.PreVersionFunc: method is nil but Migration.PreVersion was just called")
	}
	callInfo := struct {
	}{}
	mock.lockPreVersion.Lock()
	mock.calls.PreVersion = append(mock.calls.PreVersion, callInfo)
	mock.lockPreVersion.Unlock()
	return mock.PreVersionFunc()
}

// PreVersionCalls gets all the calls that were made to PreVersion.
// Check the length with:
//
//	len(mockedMigration.PreVersionCalls())
func (mock *MigrationMock) PreVersionCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockPreVersion.RLock()
	calls = mock.calls.PreVersion
	mock.lockPreVersion.RUnlock()
	return calls
}
