/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __TRIMESH_PIS_H
#define __TRIMESH_PIS_H

// --- project includes ---
#include "pis/pi_storage.h"

// --- STL includes ---
#include <set>
#include <list>

/*!
  \brief Abstract base class for parallel storage of interactions between a triangle 
  mesh and particles
*/
template<class ParticleType> 
class TriMesh_PIS : public AParallelInteractionStorage
{
 protected:
  int m_update_timestamp;
  TriMesh* m_mesh;
 
 public:
  TriMesh_PIS(TriMesh*,ParallelParticleArray<ParticleType>*);
  virtual ~TriMesh_PIS();

  virtual void addExIG(AParallelInteractionStorage*);
  virtual AFieldSlave* generateNewScalarFieldSlave(TML_Comm*,const string&,int,int,int,int);
  virtual AFieldSlave* generateNewVectorFieldSlave(TML_Comm*,const string&,int,int,int,int);
};

#include "pis/trimesh_pis.hpp"

#endif //__TRIMESH_PIS_H
