#!/bin/sh

# Parameters
# 1 = hostname
# 2 = contact
# 3 = email
#
# Constants
#
SENDER=requests@domain.com

# Define locations
TEMP=/etc/dhis/temp
GENID=/etc/dhis/bin/genid
GENKEYS=/etc/dhis/bin/genkeys
GENPASS=/etc/dhis/bin/genpass
DBDIR=/etc/dhis/db
DBFILE=/etc/dhis/db/dhis.db

ISADDR=123.123.123.123		; IP address of DHIS server
MXADDR=122.222.222.222		; IP address of relay server
DHISD_PID=/etc/dhis/pid/dhisd.pid

RELAY=relay.domain.com
NSUPDATE=/usr/sbin/nsupdate

$GENKEYS > $TEMP/keys.$$
$GENID > $TEMP/id.$$

# DB File
#
echo "" >> $DBFILE
echo `cat $TEMP/id.$$ | awk '{ print $2 }'`" {" >> $DBFILE
echo "\thostname\t$1" >> $DBFILE
cat $TEMP/keys.$$ >> $DBFILE
echo "\tcontact\t\t$2" >> $DBFILE
echo "\temail\t\t$3" >> $DBFILE
echo "\tservice\t\tdns" >> $DBFILE
echo "}" >> $DBFILE
kill -HUP `cat $DHISD_PID` 

# Update DNS
#
echo "update add $1. 60 in a 192.168.255.0" > $TEMP/nsupdate.$$
echo "update add $1. 86600 in mx 0  $1." >> $TEMP/nsupdate.$$
echo "update add $1. 86600 in mx 10  $RELAY." >> $TEMP/nsupdate.$$
echo "" >> $TEMP/nsupdate.$$
$NSUPDATE $TEMP/nsupdate.$$
rm -f $TEMP/nsupdate.$$


# Remove Files
rm -f $TEMP/id.$$
rm -f $TEMP/keys.$$
