#ifndef xcontrol_source_section_h_
#define xcontrol_source_section_h_ 1

#include "package_name.hpp"
#include "dependency_list.hpp"
#include "control_file_stream.hpp"

#include "attribute.hpp"
#include "boolean_attribute.hpp"

#include <iostream>

class source_section
{
public:
	source_section(package_name const &);

	typedef ::attribute<std::string> attribute;

	typedef std::string attribute_selector_type;

	attribute operator[](attribute_selector_type const &);

	bool operator==(source_section const &) const;
	bool operator!=(source_section const &rhs) const
	{
		return !operator==(rhs);
	}

	// TODO: make const (trouble with boost::optional)
	package_name name;

	std::string section;
	std::string priority;
	std::string maintainer;
	dependency_list build_depends;
	dependency_list build_depends_indep;
	dependency_list build_depends_tools;
	std::string standards_version;
	bool cross_compiling;
};

control_file_ostream &operator<<(control_file_ostream &stream, source_section const &source);

#endif
