/*******************************************************************************
 * Size: 20 px
 * Bpp: 3
 * Opts: --bpp 3 --size 20 --font Montserrat-Medium.ttf --range 32-127 --format lvgl -o test_font_montserrat_ascii_3bpp_compressed.c
 ******************************************************************************/

#include "../../../lvgl.h"
#if LV_BUILD_TEST

#ifndef TEST_FONT_MONTSERRAT_ASCII_3BPP_COMPRESSED
    #define TEST_FONT_MONTSERRAT_ASCII_3BPP_COMPRESSED 1
#endif

#if TEST_FONT_MONTSERRAT_ASCII_3BPP_COMPRESSED

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x7f, 0x1, 0x10, 0xc0, 0xf3, 0x4, 0xf, 0xdc,
    0x90, 0xc, 0xc4, 0x51, 0xdc, 0x18,

    /* U+0022 "\"" */
    0xbc, 0x7, 0x80, 0x7c, 0x40, 0xb8, 0x1f, 0xfc,
    0xf, 0x40, 0x34,

    /* U+0023 "#" */
    0x3, 0x3e, 0x4, 0xb9, 0x3, 0xd8, 0x81, 0x10,
    0x40, 0xf3, 0x60, 0x2e, 0x40, 0xdb, 0xf1, 0x5f,
    0xcc, 0xfe, 0x82, 0xb6, 0x9, 0xb8, 0x16, 0xd8,
    0x39, 0x47, 0x92, 0x16, 0x42, 0x3, 0x98, 0x18,
    0x81, 0xe6, 0x8, 0x2, 0x7, 0xe2, 0x6, 0x61,
    0x81, 0x3f, 0xd0, 0x7f, 0x51, 0xbf, 0x4, 0xd8,
    0x93, 0x71, 0xd, 0xa0, 0x32, 0x2, 0x92, 0x66,
    0x43, 0x3, 0x1e, 0x4, 0xd8, 0xf, 0xc4, 0x8,
    0x90, 0x18,

    /* U+0024 "$" */
    0x3, 0x97, 0x3, 0xff, 0xa8, 0xf5, 0x1f, 0x40,
    0x36, 0x84, 0x1, 0x27, 0x80, 0x42, 0x5e, 0x8d,
    0xe5, 0x0, 0x87, 0x3, 0x9b, 0x1, 0x98, 0x1f,
    0xd4, 0x56, 0x40, 0xf9, 0xb0, 0x90, 0x22, 0x3,
    0xa6, 0x84, 0x3b, 0xd0, 0x18, 0xb8, 0x2a, 0x14,
    0x81, 0xf2, 0xac, 0x20, 0x3f, 0xb8, 0xe3, 0x42,
    0x6, 0x34, 0x60, 0xf, 0x78, 0x36, 0x14, 0x83,
    0x54, 0x8, 0x25, 0x28, 0x12, 0xbe, 0x8f, 0x98,
    0x1f, 0xfc, 0x77, 0x0, 0xe0,

    /* U+0025 "%" */
    0x1, 0x3f, 0x40, 0x3d, 0xa8, 0x1a, 0xab, 0x4a,
    0x81, 0xa1, 0xa0, 0x65, 0x12, 0x44, 0x4, 0x9d,
    0x3, 0x10, 0x80, 0x20, 0x40, 0x56, 0x80, 0xf1,
    0x0, 0x41, 0x14, 0xc0, 0x38, 0x94, 0x1, 0x10,
    0x49, 0xc0, 0xfb, 0x3f, 0xce, 0x8a, 0xcd, 0xfc,
    0xc0, 0xdb, 0xf6, 0x14, 0xca, 0xed, 0x46, 0x7,
    0xc9, 0x39, 0x5d, 0x24, 0x80, 0x3e, 0xb0, 0xb0,
    0x40, 0x10, 0x3e, 0xa5, 0x81, 0xe6, 0x7, 0x9a,
    0xe0, 0x18, 0x20, 0x10, 0x1c, 0x64, 0x10, 0x5,
    0x42, 0x52, 0x0, 0xdc, 0xb0, 0x35, 0x1b, 0x1b,
    0x0,

    /* U+0026 "&" */
    0x3, 0x4d, 0xf3, 0x3, 0xf6, 0x6a, 0x38, 0xc0,
    0xf2, 0x2e, 0x3a, 0x68, 0x1f, 0xb8, 0x11, 0x3,
    0xe4, 0x20, 0xa, 0x20, 0x1f, 0x51, 0xba, 0xa8,
    0xf, 0xe2, 0x32, 0x3, 0xe9, 0x4c, 0x1c, 0x80,
    0x84, 0x3, 0x76, 0x74, 0xe2, 0x1d, 0x1, 0x4,
    0x0, 0xa8, 0xd4, 0x50, 0x22, 0x6, 0x54, 0x22,
    0x40, 0x9, 0x30, 0x3e, 0x24, 0x2, 0x9, 0xed,
    0x7a, 0x20, 0xc4, 0x2c, 0xca, 0x43, 0x3b, 0xc8,
    0x80, 0x33, 0x7e, 0xcc, 0x1, 0xa0,

    /* U+0027 "'" */
    0xbc, 0x8, 0x81, 0xbd,

    /* U+0028 "(" */
    0x2, 0xf8, 0x9, 0x8a, 0x5, 0x3, 0x0, 0x42,
    0x2, 0xa3, 0x81, 0x10, 0xc0, 0x90, 0x20, 0x7f,
    0x88, 0x1f, 0xfc, 0x52, 0x7, 0xf9, 0x2, 0x4,
    0x43, 0x2, 0xa3, 0x81, 0x10, 0x80, 0xd0, 0x30,
    0x26, 0x28,

    /* U+0029 ")" */
    0x3e, 0x80, 0x29, 0x8, 0x8, 0x20, 0x2, 0x10,
    0x13, 0x8, 0x7, 0x4, 0x2, 0x18, 0xf, 0x88,
    0x60, 0x7f, 0xf0, 0x8, 0x60, 0x7c, 0x86, 0x1,
    0xc1, 0x0, 0xc2, 0x4, 0x20, 0x10, 0x40, 0x52,
    0x10,

    /* U+002A "*" */
    0x2, 0x90, 0x4, 0x58, 0x19, 0x97, 0x31, 0x2d,
    0x1a, 0xcd, 0x23, 0xc8, 0x24, 0x0, 0x90, 0x39,
    0xd, 0xa4, 0x36, 0xec, 0x3, 0xec, 0xb, 0xf0,
    0x10,

    /* U+002B "+" */
    0x3, 0xff, 0x85, 0xe8, 0x1f, 0xfd, 0x6b, 0xfc,
    0x17, 0xf2, 0xc9, 0x40, 0xa5, 0x36, 0xb6, 0xe,
    0xd8, 0x81, 0xff, 0xc8,

    /* U+002C "," */
    0xe, 0x80, 0x8a, 0x4, 0x38, 0xe1, 0xc, 0x48,
    0x2a, 0x0,

    /* U+002D "-" */
    0x96, 0xe4, 0xbd, 0x80,

    /* U+002E "." */
    0xe, 0x91, 0x15, 0x8, 0x60,

    /* U+002F "/" */
    0x3, 0xe6, 0x80, 0xf2, 0x84, 0xf, 0x70, 0xc0,
    0xf2, 0x20, 0x79, 0xa, 0x7, 0xb8, 0x60, 0x79,
    0x10, 0x3c, 0x85, 0x3, 0xdc, 0x30, 0x3c, 0x90,
    0xf, 0x21, 0x80, 0xf7, 0xc, 0xf, 0x24, 0x3,
    0xc8, 0x60, 0x3d, 0xc3, 0x3, 0xc9, 0x0, 0xf3,
    0x1c, 0xf, 0x60, 0x80, 0xf2, 0x40, 0x3c, 0xc7,
    0x3, 0xc0,

    /* U+0030 "0" */
    0x3, 0x4d, 0xfa, 0x90, 0x38, 0xf6, 0x48, 0x2c,
    0xc0, 0xdc, 0x2f, 0xbc, 0x10, 0x80, 0x64, 0xa8,
    0x13, 0x82, 0x0, 0xc2, 0x1, 0xcc, 0x20, 0x8,
    0x20, 0x3c, 0x41, 0x3, 0xfc, 0xc3, 0x3, 0xff,
    0x96, 0xc3, 0x8, 0x20, 0x3c, 0x41, 0x18, 0x40,
    0x39, 0x84, 0x1, 0x92, 0xa0, 0x4e, 0x8, 0x5,
    0xc2, 0xfb, 0xc1, 0x8, 0x11, 0xec, 0x90, 0x59,
    0x80,

    /* U+0031 "1" */
    0xdf, 0xe4, 0xc9, 0x1, 0x5d, 0x88, 0xf, 0xff,
    0xc0,

    /* U+0032 "2" */
    0x0, 0xf7, 0xf5, 0x20, 0xe, 0x84, 0x10, 0xb2,
    0xc, 0xbf, 0xdb, 0xb1, 0x42, 0xf0, 0xd, 0x0,
    0x10, 0x3f, 0x10, 0x3f, 0x89, 0xc0, 0x7d, 0xc4,
    0x3, 0xec, 0x5a, 0x3, 0xd8, 0xb8, 0x7, 0xb1,
    0x70, 0xe, 0x3c, 0xc8, 0x3, 0x8e, 0x11, 0x81,
    0xc7, 0x0, 0xbb, 0x74, 0x60, 0x44, 0xf9, 0x0,

    /* U+0033 "3" */
    0x5f, 0xff, 0x6, 0x4f, 0x80, 0x10, 0x76, 0xee,
    0x3, 0x81, 0xf7, 0x14, 0x81, 0xec, 0x62, 0x3,
    0xd0, 0xa6, 0x7, 0xcc, 0x2f, 0x0, 0xf4, 0x86,
    0x1e, 0x3, 0x9b, 0x4e, 0x49, 0x1, 0xf9, 0xc,
    0x7, 0xe2, 0x3b, 0xec, 0xc, 0xd0, 0x40, 0x27,
    0xfa, 0x8, 0x5e, 0x64, 0x9, 0x66, 0x0,

    /* U+0034 "4" */
    0x3, 0xe7, 0xe8, 0x1f, 0xe3, 0xd, 0x3, 0xfd,
    0x87, 0x3, 0xfd, 0x44, 0x20, 0x7f, 0x44, 0x8c,
    0xf, 0xe4, 0xcd, 0x3, 0xf8, 0xd1, 0xc0, 0x3e,
    0xc0, 0xee, 0x29, 0x3, 0xfa, 0x16, 0x80, 0xfe,
    0x2c, 0x3f, 0xf4, 0x13, 0xf1, 0x4, 0xfe, 0x0,
    0x4e, 0xdb, 0xea, 0x26, 0xc0, 0x3f, 0xfa, 0x20,

    /* U+0035 "5" */
    0x1, 0xff, 0xe0, 0x38, 0x9f, 0x0, 0x21, 0x6d,
    0xe0, 0xc, 0x10, 0x3f, 0x11, 0xc0, 0xff, 0x4d,
    0x95, 0x90, 0x2e, 0x0, 0x92, 0x99, 0x80, 0x9f,
    0xec, 0xc4, 0x40, 0x78, 0xc6, 0x38, 0x1f, 0xb0,
    0x60, 0x81, 0xe2, 0x19, 0xd0, 0x81, 0x28, 0x3b,
    0xf, 0x7d, 0xe8, 0x69, 0x3c, 0x20, 0x85, 0x60,

    /* U+0036 "6" */
    0x3, 0x2b, 0xfd, 0x58, 0x1a, 0xd2, 0x4, 0x96,
    0x2, 0xa9, 0x37, 0xd9, 0xe8, 0x4, 0x86, 0x90,
    0x3e, 0xe2, 0x1, 0xfc, 0x82, 0x7b, 0xf6, 0x60,
    0x75, 0x81, 0x12, 0x94, 0xc, 0xa6, 0xbb, 0x2,
    0x40, 0x24, 0xc0, 0x8d, 0x1c, 0x11, 0x80, 0xe6,
    0x18, 0xa3, 0x1, 0xcc, 0x30, 0xc2, 0x60, 0x46,
    0x8e, 0x2, 0x89, 0xee, 0xc0, 0xd0, 0x5, 0x99,
    0x45, 0x58, 0x0,

    /* U+0037 "7" */
    0x7f, 0xff, 0x88, 0x11, 0x3e, 0x0, 0x40, 0x3d,
    0xba, 0x84, 0x7, 0xf5, 0x10, 0x3b, 0x40, 0x64,
    0x4c, 0x1, 0x10, 0x34, 0x10, 0xf, 0xc4, 0xc8,
    0xf, 0xd0, 0x50, 0x3f, 0x14, 0x18, 0x1f, 0xa8,
    0x60, 0x7f, 0x31, 0x0, 0xfc, 0xc3, 0x3, 0xfa,
    0xa, 0x7, 0xe6, 0x11, 0x3, 0x80,

    /* U+0038 "8" */
    0x2, 0x7b, 0xfa, 0xa0, 0x36, 0x84, 0x91, 0x56,
    0x80, 0x32, 0x5f, 0x5d, 0x85, 0x20, 0xe2, 0x81,
    0x8a, 0x4, 0x71, 0x80, 0xe4, 0x8, 0x69, 0x3d,
    0x97, 0x96, 0x80, 0x70, 0x9, 0xa0, 0x18, 0x3,
    0xa2, 0x7e, 0xd0, 0x54, 0x20, 0xcc, 0x1, 0x74,
    0x40, 0x22, 0x7, 0x20, 0x40, 0xfe, 0x20, 0x48,
    0x50, 0x31, 0xe1, 0x8a, 0x57, 0xd7, 0x61, 0x28,
    0x3, 0x42, 0x48, 0xa9, 0x80,

    /* U+0039 "9" */
    0x0, 0x6f, 0xf5, 0x40, 0x67, 0x91, 0x45, 0x58,
    0x5, 0x5, 0xd7, 0x72, 0xd0, 0x41, 0xa0, 0x37,
    0x10, 0x10, 0x3f, 0x88, 0x41, 0xa0, 0x37, 0x0,
    0x8b, 0x17, 0x5a, 0xe4, 0x80, 0xa5, 0x45, 0x36,
    0xec, 0xc, 0xaf, 0xed, 0x3, 0xc, 0xf, 0xe2,
    0x8, 0x1f, 0xa8, 0x60, 0x48, 0xd, 0x50, 0x80,
    0x1d, 0xfb, 0x3a, 0x18, 0x9, 0x21, 0x3a, 0x72,
    0x0,

    /* U+003A ":" */
    0x17, 0xa0, 0x86, 0x11, 0x50, 0xe9, 0x3, 0xff,
    0x8a, 0xe9, 0x11, 0x50, 0x86,

    /* U+003B ";" */
    0x17, 0xa0, 0x86, 0x11, 0x50, 0xe9, 0x3, 0xff,
    0x8a, 0xe8, 0x8, 0xa0, 0x43, 0x8e, 0x10, 0xc4,
    0x82, 0xa0,

    /* U+003C "<" */
    0x3, 0xf3, 0x20, 0x71, 0x9e, 0x30, 0x25, 0xb1,
    0xaa, 0x8c, 0xf4, 0xbf, 0x50, 0x8c, 0xdf, 0x0,
    0xc4, 0x1e, 0x80, 0xe9, 0x9a, 0xb9, 0x81, 0x8c,
    0xf0, 0x4f, 0x48, 0x19, 0xec, 0x69, 0x81, 0xe3,
    0x3a,

    /* U+003D "=" */
    0xbf, 0xfe, 0x59, 0x2f, 0xcd, 0xad, 0xfc, 0x40,
    0xff, 0xe4, 0x5f, 0xff, 0x2c, 0x97, 0xe6,

    /* U+003E ">" */
    0x64, 0xf, 0xdb, 0x4c, 0xf, 0x58, 0x27, 0x84,
    0xc, 0xf6, 0x27, 0xb1, 0x81, 0x8d, 0xf0, 0xc4,
    0x7, 0x3a, 0x1, 0x80, 0x33, 0xc1, 0x39, 0x5b,
    0x1a, 0xd8, 0xc0, 0x71, 0x3d, 0x20, 0x69, 0x98,
    0x1f, 0x0,

    /* U+003F "?" */
    0x0, 0xf7, 0xed, 0x48, 0x3, 0xe1, 0x39, 0x66,
    0x10, 0x7f, 0x67, 0x62, 0x7, 0xe0, 0x1a, 0x1,
    0xff, 0xc9, 0xa2, 0x1, 0xf6, 0x4d, 0x80, 0xf6,
    0x2e, 0x1, 0xe4, 0x4a, 0x1, 0xf3, 0x90, 0x7,
    0xe2, 0xd0, 0x1f, 0x8c, 0x20, 0x7e, 0x8f, 0x81,
    0xfb, 0x4, 0x6,

    /* U+0040 "@" */
    0x3, 0xca, 0x6f, 0xed, 0x8, 0x1f, 0xc7, 0x54,
    0x92, 0x49, 0xea, 0x7, 0xcb, 0xd, 0x91, 0xba,
    0x7a, 0xf9, 0x3, 0x1a, 0xb1, 0xa, 0x42, 0x7,
    0x45, 0x80, 0xd8, 0xd0, 0x75, 0x6d, 0x72, 0x62,
    0x9a, 0x1, 0x8e, 0x3, 0x19, 0xfa, 0x88, 0x5,
    0x11, 0x18, 0x90, 0x82, 0x30, 0xb, 0x1, 0x90,
    0x41, 0x20, 0x4, 0x18, 0x1c, 0xc0, 0xc7, 0x0,
    0xe0, 0x8, 0x1f, 0x70, 0x33, 0x3, 0xc4, 0xf,
    0xfe, 0x27, 0x0, 0xc1, 0x3, 0xb0, 0x19, 0x90,
    0x90, 0x4, 0x1c, 0xc, 0xd0, 0x20, 0x96, 0x18,
    0x90, 0x30, 0xfb, 0x34, 0x81, 0x2e, 0x28, 0x31,
    0xc0, 0x3a, 0x53, 0x6a, 0xe8, 0x49, 0x80, 0xb1,
    0xa0, 0x16, 0xfd, 0x50, 0x5f, 0xa8, 0x18, 0xd5,
    0x88, 0x1f, 0xfc, 0x45, 0x86, 0xc8, 0xda, 0x5e,
    0xc0, 0xfe, 0x3a, 0xb5, 0x21, 0x8, 0xc0, 0xe0,

    /* U+0041 "A" */
    0x3, 0xef, 0xd0, 0xf, 0xfe, 0x2, 0x0, 0xc0,
    0xff, 0xe0, 0x40, 0x83, 0x3, 0xfc, 0x8a, 0xa2,
    0x81, 0xfe, 0xe2, 0x4, 0x50, 0x1f, 0x8a, 0x24,
    0x20, 0x80, 0x7e, 0x82, 0x0, 0x27, 0x1, 0xf2,
    0x8, 0xa, 0x8, 0x7, 0xa0, 0x80, 0x64, 0x11,
    0x3, 0x98, 0x9f, 0xf0, 0xa, 0x6, 0x60, 0xa5,
    0xf0, 0x60, 0x6a, 0x3d, 0xbf, 0x31, 0x0, 0x22,
    0x88, 0x1f, 0x50, 0xc0, 0x41, 0xc0, 0xfc, 0x50,
    0x60,

    /* U+0042 "B" */
    0xff, 0xf5, 0x40, 0x72, 0x5c, 0x55, 0xa0, 0x35,
    0xbd, 0xa8, 0x44, 0xf, 0xe4, 0x81, 0x1, 0xfe,
    0x60, 0x81, 0xf8, 0xc2, 0x48, 0xb, 0xfe, 0xcc,
    0xe0, 0x32, 0x5c, 0x41, 0xc0, 0x6b, 0x7b, 0x76,
    0x68, 0x1f, 0xe8, 0x10, 0x1f, 0xfc, 0xb8, 0x7,
    0x5b, 0xee, 0xc5, 0x2, 0x4b, 0xc5, 0xe4, 0x0,

    /* U+0043 "C" */
    0x3, 0x9e, 0xfe, 0xa8, 0xe, 0x5e, 0x10, 0x42,
    0xb8, 0x9, 0x50, 0xf7, 0xdf, 0x22, 0x81, 0xa2,
    0x41, 0x2, 0x37, 0x21, 0x43, 0x60, 0x3e, 0x20,
    0x10, 0xa0, 0x7f, 0xc4, 0x10, 0x3f, 0xf9, 0xa4,
    0x10, 0x3f, 0xe4, 0x28, 0x1f, 0xf5, 0xd, 0x80,
    0xf8, 0x80, 0x34, 0x4a, 0x40, 0x8d, 0xc8, 0x2,
    0xa1, 0x6f, 0xbe, 0x45, 0x1, 0x2f, 0x8, 0x21,
    0x5c, 0x0,

    /* U+0044 "D" */
    0xff, 0xed, 0x50, 0x1e, 0x27, 0xca, 0xd0, 0x1d,
    0xb7, 0x7a, 0x56, 0x3, 0xfc, 0xb1, 0x2a, 0x7,
    0xfd, 0x82, 0x3, 0xff, 0x80, 0x83, 0x3, 0xfe,
    0x23, 0x81, 0xff, 0x71, 0xc0, 0xff, 0xb0, 0x1f,
    0xfc, 0x14, 0x18, 0x1f, 0xea, 0x10, 0x1f, 0xcb,
    0x23, 0x40, 0xb6, 0xef, 0x4a, 0xc0, 0x62, 0x7c,
    0xad, 0x1, 0x0,

    /* U+0045 "E" */
    0xff, 0xfc, 0x4, 0x4f, 0xe0, 0x2d, 0xbf, 0x1,
    0xff, 0xd8, 0xff, 0xe2, 0x4, 0x4f, 0xe0, 0x2d,
    0xbe, 0x3, 0xff, 0xb3, 0xb7, 0xe2, 0x0, 0x9f,
    0xcc,

    /* U+0046 "F" */
    0xff, 0xfc, 0x0, 0x9f, 0xc0, 0x36, 0xfc, 0x7,
    0xff, 0x53, 0x6f, 0x80, 0x89, 0xfc, 0x3, 0xff,
    0x88, 0x1f, 0xfe, 0x60,

    /* U+0047 "G" */
    0x3, 0x9e, 0xfe, 0xac, 0xe, 0x5e, 0x10, 0x42,
    0x98, 0x80, 0x54, 0x3d, 0xf7, 0xcc, 0xa0, 0x68,
    0x90, 0x40, 0x8c, 0xcc, 0x50, 0xd8, 0xf, 0x88,
    0x4, 0x28, 0x1f, 0xf1, 0x4, 0xf, 0xfe, 0x49,
    0xf4, 0x10, 0x40, 0xff, 0x90, 0x80, 0x7f, 0xd0,
    0x26, 0x7, 0xfd, 0x44, 0xa4, 0x8, 0xc0, 0x32,
    0xa1, 0x6f, 0xbe, 0x43, 0x81, 0x2f, 0x8, 0x21,
    0x4e, 0x80,

    /* U+0048 "H" */
    0xfc, 0x7, 0xed, 0xc8, 0x1f, 0xff, 0x7f, 0xff,
    0x10, 0x31, 0x3f, 0x80, 0xed, 0xbf, 0x10, 0x3f,
    0xfe, 0xe0,

    /* U+0049 "I" */
    0xfc, 0x7, 0xff, 0x70,

    /* U+004A "J" */
    0x1, 0xbf, 0xf2, 0x0, 0x89, 0xc0, 0x74, 0xdb,
    0x20, 0x3f, 0xff, 0xe0, 0x66, 0x18, 0xd8, 0x40,
    0x32, 0x8, 0x67, 0x67, 0x82, 0x0, 0xb0, 0x90,
    0x35, 0x80,

    /* U+004B "K" */
    0xfc, 0x7, 0xd7, 0xc0, 0x3f, 0xaa, 0x70, 0xf,
    0xd5, 0x38, 0x7, 0xea, 0x92, 0x1, 0xfa, 0xa4,
    0xa0, 0x7e, 0xa9, 0x28, 0x1f, 0xa2, 0x10, 0xf,
    0xd5, 0x80, 0xc0, 0x7e, 0x47, 0xa1, 0x80, 0xf8,
    0xe1, 0x49, 0x50, 0x3d, 0xc0, 0xb1, 0x4c, 0xe,
    0x20, 0x6e, 0x22, 0x3, 0xf8, 0xd1, 0x48, 0x1f,
    0xca, 0xe, 0x0,

    /* U+004C "L" */
    0xfc, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xe, 0xdf,
    0x40, 0x4, 0xfe,

    /* U+004D "M" */
    0xfc, 0x7, 0xfd, 0xf8, 0x4, 0x3, 0xfa, 0x1,
    0x99, 0x3, 0xe2, 0xc0, 0xee, 0x7, 0xd0, 0xe,
    0x65, 0x81, 0xc9, 0x40, 0x68, 0x20, 0x1d, 0x5,
    0x3, 0xa0, 0x80, 0x4c, 0xc0, 0x3c, 0xcb, 0x20,
    0x21, 0x60, 0x7d, 0xc7, 0x14, 0x40, 0x3f, 0x16,
    0x62, 0x50, 0x1f, 0xd0, 0x31, 0x40, 0xff, 0xa0,
    0x80, 0x7f, 0xf0, 0x1d, 0x60, 0x7f, 0xf0, 0x50,
    0x1f, 0x0,

    /* U+004E "N" */
    0xfc, 0x40, 0xfb, 0x72, 0x3, 0x81, 0xff, 0xc0,
    0x34, 0xf, 0xfe, 0x2, 0x80, 0x7f, 0xa8, 0x68,
    0xf, 0xe5, 0x45, 0x20, 0x7f, 0x26, 0x30, 0x1f,
    0xe8, 0x86, 0x3, 0xfd, 0x49, 0x40, 0x3f, 0xdc,
    0x36, 0x3, 0xf8, 0xd1, 0x8, 0x1f, 0xc9, 0x81,
    0xff, 0xc0, 0x88, 0xf, 0xfe, 0x5, 0x20, 0x0,

    /* U+004F "O" */
    0x3, 0x9e, 0xfe, 0xa8, 0xf, 0x97, 0x84, 0x10,
    0xae, 0x20, 0x65, 0x43, 0xdf, 0x7c, 0x8e, 0x20,
    0x54, 0x48, 0x20, 0x46, 0xb1, 0xc0, 0x40, 0xd8,
    0xf, 0xa1, 0x24, 0x10, 0xa0, 0x7f, 0x51, 0xc1,
    0x4, 0xf, 0xe4, 0x18, 0x1f, 0xfc, 0x52, 0x8,
    0x1f, 0xc8, 0x30, 0x85, 0x3, 0xfa, 0x8e, 0x20,
    0x6c, 0x7, 0xd0, 0x92, 0x1, 0x44, 0xa4, 0x8,
    0xd6, 0x38, 0x12, 0xa1, 0x6f, 0xbe, 0x47, 0x10,
    0x32, 0xf0, 0x82, 0x15, 0xc4, 0x0,

    /* U+0050 "P" */
    0xff, 0xec, 0xc0, 0xe2, 0x70, 0x33, 0x10, 0x2d,
    0xb7, 0xc8, 0xf0, 0x3f, 0x1a, 0x9, 0x1, 0xfc,
    0x83, 0x3, 0xff, 0x90, 0x50, 0x60, 0x7c, 0xb8,
    0x44, 0x7, 0xfd, 0x4a, 0xa0, 0x44, 0xe4, 0xed,
    0x1, 0xb6, 0xd6, 0x20, 0x3f, 0xfb, 0x60,

    /* U+0051 "Q" */
    0x3, 0x9e, 0xfe, 0xa8, 0xf, 0xcb, 0xc2, 0x8,
    0x57, 0x10, 0x39, 0x50, 0xb7, 0xde, 0xa3, 0x88,
    0x1a, 0x89, 0x48, 0x12, 0xac, 0x70, 0x28, 0x13,
    0x3, 0xe8, 0x49, 0x0, 0x42, 0x1, 0xfd, 0x47,
    0x0, 0x41, 0x3, 0xf9, 0x6, 0x7, 0xff, 0x1c,
    0x82, 0x7, 0xf2, 0xc, 0x2, 0x14, 0xf, 0xea,
    0x38, 0xa, 0x1a, 0x3, 0xe8, 0x49, 0x0, 0x30,
    0x58, 0x40, 0x8d, 0x63, 0x81, 0x9c, 0xf, 0x7d,
    0xf2, 0x18, 0x81, 0xcf, 0x32, 0x8, 0x33, 0x90,
    0x3e, 0x33, 0x76, 0xa, 0x2, 0xa0, 0x7f, 0x46,
    0x35, 0xae, 0x88, 0x1f, 0xd2, 0xa5, 0xb1,

    /* U+0052 "R" */
    0xff, 0xec, 0xc0, 0xe2, 0x70, 0x33, 0x10, 0x2d,
    0xb7, 0xc8, 0xf0, 0x3f, 0x1a, 0x9, 0x1, 0xfc,
    0x83, 0x3, 0xff, 0x90, 0x50, 0x60, 0x7c, 0xb8,
    0x44, 0x7, 0xfd, 0x4a, 0xa0, 0x44, 0xc8, 0x87,
    0x40, 0xdb, 0x57, 0x6, 0x40, 0xfe, 0xa3, 0x81,
    0xfc, 0x99, 0x80, 0x7f, 0x42, 0xd0,

    /* U+0053 "S" */
    0x2, 0x7b, 0xfb, 0x30, 0x36, 0x84, 0xf4, 0xc0,
    0x21, 0x2d, 0xb7, 0x94, 0x2, 0x1c, 0x81, 0x9b,
    0x1, 0x98, 0x1f, 0xd4, 0x56, 0x7, 0xe7, 0x4,
    0xfa, 0x20, 0x39, 0xf8, 0x8b, 0xbd, 0x1, 0xce,
    0xfc, 0x85, 0x20, 0x7c, 0x6b, 0x8, 0xf, 0xee,
    0x38, 0xd4, 0x81, 0x8c, 0x18, 0x35, 0xbe, 0xcf,
    0x83, 0x42, 0xe6, 0x4c, 0x15, 0x80,

    /* U+0054 "T" */
    0xff, 0xfe, 0xa8, 0x9c, 0x0, 0x9e, 0xbb, 0x5c,
    0x1d, 0xb4, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xb4,

    /* U+0055 "U" */
    0x1f, 0x80, 0xf8, 0xfc, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x91, 0x4, 0xf, 0x30, 0xc2, 0x14, 0xf,
    0x41, 0x85, 0xe, 0x1, 0xa9, 0xc, 0x1a, 0x1f,
    0xdf, 0x90, 0xc0, 0x4b, 0x32, 0x40, 0xbe, 0x40,

    /* U+0056 "V" */
    0x1b, 0xa0, 0x3f, 0xbf, 0x0, 0x82, 0x1, 0xf9,
    0x86, 0x1, 0x2, 0x40, 0x7d, 0x45, 0x2, 0x82,
    0x1, 0xe4, 0x51, 0x2, 0x61, 0x10, 0x3b, 0x8e,
    0x7, 0x31, 0x40, 0xc5, 0x14, 0x7, 0x50, 0xc0,
    0xd4, 0x50, 0x3c, 0x50, 0x60, 0x4c, 0x30, 0x3e,
    0xe2, 0x80, 0x61, 0x81, 0xf9, 0x12, 0x42, 0x8,
    0x7, 0xf5, 0x1d, 0x4, 0x7, 0xf9, 0x85, 0x44,
    0x3, 0xfe, 0x60, 0x9, 0x1, 0xff, 0x40, 0x10,
    0xf, 0x0,

    /* U+0057 "W" */
    0x3f, 0x1, 0xf6, 0xec, 0xf, 0x1f, 0x49, 0xc0,
    0x78, 0x8a, 0x7, 0xa8, 0xe1, 0xa, 0x7, 0x30,
    0x4, 0xf, 0x20, 0x85, 0x8, 0xe, 0xa1, 0x86,
    0x6, 0x24, 0x80, 0x13, 0x80, 0x89, 0x2a, 0x28,
    0x1a, 0x8e, 0x4, 0x85, 0x2, 0x43, 0x93, 0x1,
    0x90, 0x40, 0x54, 0x20, 0x2a, 0x10, 0xa1, 0x80,
    0x24, 0x80, 0xc4, 0xe0, 0x49, 0x0, 0x42, 0x80,
    0xa3, 0x81, 0xc8, 0x51, 0x47, 0x0, 0x4e, 0xc,
    0x20, 0x3a, 0x84, 0x10, 0x40, 0x54, 0x22, 0x10,
    0x1e, 0x26, 0x65, 0x1, 0x98, 0xb4, 0x38, 0x1f,
    0x21, 0x7, 0x3, 0x89, 0x30, 0x80, 0xfa, 0x81,
    0x20, 0x3a, 0x80, 0x40, 0x7e, 0x24, 0x18, 0x1e,
    0x60, 0x38, 0x18,

    /* U+0058 "X" */
    0x1f, 0x88, 0x1e, 0xbd, 0x80, 0xa3, 0x1, 0xcd,
    0x23, 0x0, 0x98, 0xa0, 0x46, 0xa, 0x6, 0x85,
    0x30, 0x1c, 0x50, 0x3d, 0xc4, 0x30, 0xb4, 0x7,
    0x8c, 0x19, 0x98, 0x7, 0xe6, 0x80, 0x70, 0x3f,
    0xc8, 0x2, 0x3, 0xfa, 0x86, 0x21, 0x3, 0xe6,
    0x8c, 0xa3, 0x81, 0xe3, 0x7, 0x9, 0xd, 0x3,
    0xb8, 0xa4, 0x5, 0x29, 0x0, 0xa9, 0x48, 0x6,
    0xe2, 0x90, 0x90, 0xd0, 0x38, 0xc1, 0xc0,

    /* U+0059 "Y" */
    0x1b, 0xa0, 0x3e, 0x5e, 0x80, 0xe2, 0x81, 0xf4,
    0x10, 0x1, 0x62, 0x1, 0xcc, 0xc2, 0x5, 0x3,
    0x20, 0x46, 0x16, 0x7, 0x51, 0xc0, 0xa0, 0x80,
    0x79, 0x21, 0x61, 0x2c, 0x7, 0xd0, 0x41, 0x45,
    0x3, 0xf1, 0x63, 0x88, 0x7, 0xfa, 0x10, 0x58,
    0x1f, 0xf2, 0x14, 0xf, 0xff, 0xb0,

    /* U+005A "Z" */
    0x1f, 0xff, 0xc8, 0x13, 0xf8, 0x9, 0x8d, 0xbf,
    0x11, 0x8, 0x1f, 0xa9, 0x6c, 0x7, 0xe8, 0x8c,
    0x3, 0xf2, 0x63, 0x1, 0xf8, 0xd1, 0x80, 0xfe,
    0xc2, 0x90, 0x3f, 0x60, 0xd0, 0x1f, 0xa1, 0x50,
    0xf, 0xcd, 0x8d, 0x3, 0xf2, 0x83, 0x81, 0xfd,
    0x40, 0x7d, 0xbe, 0x64, 0x8, 0x9f, 0xdc,

    /* U+005B "[" */
    0xff, 0x20, 0x9, 0x18, 0xb, 0x44, 0xf, 0xff,
    0xe5, 0xa2, 0x1, 0x23,

    /* U+005C "\\" */
    0x4c, 0xf, 0x8c, 0x40, 0x79, 0x8e, 0x7, 0xc5,
    0x1, 0xf5, 0x8, 0xf, 0x31, 0xc0, 0xf9, 0x20,
    0x1f, 0x60, 0x80, 0xf3, 0x1c, 0xf, 0x92, 0x1,
    0xf6, 0x8, 0xf, 0x31, 0xc0, 0xf9, 0x20, 0x1f,
    0x70, 0xc0, 0xf2, 0x18, 0xf, 0x92, 0x1, 0xf7,
    0xc, 0xf, 0x21, 0x80, 0xf9, 0x20, 0x1f, 0x70,
    0xc0,

    /* U+005D "]" */
    0xbf, 0xd3, 0x22, 0x1, 0xd8, 0x7, 0xff, 0xf1,
    0xd8, 0x3, 0x22, 0x0,

    /* U+005E "^" */
    0x3, 0x34, 0x7, 0xca, 0x50, 0x3e, 0x88, 0x30,
    0x38, 0x97, 0x74, 0xe, 0xa5, 0x52, 0x80, 0xce,
    0x82, 0x5c, 0x9, 0x86, 0x2, 0xa2, 0x2, 0xa0,
    0x26, 0x28, 0x46, 0x1, 0x9b, 0x0,

    /* U+005F "_" */
    0x3, 0xfd, 0xff, 0xfb, 0x6f, 0xf0,

    /* U+0060 "`" */
    0x2d, 0x80, 0x89, 0x4c, 0x4, 0xb0, 0xc0,

    /* U+0061 "a" */
    0xa, 0xff, 0x54, 0x1, 0xd4, 0x51, 0x55, 0x4,
    0x9f, 0x5d, 0x5, 0x6, 0x81, 0x99, 0x4, 0xf,
    0xfa, 0x7f, 0xc4, 0x4, 0x66, 0x5b, 0x10, 0xc,
    0x66, 0x94, 0xc0, 0xfc, 0x50, 0x6, 0x33, 0x69,
    0x80, 0xa4, 0x9, 0xa, 0xb0, 0x0,

    /* U+0062 "b" */
    0x3e, 0x81, 0xff, 0xe5, 0x9f, 0xb4, 0x20, 0x67,
    0xd9, 0x33, 0xc8, 0x8, 0x8d, 0xae, 0xc5, 0x3,
    0x62, 0x5, 0x10, 0x60, 0x9, 0x1, 0xdc, 0x60,
    0xc, 0xf, 0x30, 0xc0, 0x30, 0x3c, 0xc3, 0x0,
    0x48, 0xe, 0xe3, 0x1, 0x62, 0x5, 0x10, 0x60,
    0x8, 0xda, 0xec, 0x50, 0x27, 0xd9, 0x20, 0xf2,
    0x0,

    /* U+0063 "c" */
    0x2, 0x37, 0xfa, 0x1, 0x9e, 0x44, 0x83, 0xe4,
    0x28, 0x2e, 0xcf, 0x2, 0x10, 0x54, 0x4, 0xfb,
    0x4, 0x20, 0x3e, 0x20, 0x81, 0xf8, 0x82, 0x7,
    0xf1, 0x8, 0xf, 0xd0, 0x54, 0x4, 0xfb, 0xa,
    0xb, 0xb3, 0xc0, 0x80, 0x3c, 0x89, 0x7, 0xc8,

    /* U+0064 "d" */
    0x3, 0xfd, 0xf0, 0x1f, 0xfd, 0xb5, 0x7f, 0x66,
    0x7, 0x4a, 0x89, 0xa5, 0x2, 0x4c, 0x5d, 0x9e,
    0x20, 0x28, 0x2a, 0x2, 0x6c, 0x4, 0x42, 0x3,
    0xa8, 0x2, 0x8, 0x1e, 0x20, 0x8, 0x20, 0x78,
    0x81, 0x10, 0x80, 0xea, 0x5, 0x5, 0x20, 0x49,
    0x81, 0x26, 0x35, 0xad, 0x50, 0x1a, 0x54, 0xa1,
    0x28, 0x0,

    /* U+0065 "e" */
    0x2, 0x57, 0xf6, 0x60, 0x74, 0xa8, 0xa3, 0x30,
    0x12, 0x67, 0x65, 0xe8, 0xc0, 0x10, 0x72, 0x5,
    0x4b, 0x0, 0x41, 0x3, 0x90, 0x44, 0x7, 0xfe,
    0x60, 0x90, 0xb, 0x7f, 0x30, 0x43, 0x4b, 0xe0,
    0x10, 0x64, 0x4, 0x69, 0x0, 0xa0, 0xbf, 0x69,
    0x20, 0x13, 0xc8, 0x12, 0x59, 0x80,

    /* U+0066 "f" */
    0x2, 0x7b, 0xe6, 0x1, 0xc2, 0x80, 0xd4, 0x6b,
    0x98, 0x2, 0x8, 0x15, 0xe0, 0x3f, 0x86, 0x40,
    0x12, 0x83, 0xa0, 0x2d, 0x80, 0xff, 0xfa, 0x80,

    /* U+0067 "g" */
    0x2, 0x57, 0xf6, 0x63, 0x70, 0x12, 0xa2, 0x69,
    0x88, 0x4, 0xc5, 0xd9, 0xe9, 0x2, 0x82, 0xa0,
    0x25, 0x0, 0x88, 0x40, 0x73, 0x0, 0x41, 0x3,
    0xf8, 0x82, 0x7, 0xf8, 0x84, 0x7, 0x30, 0x28,
    0x2a, 0x2, 0x50, 0x9, 0x31, 0x75, 0xf4, 0x81,
    0xa5, 0x45, 0x19, 0x80, 0xe5, 0x7f, 0x66, 0x42,
    0x1, 0x50, 0x18, 0xf1, 0xc2, 0x4b, 0xf5, 0xd8,
    0x52, 0x5, 0x99, 0x24, 0x55, 0xa0,

    /* U+0068 "h" */
    0x3e, 0x81, 0xff, 0xe1, 0x9f, 0xd0, 0xc, 0xfb,
    0x24, 0x1e, 0x2, 0x25, 0xb6, 0x24, 0xc0, 0xb9,
    0x0, 0x60, 0xa0, 0x9, 0x1, 0x90, 0x19, 0x81,
    0xf1, 0x3, 0xff, 0xd6,

    /* U+0069 "i" */
    0x3e, 0x84, 0x10, 0x6d, 0x40, 0x44, 0xf, 0xa0,
    0x7f, 0xf7, 0x40,

    /* U+006A "j" */
    0x2, 0x3f, 0x1, 0x98, 0x20, 0x65, 0x28, 0x1c,
    0xd0, 0x1d, 0xf0, 0x1f, 0xff, 0xf0, 0x3c, 0x83,
    0xf, 0x5a, 0x1c, 0x1, 0x46, 0xa0,

    /* U+006B "k" */
    0x3e, 0x81, 0xff, 0xe8, 0x3b, 0xa0, 0x3e, 0x38,
    0xc4, 0x7, 0x8e, 0x11, 0x81, 0xe3, 0x84, 0x60,
    0x79, 0x60, 0xd8, 0xf, 0x2a, 0x1, 0x90, 0x3f,
    0x56, 0x38, 0x1f, 0x55, 0x9, 0x40, 0x39, 0x20,
    0xc, 0x1b, 0x1, 0xfd, 0x44, 0x20, 0x7e, 0x50,
    0x70,

    /* U+006C "l" */
    0x3e, 0x81, 0xff, 0xde,

    /* U+006D "m" */
    0x3e, 0x9b, 0xfb, 0x30, 0xb, 0x7e, 0xc8, 0xc,
    0xf2, 0x42, 0x52, 0xd8, 0xa2, 0x55, 0x81, 0x15,
    0xee, 0xc0, 0x95, 0xee, 0xa2, 0x1, 0xa8, 0x11,
    0x60, 0x28, 0x12, 0x40, 0x80, 0x10, 0x3b, 0x84,
    0x7, 0x10, 0x40, 0x30, 0x38, 0x82, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x80,

    /* U+006E "n" */
    0x3e, 0x9b, 0xfd, 0x0, 0xcf, 0x22, 0x83, 0xc0,
    0x44, 0xbe, 0xbc, 0x93, 0x2, 0xe0, 0x68, 0x28,
    0x2, 0x40, 0x64, 0x6, 0x60, 0x7c, 0x40, 0xff,
    0xf5, 0x80,

    /* U+006F "o" */
    0x2, 0x37, 0xf6, 0x80, 0x73, 0xc8, 0x99, 0xf4,
    0x1, 0x41, 0x76, 0x78, 0x28, 0x8, 0x2a, 0x2,
    0x6c, 0x18, 0x21, 0x1, 0xd4, 0x62, 0x8, 0x1e,
    0x21, 0x90, 0x40, 0xf1, 0xc, 0x10, 0x80, 0xea,
    0x30, 0x82, 0xa0, 0x26, 0xc1, 0x85, 0x5, 0xd9,
    0xe0, 0xc0, 0x4f, 0x22, 0x67, 0xc8,

    /* U+0070 "p" */
    0x3e, 0x99, 0xfb, 0x42, 0x6, 0x79, 0xa4, 0xf,
    0x20, 0x22, 0x5a, 0xd6, 0x82, 0x81, 0xb9, 0x2,
    0x6c, 0x18, 0x2, 0x40, 0x76, 0x18, 0x3, 0x3,
    0xcc, 0x30, 0xc, 0xf, 0x30, 0xc0, 0x12, 0x3,
    0xb8, 0xc0, 0x58, 0x81, 0x44, 0x18, 0x2, 0x36,
    0xbb, 0x14, 0x9, 0xf6, 0x48, 0x3c, 0x80, 0xe9,
    0xfd, 0x8, 0x1f, 0xfd, 0xa0,

    /* U+0071 "q" */
    0x2, 0x57, 0xf6, 0x63, 0xe0, 0x12, 0xa2, 0x69,
    0x40, 0x93, 0x17, 0x67, 0x88, 0xa, 0xa, 0x80,
    0x9b, 0x1, 0x10, 0x80, 0xea, 0x0, 0x82, 0x7,
    0x88, 0x2, 0x8, 0x1e, 0x20, 0x44, 0x20, 0x3a,
    0x81, 0x41, 0x50, 0x13, 0x60, 0x24, 0xc5, 0xd9,
    0xe2, 0x3, 0x4a, 0x89, 0xa5, 0x3, 0x95, 0xfd,
    0x98, 0x1f, 0xfd, 0xb0,

    /* U+0072 "r" */
    0x3e, 0x89, 0xe0, 0x7, 0xd8, 0xe0, 0x8, 0xbd,
    0x81, 0x54, 0x7, 0x20, 0x38, 0x81, 0xe6, 0x7,
    0xff, 0x50,

    /* U+0073 "s" */
    0x0, 0xb7, 0xf5, 0x40, 0x25, 0x24, 0x8a, 0x80,
    0x18, 0xfa, 0xec, 0xe0, 0x82, 0x6, 0x24, 0x9,
    0xb3, 0x20, 0x77, 0x25, 0x37, 0xa4, 0x1, 0xde,
    0xc4, 0x98, 0x81, 0x93, 0xac, 0x21, 0x8, 0x18,
    0x82, 0x9e, 0xf6, 0xba, 0x29, 0x2a, 0x9, 0xc,
    0xc0,

    /* U+0074 "t" */
    0x0, 0xe0, 0x1e, 0x8c, 0xf, 0xfe, 0x5, 0xe0,
    0x3f, 0x86, 0x40, 0x12, 0x83, 0xa0, 0x2d, 0x80,
    0xff, 0xef, 0x90, 0x80, 0xea, 0x2d, 0x66, 0x1,
    0xc2, 0x81,

    /* U+0075 "u" */
    0x5e, 0x81, 0xc7, 0xd0, 0x3f, 0xfe, 0x6c, 0x3,
    0xc, 0xe, 0xc0, 0x9, 0x98, 0x12, 0x60, 0x50,
    0x4d, 0x75, 0x20, 0x4b, 0x22, 0x84, 0xe0, 0x0,

    /* U+0076 "v" */
    0x1b, 0x90, 0x3d, 0xf8, 0x5, 0x14, 0xe, 0x41,
    0x80, 0x61, 0x81, 0xdc, 0x50, 0x26, 0x18, 0x11,
    0x48, 0x40, 0xa8, 0xa0, 0x54, 0x70, 0x31, 0x44,
    0x80, 0x32, 0x80, 0xee, 0x20, 0x62, 0x81, 0xe4,
    0x50, 0xa1, 0x81, 0xf5, 0x14, 0xb0, 0x3f, 0x30,
    0x85, 0x3, 0xf9, 0x82, 0x40, 0x60,

    /* U+0077 "w" */
    0xbc, 0xf, 0x7e, 0x3, 0xde, 0xf0, 0xc0, 0xc8,
    0x3, 0x3, 0x31, 0xd0, 0xa0, 0x6e, 0x3, 0x1,
    0xa8, 0x41, 0x12, 0x2, 0x4b, 0x1, 0x8b, 0x1,
    0xc5, 0x0, 0xc7, 0xe0, 0xc0, 0x31, 0x40, 0x20,
    0x80, 0x50, 0x90, 0x50, 0x14, 0x10, 0x26, 0x4e,
    0x60, 0x19, 0x39, 0x81, 0xa8, 0xb4, 0x28, 0xa,
    0x2d, 0xa, 0x6, 0x24, 0xd8, 0x90, 0x2, 0x49,
    0x92, 0x3, 0xa8, 0xa, 0x6, 0xa4, 0x50, 0x3c,
    0xc0, 0x30, 0x32, 0x0, 0xc0, 0x80,

    /* U+0078 "x" */
    0x3f, 0x80, 0xed, 0xc9, 0x41, 0x40, 0xa9, 0x84,
    0x34, 0x8c, 0x34, 0x8c, 0xa, 0x98, 0xa0, 0xa0,
    0x77, 0x14, 0x60, 0x3c, 0x50, 0x44, 0xf, 0x34,
    0x13, 0x3, 0x8c, 0x18, 0x42, 0x6, 0xe2, 0x9c,
    0x38, 0x14, 0x2d, 0x2, 0xcd, 0x9, 0x98, 0x5,
    0xa, 0x60,

    /* U+0079 "y" */
    0x1b, 0x90, 0x3d, 0xf8, 0x5, 0x14, 0xe, 0x41,
    0x80, 0x61, 0x81, 0xdc, 0x50, 0x26, 0x18, 0x11,
    0x48, 0x40, 0xa0, 0xa0, 0x54, 0x70, 0x39, 0x14,
    0x1, 0x94, 0x7, 0x41, 0xc3, 0x14, 0xf, 0x12,
    0x46, 0x86, 0x7, 0xd4, 0x72, 0xc0, 0xfc, 0xc1,
    0x14, 0xf, 0xe6, 0x11, 0x3, 0xf8, 0x8e, 0x7,
    0x88, 0x2, 0x8a, 0x3, 0x8e, 0xcb, 0x87, 0x3,
    0xc5, 0x94, 0x69, 0x3, 0xc0,

    /* U+007A "z" */
    0x1f, 0xfe, 0x81, 0x2f, 0x0, 0xc2, 0xde, 0x21,
    0xa0, 0x39, 0xb1, 0x80, 0x71, 0x83, 0x1, 0xee,
    0x28, 0x1e, 0xa6, 0x20, 0x39, 0xa4, 0x60, 0x72,
    0x86, 0x81, 0xea, 0x2, 0xde, 0x64, 0x1, 0x4b,
    0xb0,

    /* U+007B "{" */
    0x0, 0x77, 0xa0, 0x31, 0x2c, 0x8, 0x39, 0x86,
    0x18, 0x1f, 0xfc, 0xe9, 0x46, 0x0, 0x80, 0x20,
    0x1a, 0xa, 0x4, 0x41, 0x3, 0xff, 0x9e, 0xc3,
    0x2, 0x20, 0xe6, 0x3, 0x12, 0xc0,

    /* U+007C "|" */
    0xfc, 0x7, 0xff, 0x60,

    /* U+007D "}" */
    0xbf, 0x10, 0x18, 0x96, 0x0, 0xf1, 0x4, 0x9,
    0x86, 0x7, 0xff, 0x24, 0x81, 0xd8, 0x58, 0x1,
    0x80, 0x40, 0x28, 0x98, 0xc, 0x40, 0x88, 0x1f,
    0xfc, 0xb6, 0x18, 0x78, 0x82, 0x31, 0x2c, 0x0,

    /* U+007E "~" */
    0x13, 0xf3, 0x2, 0xcd, 0xc9, 0x25, 0x2c, 0xac,
    0xed, 0x96, 0x8c, 0xc8, 0x0, 0xbe, 0xc8, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 86, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 86, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14, .adv_w = 125, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 25, .adv_w = 225, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 91, .adv_w = 199, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 160, .adv_w = 270, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 241, .adv_w = 220, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 311, .adv_w = 67, .box_w = 2, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 315, .adv_w = 108, .box_w = 6, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 349, .adv_w = 108, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 382, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 407, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 427, .adv_w = 73, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 437, .adv_w = 123, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 441, .adv_w = 73, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 446, .adv_w = 113, .box_w = 9, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 496, .adv_w = 213, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 553, .adv_w = 118, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 562, .adv_w = 184, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 610, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 657, .adv_w = 214, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 705, .adv_w = 184, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 753, .adv_w = 197, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 812, .adv_w = 191, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 858, .adv_w = 206, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 919, .adv_w = 197, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 976, .adv_w = 73, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 989, .adv_w = 73, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1007, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1040, .adv_w = 186, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1055, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1089, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1132, .adv_w = 331, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1252, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1317, .adv_w = 242, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1365, .adv_w = 231, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1423, .adv_w = 264, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1474, .adv_w = 214, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1499, .adv_w = 203, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1519, .adv_w = 247, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1577, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1595, .adv_w = 99, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1599, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1625, .adv_w = 230, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1676, .adv_w = 190, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1687, .adv_w = 306, .box_w = 15, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1745, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1793, .adv_w = 269, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1863, .adv_w = 231, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1902, .adv_w = 269, .box_w = 17, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1989, .adv_w = 233, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2035, .adv_w = 199, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2089, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2105, .adv_w = 253, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2137, .adv_w = 228, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2203, .adv_w = 360, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2302, .adv_w = 215, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2365, .adv_w = 207, .box_w = 15, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2411, .adv_w = 210, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2458, .adv_w = 107, .box_w = 5, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 2470, .adv_w = 113, .box_w = 9, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 2519, .adv_w = 107, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2531, .adv_w = 187, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 2561, .adv_w = 160, .box_w = 10, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2567, .adv_w = 192, .box_w = 6, .box_h = 3, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 2574, .adv_w = 191, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2612, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2661, .adv_w = 183, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2701, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2751, .adv_w = 196, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2797, .adv_w = 113, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2821, .adv_w = 221, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2883, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2911, .adv_w = 89, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2922, .adv_w = 91, .box_w = 7, .box_h = 19, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 2944, .adv_w = 197, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2985, .adv_w = 89, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2989, .adv_w = 338, .box_w = 19, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3033, .adv_w = 218, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3059, .adv_w = 203, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3105, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3158, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3210, .adv_w = 131, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3228, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3269, .adv_w = 132, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3295, .adv_w = 217, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3319, .adv_w = 179, .box_w = 13, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3365, .adv_w = 288, .box_w = 18, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3435, .adv_w = 177, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3477, .adv_w = 179, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 3538, .adv_w = 167, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3571, .adv_w = 112, .box_w = 6, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3601, .adv_w = 96, .box_w = 2, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 3605, .adv_w = 112, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3637, .adv_w = 186, .box_w = 10, .box_h = 4, .ofs_x = 1, .ofs_y = 5}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] = {
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] = {
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 0, 13, 14, 15, 16, 17,
    18, 19, 12, 20, 20, 0, 0, 0,
    21, 22, 23, 24, 25, 22, 26, 27,
    28, 29, 29, 30, 31, 32, 29, 29,
    22, 33, 34, 35, 3, 36, 30, 37,
    37, 38, 39, 40, 41, 42, 43, 0,
    44, 0, 45, 46, 47, 48, 49, 50,
    51, 45, 52, 52, 53, 48, 45, 45,
    46, 46, 54, 55, 56, 57, 51, 58,
    58, 59, 58, 60, 41, 0, 0, 9
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] = {
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 12,
    18, 19, 20, 21, 21, 0, 0, 0,
    22, 23, 24, 25, 23, 25, 25, 25,
    23, 25, 25, 26, 25, 25, 25, 25,
    23, 25, 23, 25, 3, 27, 28, 29,
    29, 30, 31, 32, 33, 34, 35, 0,
    36, 0, 37, 38, 39, 39, 39, 0,
    39, 38, 40, 41, 38, 38, 42, 42,
    39, 42, 39, 42, 43, 44, 45, 46,
    46, 47, 46, 48, 0, 0, 35, 9
};

/*Kern values between classes*/
static const int8_t kern_class_values[] = {
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 3, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 14, 0, 9, -7, 0, 0, 0,
    0, -18, -19, 2, 15, 7, 5, -13,
    2, 16, 1, 13, 3, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 3, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, -6,
    5, 6, 0, 0, -3, 0, -2, 3,
    0, -3, 0, -3, -2, -6, 0, 0,
    0, 0, -3, 0, 0, -4, -5, 0,
    0, -3, 0, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -9, 0, -39, 0, 0, -6, 0,
    6, 10, 0, 0, -6, 3, 3, 11,
    6, -5, 6, 0, 0, -18, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, -16, 0, -13, -2, 0, 0, 0,
    0, 1, 12, 0, -10, -3, -1, 1,
    0, -5, 0, 0, -2, -24, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -26, -3, 12, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 0, 3, 0, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 12, 3, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -12, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 6, 3, 10, -3, 0, 0, 6,
    -3, -11, -44, 2, 9, 6, 1, -4,
    0, 12, 0, 10, 0, 10, 0, -30,
    0, -4, 10, 0, 11, -3, 6, 3,
    0, 0, 1, -3, 0, 0, -5, 26,
    0, 26, 0, 10, 0, 13, 4, 5,
    0, 0, 0, -12, 0, 0, 0, 0,
    1, -2, 0, 2, -6, -4, -6, 2,
    0, -3, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, -18, 0, -20, 0, 0, 0, 0,
    -2, 0, 32, -4, -4, 3, 3, -3,
    0, -4, 3, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -31, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 0, 0, -12, 0, 11, 0,
    -22, -31, -22, -6, 10, 0, 0, -21,
    0, 4, -7, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 10, -39, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 2,
    2, -4, -6, 0, -1, -1, -3, 0,
    0, -2, 0, 0, 0, -6, 0, -3,
    0, -7, -6, 0, -8, -11, -11, -6,
    0, -6, 0, -6, 0, 0, 0, 0,
    -3, 0, 0, 3, 0, 2, -3, 0,
    0, 0, 0, 3, -2, 0, 0, 0,
    -2, 3, 3, -1, 0, 0, 0, -6,
    0, -1, 0, 0, 0, 0, 0, 1,
    0, 4, -2, 0, -4, 0, -5, 0,
    0, -2, 0, 10, 0, 0, -3, 0,
    0, 0, 0, 0, -1, 1, -2, -2,
    0, -3, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 0,
    -3, -4, 0, 0, 0, 0, 0, 1,
    0, 0, -2, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, -2, -4, 0,
    0, -10, -2, -10, 6, 0, 0, -6,
    3, 6, 9, 0, -8, -1, -4, 0,
    -1, -15, 3, -2, 2, -17, 3, 0,
    0, 1, -17, 0, -17, -3, -28, -2,
    0, -16, 0, 6, 9, 0, 4, 0,
    0, 0, 0, 1, 0, -6, -4, 0,
    0, 0, 0, -3, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -2, -2, 0,
    -2, -4, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -2, -4, -3, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -2, 0, -6, 3, 0, 0, -4,
    2, 3, 3, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 2,
    0, 0, -3, 0, -3, -2, -4, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    -3, 0, 0, 0, 0, -4, -5, 0,
    0, 10, -2, 1, -10, 0, 0, 9,
    -16, -17, -13, -6, 3, 0, -3, -21,
    -6, 0, -6, 0, -6, 5, -6, -20,
    0, -9, 0, 0, 2, -1, 3, -2,
    0, 3, 0, -10, -12, 0, -16, -8,
    -7, -8, -10, -4, -9, -1, -6, -9,
    0, 1, 0, -3, 0, 0, 0, 2,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -2,
    0, -1, -3, 0, -5, -7, -7, -1,
    0, -10, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 1, -2, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 15, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, -6, 0, 0, 0,
    0, -16, -10, 0, 0, 0, -5, -16,
    0, 0, -3, 3, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 0, 0, 0, 4, 0,
    2, -6, -6, 0, -3, -3, -4, 0,
    0, 0, 0, 0, 0, -10, 0, -3,
    0, -5, -3, 0, -7, -8, -10, -3,
    0, -6, 0, -10, 0, 0, 0, 0,
    26, 0, 0, 2, 0, 0, -4, 0,
    0, -14, 0, 0, 0, 0, 0, -30,
    -6, 11, 10, -3, -13, 0, 3, -5,
    0, -16, -2, -4, 3, -22, -3, 4,
    0, 5, -11, -5, -12, -11, -13, 0,
    0, -19, 0, 18, 0, 0, -2, 0,
    0, 0, -2, -2, -3, -9, -11, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -2, -3, -5, 0,
    0, -6, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, -6, 0, 0, 6,
    -1, 4, 0, -7, 3, -2, -1, -8,
    -3, 0, -4, -3, -2, 0, -5, -5,
    0, 0, -3, -1, -2, -5, -4, 0,
    0, -3, 0, 3, -2, 0, -7, 0,
    0, 0, -6, 0, -5, 0, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 3, 0, -4, 0, -2, -4, -10,
    -2, -2, -2, -1, -2, -4, -1, 0,
    0, 0, 0, 0, -3, -3, -3, 0,
    0, 0, 0, 4, -2, 0, -2, 0,
    0, 0, -2, -4, -2, -3, -4, -3,
    3, 13, -1, 0, -9, 0, -2, 6,
    0, -3, -13, -4, 5, 0, 0, -15,
    -5, 3, -5, 2, 0, -2, -3, -10,
    0, -5, 2, 0, 0, -5, 0, 0,
    0, 3, 3, -6, -6, 0, -5, -3,
    -5, -3, -3, 0, -5, 2, -6, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, -4, 0, 0, -3, -3, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, 0, -2, 0,
    0, 0, -5, 0, -6, 0, 0, 0,
    -11, 0, 2, -7, 6, 1, -2, -15,
    0, 0, -7, -3, 0, -13, -8, -9,
    0, 0, -14, -3, -13, -12, -15, 0,
    -8, 0, 3, 21, -4, 0, -7, -3,
    -1, -3, -5, -9, -6, -12, -13, -7,
    0, 0, -2, 0, 1, 0, 0, -22,
    -3, 10, 7, -7, -12, 0, 1, -10,
    0, -16, -2, -3, 6, -29, -4, 1,
    0, 0, -21, -4, -17, -3, -23, 0,
    0, -22, 0, 19, 1, 0, -2, 0,
    0, 0, 0, -2, -2, -12, -2, 0,
    0, 0, 0, 0, -10, 0, -3, 0,
    -1, -9, -15, 0, 0, -2, -5, -10,
    -3, 0, -2, 0, 0, 0, 0, -14,
    -3, -11, -10, -3, -5, -8, -3, -5,
    0, -6, -3, -11, -5, 0, -4, -6,
    -3, -6, 0, 2, 0, -2, -11, 0,
    0, -6, 0, 0, 0, 0, 4, 0,
    2, -6, 13, 0, -3, -3, -4, 0,
    0, 0, 0, 0, 0, -10, 0, -3,
    0, -5, -3, 0, -7, -8, -10, -3,
    0, -6, 3, 13, 0, 0, 0, 0,
    26, 0, 0, 2, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -2, -6,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, -3, -3, 0, 0, -6, -3, 0,
    0, -6, 0, 5, -2, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0,
    6, 3, -3, 0, -10, -5, 0, 10,
    -11, -10, -6, -6, 13, 6, 3, -28,
    -2, 6, -3, 0, -3, 4, -3, -11,
    0, -3, 3, -4, -3, -10, -3, 0,
    0, 10, 6, 0, -9, 0, -18, -4,
    9, -4, -12, 1, -4, -11, -11, -3,
    3, 0, -5, 0, -9, 0, 3, 11,
    -7, -12, -13, -8, 10, 0, 1, -23,
    -3, 3, -5, -2, -7, 0, -7, -12,
    -5, -5, -3, 0, 0, -7, -7, -3,
    0, 10, 7, -3, -18, 0, -18, -4,
    0, -11, -19, -1, -10, -5, -11, -9,
    0, 0, -4, 0, -6, -3, 0, -3,
    -6, 0, 5, -11, 3, 0, 0, -17,
    0, -3, -7, -5, -2, -10, -8, -11,
    -7, 0, -10, -3, -7, -6, -10, -3,
    0, 0, 1, 15, -5, 0, -10, -3,
    0, -3, -6, -7, -9, -9, -12, -4,
    6, 0, -5, 0, -16, -4, 2, 6,
    -10, -12, -6, -11, 11, -3, 2, -30,
    -6, 6, -7, -5, -12, 0, -10, -13,
    -4, -3, -3, -3, -7, -10, -1, 0,
    0, 10, 9, -2, -21, 0, -19, -7,
    8, -12, -22, -6, -11, -13, -16, -11,
    0, 0, 0, 0, -4, 0, 0, 3,
    -4, 6, 2, -6, 6, 0, 0, -10,
    -1, 0, -1, 0, 1, 1, -3, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 3, 10, 1, 0, -4, 0,
    0, 0, 0, -2, -2, -4, 0, 0,
    1, 3, 0, 0, 0, 0, 3, 0,
    -3, 0, 12, 0, 6, 1, 1, -4,
    0, 6, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -19, 0, -3, 5, 0, 10, 0,
    0, 32, 4, -6, -6, 3, 3, -2,
    1, -16, 0, 0, 15, -19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -22, 12, 45, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, -6, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, -9, 0, 0, 1, 0,
    0, 3, 41, -6, -3, 10, 9, -9,
    3, 0, 0, 3, 3, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -42, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -9, 0, 0, 0, -9,
    0, 0, 0, 0, -7, -2, 0, 0,
    0, -7, 0, -4, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -5, 0, -9, 0, 0, 0, -5,
    3, -4, 0, 0, -9, -3, -7, 0,
    0, -9, 0, -3, 0, -15, 0, -4,
    0, 0, -26, -6, -13, -4, -12, 0,
    0, -21, 0, -9, -2, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -6, -3,
    0, 0, 0, 0, -7, 0, -7, 4,
    -4, 6, 0, -2, -7, -2, -5, -6,
    0, -4, -2, -2, 2, -9, -1, 0,
    0, 0, -28, -3, -4, 0, -7, 0,
    -2, -15, -3, 0, 0, -2, -3, 0,
    0, 0, 0, 2, 0, -2, -5, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, -7, 0, -2, 0, 0, 0, -6,
    3, 0, 0, 0, -9, -3, -6, 0,
    0, -9, 0, -3, 0, -15, 0, 0,
    0, 0, -31, 0, -6, -12, -16, 0,
    0, -21, 0, -2, -5, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -5, -2,
    1, 0, 0, 5, -4, 0, 10, 16,
    -3, -3, -10, 4, 16, 5, 7, -9,
    4, 13, 4, 9, 7, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 15, -6, -3, 0, -3, 26,
    14, 26, 0, 0, 0, 3, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -27, -4, -3, -13, -16, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -27, -4, -3, -13, -16, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -3, 0, 0, 0,
    -7, 3, 0, -3, 3, 6, 3, -10,
    0, -1, -3, 3, 0, 3, 0, 0,
    0, 0, -8, 0, -3, -2, -6, 0,
    -3, -13, 0, 20, -3, 0, -7, -2,
    0, -2, -5, 0, -3, -9, -6, -4,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -27, -4, -3, -13, -16, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, -10, -4, -3, 10,
    -3, -3, -13, 1, -2, 1, -2, -9,
    1, 7, 1, 3, 1, 3, -8, -13,
    -4, 0, -12, -6, -9, -13, -12, 0,
    -5, -6, -4, -4, -3, -2, -4, -2,
    0, -2, -1, 5, 0, 5, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, -3, -3, 0,
    0, -9, 0, -2, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, 0, 0, 0, -3, 0, 0, -5,
    -3, 3, 0, -5, -6, -2, 0, -9,
    -2, -7, -2, -4, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 10, 0, 0, -6, 0,
    0, 0, 0, -4, 0, -3, 0, 0,
    0, 0, -2, 0, -7, 0, 0, 13,
    -4, -11, -10, 2, 4, 4, -1, -9,
    2, 5, 2, 10, 2, 11, -2, -9,
    0, 0, -13, 0, 0, -10, -9, 0,
    0, -6, 0, -4, -5, 0, -5, 0,
    -5, 0, -2, 5, 0, -3, -10, -3,
    0, 0, -3, 0, -6, 0, 0, 4,
    -7, 0, 3, -3, 3, 0, 0, -11,
    0, -2, -1, 0, -3, 4, -3, 0,
    0, 0, -13, -4, -7, 0, -10, 0,
    0, -15, 0, 12, -3, 0, -6, 0,
    2, 0, -3, 0, -3, -10, 0, -3,
    0, 0, 0, 0, -2, 0, 0, 3,
    -4, 1, 0, 0, -4, -2, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 0, 7, 0, 0, -3, 0,
    0, 0, 0, 1, 0, -3, -3, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes = {
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 60,
    .right_class_cnt     = 48,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
    /*Store all the custom data of the font*/
    static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 1,
    .bitmap_format = 1,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t test_font_montserrat_ascii_3bpp_compressed = {
#else
lv_font_t test_font_montserrat_ascii_3bpp_compressed = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 22,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if TEST_FONT_MONTSERRAT_ASCII_3BPP_COMPRESSED*/

#endif /*LV_BUILD_TEST*/
