// ---------------------------------------------------------------------------
// - Csmsid.hxx                                                              -
// - afnix:csm service - serial id definition                                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CSMSID_HXX
#define  AFNIX_CSMSID_HXX

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace afnix {
  // csm serial id [@0x0040]
  static const t_byte SRL_PART_SID = 0x0001; // part id
  static const t_byte SRL_BLOB_SID = 0x0002; // blob id
  static const t_byte SRL_BLOC_SID = 0x0003; // bloc id
  static const t_byte SRL_CBLB_SID = 0x0004; // carrier id
  static const t_byte SRL_DBLB_SID = 0x0005; // delegate id
  static const t_byte SRL_TCKR_SID = 0x0006; // tracker id
  static const t_byte SRL_COLN_SID = 0x0007; // collection id
  static const t_byte SRL_DOMN_SID = 0x0008; // domain id
  static const t_byte SRL_CRED_SID = 0x0020; // credential id
  static const t_byte SRL_IDTY_SID = 0x0021; // identity id
  static const t_byte SRL_AUTH_SID = 0x0022; // authority id
  static const t_byte SRL_PCPL_SID = 0x0023; // principal id
  static const t_byte SRL_XACT_SID = 0x0030; // act id
  static const t_byte SRL_VISA_SID = 0x0031; // visa id
  static const t_byte SRL_SESS_SID = 0x0040; // session id

  // the csm dispatch id
  static const t_word SRL_DEOD_CSM = 0x0040U;
}

#endif
