!{\src2tex{textfont=tt}}
!!****f* ABINIT/difrel
!! NAME
!! difrel
!!
!! FUNCTION
!! Calculate the differential of the relativistic to Vx.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density in real space, at a specific grid point
!!
!! OUTPUT
!!  function difrel=differential of the relativistic to Vx
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function difrel(rho)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: difrel
 real(dp),intent(in) :: rho

!Local variables-------------------------------
!scalars
 real(dp) :: b,bb,bb1,rs

! *************************************************************************

 rs=(3.0/(4.0*pi*rho))**third
 b=0.0140/rs
 bb=b*b
 bb1=1.0+bb
 difrel=(1.5/(b*bb1))-1.5*log(b+sqrt(bb1))*(1.0+2.0*bb)*(bb1**(-1.5))/bb
 difrel=difrel*(-0.0140)/(rs*rs)

 return
 end function difrel
!!***
