/*
 * SPDX-FileCopyrightText: Copyright (c) 2002 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef _cl5080_h_
#define _cl5080_h_

#ifdef __cplusplus
extern "C" {
#endif

#include "nvtypes.h"

#define NV50_DEFERRED_API_CLASS                                    (0x00005080)

/* NvRmAlloc parameters */
typedef struct {
    // Should the deferred api completion trigger an event
    NvBool notifyCompletion;
} NV5080_ALLOC_PARAMS;

/* dma method offsets, fields, and values */
#define NV5080_SET_OBJECT                                          (0x00000000)
#define NV5080_NO_OPERATION                                        (0x00000100)
#define NV5080_DEFERRED_API                                        (0x00000200)
#define NV5080_DEFERRED_API_HANDLE                                 31:0

// Class-specific allocation capabilities

#ifdef __cplusplus
};     /* extern "C" */
#endif

#endif /* _cl5080_h_ */

