/*
 * Copyright (C) 1997-2001 Id Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 * =======================================================================
 *
 * The header file for the upper level key event processing
 *
 * =======================================================================
 */

#ifndef CL_HEADER_KEYBOARD_H
#define CL_HEADER_KEYBOARD_H

#include "../../common/header/shared.h" /* for qboolean etc */

/* Max length of a console command line. 1024
 * chars allow for a vertical resolution of
 * 8192 pixel which should be enough for the
 * years to come. */
#define MAXCMDLINE 1024

/* number of console command lines saved in history,
 * must be a power of two, because we use & (NUM_KEY_LINES-1)
 * instead of % so -1 wraps to NUM_KEY_LINES-1 */
#define NUM_KEY_LINES 32

/*
 * the joystick altselector key is pressed
 * => K_JOYx turns into K_JOYx_ALT
 */
extern qboolean joy_altselector_pressed;

/* these are the key numbers that should be passed to Key_Event
   they must be mached by the low level key event processing! */
enum QKEYS {
	K_TAB = 9,
	K_ENTER = 13,
	K_ESCAPE = 27,
	K_SPACE = 32,

	K_BACKSPACE = 127,

	K_COMMAND = 128,
	K_CAPSLOCK,
	K_POWER,
	K_PAUSE,

	K_UPARROW,
	K_DOWNARROW,
	K_LEFTARROW,
	K_RIGHTARROW,

	K_ALT,
	K_CTRL,
	K_SHIFT,
	K_INS,
	K_DEL,
	K_PGDN,
	K_PGUP,
	K_HOME,
	K_END,

	K_F1,
	K_F2,
	K_F3,
	K_F4,
	K_F5,
	K_F6,
	K_F7,
	K_F8,
	K_F9,
	K_F10,
	K_F11,
	K_F12,
	K_F13,
	K_F14,
	K_F15,

	K_KP_HOME,
	K_KP_UPARROW,
	K_KP_PGUP,
	K_KP_LEFTARROW,
	K_KP_5,
	K_KP_RIGHTARROW,
	K_KP_END,
	K_KP_DOWNARROW,
	K_KP_PGDN,
	K_KP_ENTER,
	K_KP_INS,
	K_KP_DEL,
	K_KP_SLASH,
	K_KP_MINUS,
	K_KP_PLUS,
	K_KP_NUMLOCK,
	K_KP_STAR,
	K_KP_EQUALS,

	K_MOUSE1,
	K_MOUSE2,
	K_MOUSE3,
	K_MOUSE4,
	K_MOUSE5,

	K_MWHEELDOWN,
	K_MWHEELUP,

	K_JOY1,
	K_JOY2,
	K_JOY3,
	K_JOY4,
	K_JOY5,
	K_JOY6,
	K_JOY7,
	K_JOY8,
	K_JOY9,
	K_JOY10,
	K_JOY11,
	K_JOY12,
	K_JOY13,
	K_JOY14,
	K_JOY15,
	K_JOY16,
	K_JOY17,
	K_JOY18,
	K_JOY19,
	K_JOY20,
	K_JOY21,
	K_JOY22,
	K_JOY23,
	K_JOY24,
	K_JOY25,
	K_JOY26,
	K_JOY27,
	K_JOY28,
	K_JOY29,
	K_JOY30,
	K_JOY31,
	K_JOY32,

	K_HAT_UP,
	K_HAT_RIGHT,
	K_HAT_DOWN,
	K_HAT_LEFT,

	K_TRIG_LEFT,
	K_TRIG_RIGHT,

	// add other joystick/controller keys before this one
	// and adjust it accordingly, also remember to add corresponding _ALT key below!
	K_JOY_LAST_REGULAR = K_TRIG_RIGHT,

	/* Can't be mapped to any action (=> not regular) */
	K_JOY_BACK,

	K_JOY1_ALT,
	K_JOY2_ALT,
	K_JOY3_ALT,
	K_JOY4_ALT,
	K_JOY5_ALT,
	K_JOY6_ALT,
	K_JOY7_ALT,
	K_JOY8_ALT,
	K_JOY9_ALT,
	K_JOY10_ALT,
	K_JOY11_ALT,
	K_JOY12_ALT,
	K_JOY13_ALT,
	K_JOY14_ALT,
	K_JOY15_ALT,
	K_JOY16_ALT,
	K_JOY17_ALT,
	K_JOY18_ALT,
	K_JOY19_ALT,
	K_JOY20_ALT,
	K_JOY21_ALT,
	K_JOY22_ALT,
	K_JOY23_ALT,
	K_JOY24_ALT,
	K_JOY25_ALT,
	K_JOY26_ALT,
	K_JOY27_ALT,
	K_JOY28_ALT,
	K_JOY29_ALT,
	K_JOY30_ALT,
	K_JOY31_ALT,
	K_JOY32_ALT,

	K_HAT_UP_ALT,
	K_HAT_RIGHT_ALT,
	K_HAT_DOWN_ALT,
	K_HAT_LEFT_ALT,

	K_TRIG_LEFT_ALT,
	K_TRIG_RIGHT_ALT,

	// add other joystick/controller keys before this one and adjust it accordingly
	K_JOY_LAST_REGULAR_ALT = K_TRIG_RIGHT_ALT,

	K_AUX1,
	K_AUX2,
	K_AUX3,
	K_AUX4,
	K_AUX5,
	K_AUX6,
	K_AUX7,
	K_AUX8,
	K_AUX9,
	K_AUX10,
	K_AUX11,
	K_AUX12,
	K_AUX13,
	K_AUX14,
	K_AUX15,
	K_AUX16,
	K_AUX17,
	K_AUX18,
	K_AUX19,
	K_AUX20,
	K_AUX21,
	K_AUX22,
	K_AUX23,
	K_AUX24,
	K_AUX25,
	K_AUX26,
	K_AUX27,
	K_AUX28,
	K_AUX29,
	K_AUX30,
	K_AUX31,
	K_AUX32,

	K_SUPER,
	K_COMPOSE,
	K_MODE,
	K_HELP,
	K_PRINT,
	K_SYSREQ,
	K_SCROLLOCK,
	K_MENU,
	K_UNDO,

	K_LAST
};

extern char		*keybindings[K_LAST];
extern int		key_repeats[K_LAST];
extern int		anykeydown;
extern char		chat_buffer[];
extern int		chat_bufferlen;
extern int		chat_cursorpos;
extern qboolean	chat_team;

void Char_Event(int key);
void Key_Event(int key, qboolean down, qboolean special);
void Key_Init(void);
void Key_WriteBindings(FILE *f);
void Key_ReadConsoleHistory();
void Key_WriteConsoleHistory();
void Key_SetBinding(int keynum, char *binding);
void Key_MarkAllUp(void);
void Haptic_Feedback(char *name, int effect_volume, int effect_x, int effect_y, int effect_z);
int Key_GetMenuKey(int key);

#endif
