/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class NamedNodeCollector
implements IBTreeVisitor,
IPDOMVisitor {
    private final PDOMLinkage linkage;
    private final char[] matchChars;
    private final boolean prefixLookup;
    private final IContentAssistMatcher contentAssistMatcher;
    private final boolean caseSensitive;
    private IProgressMonitor monitor = null;
    private int monitorCheckCounter = 0;
    private List<PDOMNamedNode> nodes = new ArrayList<PDOMNamedNode>();

    public NamedNodeCollector(PDOMLinkage linkage, char[] name) {
        this(linkage, name, false, false, true);
    }

    public NamedNodeCollector(PDOMLinkage linkage, char[] name, boolean prefixLookup, boolean contentAssistLookup, boolean caseSensitive) {
        this.linkage = linkage;
        if (contentAssistLookup) {
            IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(name);
            this.contentAssistMatcher = matcher.matchRequiredAfterBinarySearch() ? matcher : null;
            this.matchChars = matcher.getPrefixForBinarySearch();
            this.prefixLookup = true;
            this.caseSensitive = false;
        } else {
            this.contentAssistMatcher = null;
            this.matchChars = name;
            this.prefixLookup = prefixLookup;
            this.caseSensitive = caseSensitive;
        }
    }

    public void setMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    @Override
    public final int compare(long record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        IString rhsName = PDOMNamedNode.getDBName(this.linkage.getDB(), record);
        return this.compare(rhsName);
    }

    private int compare(IString rhsName) throws CoreException {
        int cmp;
        if (this.prefixLookup) {
            cmp = rhsName.comparePrefix(this.matchChars, false);
            if (this.caseSensitive) {
                cmp = cmp == 0 ? rhsName.comparePrefix(this.matchChars, true) : cmp;
            }
        } else {
            cmp = this.caseSensitive ? rhsName.compareCompatibleWithIgnoreCase(this.matchChars) : rhsName.compare(this.matchChars, false);
        }
        return cmp;
    }

    @Override
    public final boolean visit(long record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (record == 0L) {
            return true;
        }
        PDOMNode node = PDOMNode.load(this.linkage.getPDOM(), record);
        if (node instanceof PDOMNamedNode) {
            return this.addNode((PDOMNamedNode)node);
        }
        return true;
    }

    protected boolean addNode(PDOMNamedNode node) throws CoreException {
        if (this.contentAssistMatcher == null || this.contentAssistMatcher.match(node.getDBName().getChars())) {
            this.nodes.add(node);
        }
        return true;
    }

    protected final List<PDOMNamedNode> getNodeList() {
        return this.nodes;
    }

    public final PDOMNamedNode[] getNodes() {
        return this.nodes.toArray(new PDOMNamedNode[this.nodes.size()]);
    }

    @Override
    public final boolean visit(IPDOMNode node) throws CoreException {
        PDOMNamedNode pb;
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (node instanceof PDOMNamedNode && this.compare((pb = (PDOMNamedNode)node).getDBName()) == 0) {
            this.addNode(pb);
        }
        return false;
    }

    private void checkCancelled() {
        if (++this.monitorCheckCounter % 4096 == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public final void leave(IPDOMNode node) throws CoreException {
    }
}

