/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel;

import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.SetDebuggerFocusEvent;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public final class SelectionSynchronizer
implements IDebugContextListener,
ISelectionChangedListener {
    private static final int DELAY = 100;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private Boolean linkedSelection;
    private final IVMEventListener listener;
    private final AtomicBoolean noSelectionFromCuda = new AtomicBoolean(false);
    private ICudaRuntimeObject selected;
    private final DsfSession session;
    private final AtomicInteger stopped = new AtomicInteger(0);

    private static ICudaRuntimeObject getObject(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IDMContext dmc = (IDMContext)((IAdaptable)element).getAdapter(IDMContext.class);
            if (dmc instanceof KernelCallSite) {
                return ((KernelCallSite)dmc).getParent();
            }
            if (dmc instanceof ICudaRuntimeObject) {
                return (ICudaRuntimeObject)dmc;
            }
            return (ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)dmc, ICudaRuntimeObject.class);
        }
        return null;
    }

    public SelectionSynchronizer(ScheduledExecutorService executor, DsfSession session, IVMEventListener listener) {
        this.executor = executor;
        this.session = session;
        this.listener = listener;
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection context = event.getContext();
        this.fromDebugView(context, false);
    }

    private void force() {
        if (this.stopped.get() == 0) {
            IAdaptable debugContext = DebugUITools.getDebugContext();
            StructuredSelection selection = new StructuredSelection((Object)debugContext);
            this.fromDebugView((ISelection)selection, true);
        } else {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    SelectionSynchronizer.this.force();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private void fromCudaView(ISelection selection, final boolean force) {
        if (!this.noSelectionFromCuda.get()) {
            this.schedule(selection, new Runnable(){

                @Override
                public void run() {
                    if (Boolean.TRUE.equals(SelectionSynchronizer.this.linkedSelection) || force) {
                        SelectionSynchronizer.this.session.dispatchEvent((Object)new SetDebuggerFocusEvent(SelectionSynchronizer.this.selected), null);
                    }
                }
            }, force);
        }
    }

    private void fromDebugView(ISelection selection, final boolean force) {
        this.schedule(selection, new Runnable(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(SelectionSynchronizer.this.linkedSelection) || force) {
                    SelectionSynchronizer.this.listener.handleEvent((Object)new LinkedSelectionChangedEvent(SelectionSynchronizer.this.selected), null);
                }
            }
        }, force);
    }

    public void maintainingSelection(Runnable runnable) {
        this.stopped.incrementAndGet();
        StructuredSelection remembered = this.selected == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.selected);
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            this.executor.schedule(new Runnable((ISelection)remembered){
                private final /* synthetic */ ISelection val$remembered;
                {
                    this.val$remembered = iSelection;
                }

                @Override
                public void run() {
                    if (SelectionSynchronizer.this.stopped.decrementAndGet() == 0 && !this.val$remembered.isEmpty()) {
                        SelectionSynchronizer.this.fromDebugView(this.val$remembered, true);
                    }
                }
            }, 100L, TimeUnit.MILLISECONDS);
            throw throwable;
        }
        this.executor.schedule(new /* invalid duplicate definition of identical inner class */, 100L, TimeUnit.MILLISECONDS);
    }

    public void repost() {
        if (this.selected != null) {
            final StructuredSelection selection = new StructuredSelection((Object)this.selected);
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    SelectionSynchronizer.this.fromDebugView((ISelection)selection, true);
                }
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized boolean sameSelection(ICudaRuntimeObject selection) {
        if (!(this.selected == selection || this.selected != null && this.selected.equals(selection))) {
            this.selected = selection;
            return false;
        }
        return true;
    }

    private synchronized void schedule(ISelection selection, final Runnable command, final boolean force) {
        ICudaRuntimeObject object;
        if (this.stopped.get() == 0 && (object = SelectionSynchronizer.getObject(selection)) != null) {
            object.toLogicalElement(new DataRequestMonitor<ICudaRuntimeObject>(ImmediateExecutor.getInstance(), null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    if (SelectionSynchronizer.this.future != null && !SelectionSynchronizer.this.future.isDone()) {
                        SelectionSynchronizer.this.future.cancel(false);
                    }
                    if (this.getData() != null && (force || !SelectionSynchronizer.this.sameSelection((ICudaRuntimeObject)this.getData()))) {
                        SelectionSynchronizer.this.future = SelectionSynchronizer.this.executor.schedule(command, 100L, TimeUnit.MILLISECONDS);
                    }
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.noSelectionFromCuda.get()) {
            ISelection s = event.getSelection();
            if (this.session.isActive()) {
                this.fromCudaView(s, false);
            }
        }
    }

    public synchronized void setLinkedSelection(boolean linked) {
        if (this.linkedSelection == null && linked) {
            this.linkedSelection = linked;
            this.force();
        } else {
            Boolean newValue = linked;
            if (!newValue.equals(this.linkedSelection)) {
                this.linkedSelection = newValue;
                if (linked && this.selected != null) {
                    StructuredSelection selection = new StructuredSelection((Object)this.selected);
                    this.fromCudaView((ISelection)selection, true);
                }
            }
        }
    }

    public void setSuspended(boolean suspended) {
        if (this.noSelectionFromCuda.compareAndSet(!suspended, suspended) && suspended) {
            this.repost();
        }
    }
}

