/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.cuda.ide.debug.core.Activator;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GDBSolibBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.IMILaunchConfigurationComponent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class RemodeSolibBlock
extends GDBSolibBlock {
    private Button downloadSO;

    public RemodeSolibBlock(IMILaunchConfigurationComponent solibSearchBlock, boolean autoSolib, boolean stopOnSolibEvents) {
        super(solibSearchBlock, autoSolib, stopOnSolibEvents);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        this.downloadSO = new Button(control, 32);
        this.downloadSO.setText("Download shared libraries from remote target");
        this.downloadSO.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemodeSolibBlock.this.updateButtons();
                RemodeSolibBlock.this.changed();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        if (this.downloadSO != null) {
            try {
                this.downloadSO.setSelection(Boolean.TRUE.equals(configuration.getAttribute("lc.downloadso", true)));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (this.downloadSO != null) {
            configuration.setAttribute("lc.downloadso", this.downloadSO.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("lc.downloadso", true);
    }
}

