/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.ibm.icu.util.StringTokenizer;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaFocusChangedEvent;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.IFocus;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.util.DeviceThreadComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public final class CudaDebugUISessionState
extends AbstractDsfService
implements IDebuggerUIState {
    protected static final int FEW = 5;
    private static final String PROPERTY_PINNED_THREADS = "pinnedThreads";
    private DeviceThread currentFocus;
    private final AtomicReference<Boolean> fewKernels = new AtomicReference<Object>(null);
    private boolean filteringOverride = true;
    private int generation = 0;
    private final ILaunchConfiguration lc;
    private final Map<String, Set<Tuple<CudaCoord, CudaCoord, ?>>> pinned = new HashMap();
    private final Map<ThreadKey, Integer> remembered = new HashMap<ThreadKey, Integer>();
    private final ConcurrentHashMap<Kernel, Object> stickyKernels = new ConcurrentHashMap();

    private static ThreadKey getThreadKey(DeviceThread thread) {
        Block block;
        Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)thread, Kernel.class);
        if (kernel != null && (block = (Block)DMContexts.getAncestorOfType((IDMContext)thread, Block.class)) != null) {
            return new ThreadKey(kernel.getId(), block.getBlockIdx(), thread.getThreadIdx());
        }
        return null;
    }

    private static boolean isSameKernel(DeviceThread t1, DeviceThread t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return CoreUtil.equals((Object)((Kernel)DMContexts.getAncestorOfType((IDMContext)t1, Kernel.class)), (Object)((Kernel)DMContexts.getAncestorOfType((IDMContext)t2, Kernel.class)));
    }

    public CudaDebugUISessionState(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.lc = lc;
        try {
            this.decodePinnedThreads();
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private boolean addPinned(String name, CudaCoord blockIdx, CudaCoord threadIdx) {
        Set<Tuple<CudaCoord, CudaCoord, ?>> set = this.pinned.get(name);
        if (set == null) {
            set = new HashSet();
            this.pinned.put(name, set);
        }
        return set.add(Tuple.pair((Object)blockIdx, (Object)threadIdx));
    }

    private void checkKernelCount(DataRequestMonitor<Boolean> drm) throws InterruptedException, ExecutionException {
        Boolean val = this.fewKernels.get();
        if (val == null) {
            ICudaApplication application = this.getApplication();
            if (application != null) {
                application.getKernels(new IsManyKernelsRequestMonitor(ImmediateExecutor.getInstance(), drm));
            } else {
                drm.done((Object)false);
            }
        } else {
            drm.done((Object)val);
        }
    }

    private void decodeKernelThreads(String kernelRecord) {
        int separator = kernelRecord.lastIndexOf("=");
        if (separator > 0) {
            String kernelName = kernelRecord.substring(0, separator);
            String threads = kernelRecord.substring(separator + 1);
            StringTokenizer tokenizer = new StringTokenizer(threads, ";", false);
            HashSet set = new HashSet();
            while (tokenizer.hasMoreTokens()) {
                String thread = tokenizer.nextToken();
                set.add(this.parseThread(thread));
            }
            this.pinned.put(kernelName, set);
        }
    }

    private void decodePinnedThreads() {
        String persistentProperty = Activator.getDefault().getPreferenceStore().getString(this.getPropertyName());
        if (persistentProperty != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(persistentProperty, ":", false);
            while (stringTokenizer.hasMoreTokens()) {
                String kernelRecord = stringTokenizer.nextToken();
                this.decodeKernelThreads(kernelRecord);
            }
        }
    }

    @Override
    public void enableFiltering(ICudaApplication application, boolean enable) {
        if (enable != this.filteringOverride) {
            this.filteringOverride = enable;
            DeviceThread focus = this.getFocus();
            this.getSession().dispatchEvent((Object)new LayoutChangeEvent(focus != null ? focus : application), this.getProperties());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IContainerSuspendedDMEvent e) {
        IRunControl.IExecutionDMContext[] contexts;
        this.filteringOverride = true;
        this.fewKernels.set(null);
        this.stickyKernels.clear();
        ++this.generation;
        IRunControl.IExecutionDMContext[] iExecutionDMContextArray = contexts = e.getTriggeringContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.IExecutionDMContext ctx = iExecutionDMContextArray[n2];
            if (ctx instanceof DeviceThread) {
                this.rememberThread((DeviceThread)ctx, false);
            }
            ++n2;
        }
    }

    private ICudaApplication getApplication() {
        ICudaProcesses processes = (ICudaProcesses)this.getServicesTracker().getService(ICudaProcesses.class);
        if (processes != null) {
            return processes.getApplication();
        }
        return null;
    }

    protected BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    @Override
    public DeviceThread getFocus() {
        return this.currentFocus;
    }

    private Collection<DeviceThread> getPinnedThreads(Kernel kernel) {
        TreeSet<DeviceThread> result = new TreeSet<DeviceThread>(new DeviceThreadComparator(ICoordSorter.CUDA));
        Set<Tuple<CudaCoord, CudaCoord, ?>> threads = this.pinned.get(kernel.getName());
        if (threads != null) {
            for (Tuple<CudaCoord, CudaCoord, ?> tuple : threads) {
                try {
                    Block block = kernel.getBlock((CudaCoord)tuple.getObject1());
                    DeviceThread thread = block.getThread((CudaCoord)tuple.getObject2());
                    result.add(thread);
                }
                catch (CudaException e) {
                    Activator.log(e);
                }
            }
        }
        return result;
    }

    private String getPropertyName() {
        return String.valueOf(this.lc.getName()) + "." + PROPERTY_PINNED_THREADS;
    }

    @Override
    public void getThreads(Kernel kernel, int maxCount, DataRequestMonitor<? super DeviceThread[]> drm) {
        final TreeSet<Tuple> threads = new TreeSet<Tuple>(new ThreadsComparator());
        for (Map.Entry<ThreadKey, Integer> entry : this.remembered.entrySet()) {
            ThreadKey threadKey = entry.getKey();
            if (threadKey.kernelId != kernel.getId()) continue;
            try {
                Block block = kernel.getBlock(threadKey.blockIdx);
                DeviceThread thread = block.getThread(threadKey.threadIdx);
                threads.add(Tuple.pair((Object)thread, (Object)entry.getValue()));
            }
            catch (CudaException e) {
                Activator.log(e);
            }
        }
        final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)drm, (DataRequestMonitor)drm, kernel, threads, maxCount){
            private final /* synthetic */ DataRequestMonitor val$drm;
            private final /* synthetic */ Kernel val$kernel;
            private final /* synthetic */ Collection val$threads;
            private final /* synthetic */ int val$maxCount;
            {
                this.val$drm = dataRequestMonitor;
                this.val$kernel = kernel;
                this.val$threads = collection;
                this.val$maxCount = n;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$drm.done((Object)CudaDebugUISessionState.this.trim(this.val$kernel, this.val$threads, this.val$maxCount));
            }
        };
        crm.setDoneCount(threads.size());
        for (final Tuple tuple : new LinkedList(threads)) {
            ((DeviceThread)tuple.getObject1()).getState(new DataRequestMonitor<CudaRuntimeInformation>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    if (!((CudaRuntimeInformation)this.getData()).getState().isActive()) {
                        threads.remove(tuple);
                        CudaDebugUISessionState.this.remembered.remove(CudaDebugUISessionState.getThreadKey((DeviceThread)tuple.getObject1()));
                    }
                    crm.done();
                }
            });
        }
    }

    @Override
    public Kernel[] getVisibleKernels() {
        Set kernels = this.stickyKernels.keySet();
        return kernels.toArray(new Kernel[kernels.size()]);
    }

    private void hasManyKernels(final DataRequestMonitor<Boolean> drm) {
        Boolean val = this.fewKernels.get();
        if (val == null) {
            new ImmediateInDsfExecutor(this.getSession().getExecutor()).execute((Runnable)new DsfRunnable(){

                public void run() {
                    try {
                        CudaDebugUISessionState.this.checkKernelCount((DataRequestMonitor<Boolean>)drm);
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                    catch (ExecutionException e) {
                        Activator.log(e);
                    }
                }
            });
        } else {
            drm.done((Object)val);
        }
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                CudaDebugUISessionState.this.register(new String[]{IDebuggerUIState.class.getName(), CudaDebugUISessionState.class.getName()}, new Hashtable());
                CudaDebugUISessionState.this.getSession().addServiceEventListener((Object)CudaDebugUISessionState.this, null);
                rm.done();
            }
        });
    }

    @Override
    public void isFilteringOut(DataRequestMonitor<Boolean> drm) {
        if (!this.filteringOverride) {
            drm.done((Object)false);
        } else {
            this.hasManyKernels(drm);
        }
    }

    @Override
    public boolean isKernelVisible(Kernel kernel) {
        return this.stickyKernels.containsKey(kernel);
    }

    @Override
    public boolean isPinned(DeviceThread element) {
        if (element != null) {
            return this.isPinned((Kernel)DMContexts.getAncestorOfType((IDMContext)element, Kernel.class), element);
        }
        return false;
    }

    private boolean isPinned(Kernel kernel, DeviceThread focus) {
        Set<Tuple<CudaCoord, CudaCoord, ?>> set = this.pinned.get(kernel.getName());
        return set != null && set.contains(Tuple.pair((Object)focus.getBlockIdx(), (Object)focus.getThreadIdx()));
    }

    @Override
    public boolean isRemembered(DeviceThread thread) {
        return thread != null && this.remembered.containsKey(CudaDebugUISessionState.getThreadKey(thread));
    }

    private boolean isSameFocus(IFocus focus1, IFocus focus2) {
        if (focus1 == focus2) {
            return true;
        }
        if (focus1 == null || focus2 == null) {
            return false;
        }
        return focus1.getKernelId() == focus2.getKernelId() && focus1.getBlockIdx().equals(focus2.getBlockIdx()) && focus1.getThreadIdx().equals(focus2.getThreadIdx());
    }

    private Tuple<CudaCoord, CudaCoord, ?> parseThread(String thread) {
        int separator = thread.indexOf(40, 1);
        String block = thread.substring(0, separator);
        String threadId = thread.substring(separator);
        return Tuple.pair((Object)CudaCoord.parse(block), (Object)CudaCoord.parse(threadId));
    }

    private void persistPinnedState() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Set<Tuple<CudaCoord, CudaCoord, ?>>> entry : this.pinned.entrySet()) {
            builder.append(entry.getKey()).append('=');
            Set<Tuple<CudaCoord, CudaCoord, ?>> threads = entry.getValue();
            for (Tuple<CudaCoord, CudaCoord, ?> tuple : threads) {
                builder.append(tuple.getObject1()).append(tuple.getObject2()).append(";");
            }
            builder.append(":");
        }
        Activator.getDefault().getPreferenceStore().setValue(this.getPropertyName(), builder.toString());
    }

    @Override
    public void pin(DeviceThread element) {
        if (element != null) {
            DeviceThread thread = element;
            Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)element, Kernel.class);
            CudaCoord blockIdx = thread.getBlockIdx();
            CudaCoord threadIdx = thread.getThreadIdx();
            if (this.addPinned(kernel.getName(), blockIdx, threadIdx)) {
                this.persistPinnedState();
                this.getSession().dispatchEvent((Object)new ElementPinnedStatusEvent(thread, true), this.getProperties());
            }
        }
    }

    @Override
    public boolean pinKernel(Kernel kernel) {
        DeviceThread thread = this.getFocus();
        if (thread == null || !this.parentOf(thread.getKernel(), kernel)) {
            return this.stickyKernels.putIfAbsent(kernel, kernel) == null;
        }
        return false;
    }

    private boolean parentOf(Kernel kernel, Kernel parent) {
        if (CoreUtil.equals((Object)kernel, (Object)parent)) {
            return true;
        }
        KernelCallSite site = kernel.getCallSite();
        return site != null && this.parentOf(site.getParent(), parent);
    }

    private void rememberThread(DeviceThread thread, boolean persist) {
        ThreadKey key = CudaDebugUISessionState.getThreadKey(thread);
        if (key != null) {
            this.remembered.put(key, this.generation);
        }
    }

    private void setFocus(DeviceThread focus) {
        if (!this.isSameFocus(focus, this.currentFocus)) {
            ICudaProcesses service = (ICudaProcesses)this.getServicesTracker().getService(ICudaProcesses.class);
            CudaFocusChangedEvent event = service != null ? new CudaFocusChangedEvent(service.getApplication(), focus, this.currentFocus) : null;
            if (!CudaDebugUISessionState.isSameKernel(focus, this.currentFocus)) {
                this.filteringOverride = true;
            }
            this.currentFocus = focus;
            if (service != null) {
                this.getSession().dispatchEvent((Object)event, this.getProperties());
            }
        }
    }

    @Override
    public void setFocus(IRunControl.IExecutionDMContext execDmc) {
        if (execDmc == null || execDmc instanceof DeviceThread) {
            this.setFocus((DeviceThread)execDmc);
        }
    }

    protected final DeviceThread[] trim(Kernel kernel, Collection<Tuple<DeviceThread, Integer, ?>> threads, int maxCount) {
        int count;
        Collection<DeviceThread> pinnedThreads = this.getPinnedThreads(kernel);
        if (this.currentFocus != null && DMContexts.isAncestorOf((IDMContext)this.currentFocus, (IDMContext)kernel)) {
            pinnedThreads.add(this.currentFocus);
        }
        if ((count = maxCount - pinnedThreads.size()) > 0) {
            int i = count;
            for (Tuple<DeviceThread, Integer, ?> tuple : threads) {
                if (pinnedThreads.contains(tuple.getObject1())) continue;
                pinnedThreads.add((DeviceThread)tuple.getObject1());
                if (--i == 0) break;
            }
        }
        return pinnedThreads.toArray(new DeviceThread[pinnedThreads.size()]);
    }

    @Override
    public void unpin(DeviceThread element) {
        if (element != null) {
            Set<Tuple<CudaCoord, CudaCoord, ?>> pinnedThreads;
            DeviceThread thread = element;
            if (!CoreUtil.equals((Object)element, (Object)this.currentFocus)) {
                this.remembered.remove(CudaDebugUISessionState.getThreadKey(thread));
            }
            if ((pinnedThreads = this.pinned.get(thread.getKernel().getName())) != null && pinnedThreads.remove(Tuple.pair((Object)thread.getBlockIdx(), (Object)thread.getThreadIdx()))) {
                this.persistPinnedState();
                this.getSession().dispatchEvent((Object)new ElementPinnedStatusEvent(thread, false), this.getProperties());
            }
        }
    }

    private final class IsManyKernelsRequestMonitor
    extends DataRequestMonitor<Kernel[]> {
        private final DataRequestMonitor<Boolean> drm;

        private IsManyKernelsRequestMonitor(Executor executor, DataRequestMonitor<Boolean> drm) {
            super(executor, drm);
            this.drm = drm;
        }

        @ConfinedToDsfExecutor(value="fExecutor")
        protected void handleSuccess() {
            boolean b = this.getData() != null ? ((Kernel[])this.getData()).length > 5 : true;
            CudaDebugUISessionState.this.fewKernels.compareAndSet(null, b);
            this.drm.done((Object)b);
        }
    }

    private static final class ThreadKey {
        private final CudaCoord blockIdx;
        private final long kernelId;
        private final CudaCoord threadIdx;

        public ThreadKey(long kernelId, CudaCoord blockIdx, CudaCoord threadIdx) {
            this.kernelId = kernelId;
            this.blockIdx = blockIdx;
            this.threadIdx = threadIdx;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThreadKey other = (ThreadKey)obj;
            if (this.blockIdx == null ? other.blockIdx != null : !this.blockIdx.equals(other.blockIdx)) {
                return false;
            }
            if (this.kernelId != other.kernelId) {
                return false;
            }
            return !(this.threadIdx == null ? other.threadIdx != null : !this.threadIdx.equals(other.threadIdx));
        }

        public int hashCode() {
            return this.threadIdx.hashCode() + (this.blockIdx.hashCode() + (int)this.kernelId * 31) * 31;
        }
    }

    private final class ThreadsComparator
    implements Comparator<Tuple<DeviceThread, Integer, ?>> {
        private ThreadsComparator() {
        }

        @Override
        public int compare(Tuple<DeviceThread, Integer, ?> o1, Tuple<DeviceThread, Integer, ?> o2) {
            int val = -((Integer)o1.getObject2()).compareTo((Integer)o2.getObject2());
            if (val == 0) {
                DeviceThread k1 = (DeviceThread)o1.getObject1();
                DeviceThread k2 = (DeviceThread)o2.getObject1();
                val = (int)Math.signum(k1.getKernel().getId() - k2.getKernel().getId());
                if (val == 0 && (val = k1.getBlockIdx().compareTo(k2.getBlockIdx())) == 0) {
                    val = k1.getThreadIdx().compareTo(k2.getThreadIdx());
                }
            }
            return val;
        }
    }
}

