/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;

public class RemoveGlobalsActionDelegate
extends ActionDelegate
implements IViewActionDelegate {
    private IAction fAction;
    private ISelection fSelection;

    public void init(IViewPart view) {
    }

    public void init(IAction action) {
        this.setAction(action);
        this.update();
    }

    public void run(IAction action) {
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Iterator it = ss.iterator();
        ArrayList list = new ArrayList(ss.size());
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ICGlobalVariable)) continue;
            list.add(obj);
        }
        if (list.size() == 0) {
            return;
        }
        final ICGlobalVariable[] globals = list.toArray(new ICGlobalVariable[list.size()]);
        final ICGlobalVariableManager gvm = (ICGlobalVariableManager)globals[0].getDebugTarget().getAdapter(ICGlobalVariableManager.class);
        if (gvm == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                gvm.removeGlobals(globals);
            }
        };
        DebugPlugin.getDefault().asyncExec(r);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        this.update();
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    private void setSelection(ISelection selection) {
        this.fSelection = selection;
    }

    private void update() {
        IAction action = this.getAction();
        if (action != null) {
            ISelection selection = this.getSelection();
            boolean enabled = false;
            if (selection instanceof IStructuredSelection) {
                Iterator it = ((IStructuredSelection)selection).iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof ICGlobalVariable)) continue;
                    enabled = true;
                    break;
                }
            }
            action.setEnabled(enabled);
        }
    }
}

