/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.preferences;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;

public class RemoteContentProvider
implements ITreeContentProvider {
    private final IRemoteConnection connection;
    private final IPath rootDir;
    private final IProject project;
    private final IRemoteFileManager fileManager;

    public RemoteContentProvider(IRemoteConnection conn, IPath dir, IProject proj) {
        if (conn == null || dir == null) {
            throw new IllegalArgumentException(Messages.RemoteContentProvider_0);
        }
        this.connection = conn;
        this.rootDir = dir;
        this.project = proj;
        this.fileManager = this.connection.getFileManager();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        IFileInfo[] childFiles;
        IFileStore fileStore = this.fileManager.getResource(this.rootDir.toString());
        try {
            childFiles = fileStore.childInfos(0, null);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
        Object[] childObjects = new IResource[childFiles.length];
        int i = 0;
        while (i < childFiles.length) {
            childObjects[i] = childFiles[i].isDirectory() ? this.project.getFolder(childFiles[i].getName()) : this.project.getFile(childFiles[i].getName());
            ++i;
        }
        return childObjects;
    }

    public Object[] getChildren(Object parentElement) {
        IFileInfo[] childFiles;
        if (!(parentElement instanceof IFolder)) {
            return new Object[0];
        }
        IFileStore fileStore = this.fileManager.getResource(this.rootDir.toString()).getFileStore(((IFolder)parentElement).getProjectRelativePath());
        try {
            childFiles = fileStore.childInfos(0, null);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
        Object[] childObjects = new IResource[childFiles.length];
        int i = 0;
        while (i < childFiles.length) {
            IPath childPath = ((IFolder)parentElement).getProjectRelativePath().addTrailingSeparator().append(childFiles[i].getName());
            childObjects[i] = childFiles[i].isDirectory() ? this.project.getFolder(childPath) : this.project.getFile(childPath);
            ++i;
        }
        return childObjects;
    }

    public Object getParent(Object element) {
        if (!(element instanceof IResource)) {
            return null;
        }
        return ((IResource)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Object[] obj = this.getChildren(element);
        return obj == null ? false : obj.length > 0;
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public static BufferedInputStream getFileContents(IFile file) throws CoreException, MissingConnectionException {
        BufferedInputStream retStream = null;
        IProject project = file.getProject();
        SyncConfig config = SyncConfigManager.getActive((IProject)project);
        if (config != null) {
            IPath remotePath;
            IRemoteFileManager fileManager = config.getRemoteConnection().getFileManager();
            IFileStore fileStore = fileManager.getResource((remotePath = new Path(config.getLocation(project)).addTrailingSeparator().append(file.getProjectRelativePath())).toString());
            InputStream fileInput = fileStore.openInputStream(0, null);
            if (fileInput != null) {
                retStream = new BufferedInputStream(fileInput);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.RemoteContentProvider_1));
        }
        return retStream;
    }
}

