/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;

public class ShowResourceInHistoryAction
extends WorkspaceAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IResource[] resources = ShowResourceInHistoryAction.this.getSelectedResources();
                if (resources.length != 1) {
                    return;
                }
                TeamUI.showHistoryFor((IWorkbenchPage)TeamUIPlugin.getActivePage(), (Object)resources[0], null);
            }
        }, false, 2);
    }

    protected String getErrorTitle() {
        return CVSUIMessages.ShowHistoryAction_showHistory;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return true;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    public String getId() {
        return "org.eclipse.team.cvs.ui.showHistory";
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForIgnoredResources() {
        return true;
    }
}

