/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractDisassemblyRulerActionDelegate
extends ActionDelegate
implements IEditorActionDelegate,
IViewActionDelegate,
MouseListener,
IMenuListener {
    private IDisassemblyPart fDisassemblyPart;
    private IAction fCallerAction;
    private IAction fAction;

    protected abstract IAction createAction(IDisassemblyPart var1, IVerticalRulerInfo var2);

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        this.setTargetPart(callerAction, (IWorkbenchPart)targetEditor);
    }

    public void init(IViewPart view) {
        this.setTargetPart(this.fCallerAction, (IWorkbenchPart)view);
    }

    public void init(IAction action) {
        this.fCallerAction = action;
    }

    private void setTargetPart(IAction callerAction, IWorkbenchPart targetPart) {
        Control control;
        IVerticalRulerInfo rulerInfo;
        if (this.fDisassemblyPart != null) {
            rulerInfo = (IVerticalRulerInfo)this.fDisassemblyPart.getAdapter(IVerticalRulerInfo.class);
            if (rulerInfo != null && (control = rulerInfo.getControl()) != null && !control.isDisposed()) {
                control.removeMouseListener((MouseListener)this);
            }
            this.fDisassemblyPart.removeRulerContextMenuListener(this);
        }
        this.fDisassemblyPart = (IDisassemblyPart)(targetPart == null ? null : targetPart.getAdapter(IDisassemblyPart.class));
        this.fCallerAction = callerAction;
        this.fAction = null;
        if (this.fDisassemblyPart != null) {
            this.fDisassemblyPart.addRulerContextMenuListener(this);
            rulerInfo = (IVerticalRulerInfo)this.fDisassemblyPart.getAdapter(IVerticalRulerInfo.class);
            if (rulerInfo != null) {
                this.fAction = this.createAction(this.fDisassemblyPart, rulerInfo);
                this.update();
                control = rulerInfo.getControl();
                if (control != null && !control.isDisposed()) {
                    control.addMouseListener((MouseListener)this);
                }
            }
        }
    }

    public void run(IAction callerAction) {
        if (this.fAction != null) {
            this.fAction.run();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        if (this.fAction != null) {
            this.fAction.runWithEvent(event);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void update() {
        if (this.fAction instanceof IUpdate) {
            ((IUpdate)this.fAction).update();
            if (this.fCallerAction != null) {
                this.fCallerAction.setText(this.fAction.getText());
                this.fCallerAction.setEnabled(this.fAction.isEnabled());
            }
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.update();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.update();
    }

    public void mouseUp(MouseEvent e) {
    }
}

