/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.jni.OpenAccAggregate;
import com.nvidia.viper.model.SummaryType;
import com.nvidia.viper.ui.OpenAccLabelType;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class OpenAccLabelProvider
extends ColumnLabelProvider {
    private OpenAccLabelType contentType;
    private static SummaryType mode;
    private static NumberFormat percentFormatter;
    private static TimeFormatter numberFormatter;

    static {
        percentFormatter = NumberFormat.getPercentInstance();
        numberFormatter = new TimeFormatter();
        numberFormatter.setFractionDigits(5);
        percentFormatter.setMaximumFractionDigits(3);
        percentFormatter.setGroupingUsed(false);
    }

    public void setMode(SummaryType mode) {
        OpenAccLabelProvider.mode = mode;
    }

    public OpenAccLabelProvider(OpenAccLabelType type) {
        this.contentType = type;
        mode = SummaryType.inclusive;
    }

    public String getText(Object element) {
        if (element instanceof OpenAccAggregate) {
            OpenAccAggregate aggreate = (OpenAccAggregate)element;
            switch (this.contentType) {
                case name: {
                    return aggreate.getDisplayName();
                }
                case percentage: {
                    if (mode == SummaryType.inclusive) {
                        return percentFormatter.format((double)aggreate.getInclusiveTime() / (double)aggreate.getTotalTime());
                    }
                    return percentFormatter.format((double)aggreate.getExclusiveTime() / (double)aggreate.getTotalTime());
                }
                case totalTime: {
                    if (mode == SummaryType.inclusive) {
                        return numberFormatter.format(aggreate.getInclusiveTime(), true);
                    }
                    return numberFormatter.format(aggreate.getExclusiveTime(), true);
                }
                case calls: {
                    return new Long(aggreate.getCalls()).toString();
                }
            }
            return "";
        }
        return "";
    }

    public String getTitle() {
        switch (this.contentType) {
            case name: {
                return "Name";
            }
            case percentage: {
                return "%";
            }
            case totalTime: {
                return "Time";
            }
            case calls: {
                return "Calls";
            }
        }
        return "";
    }
}

