/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelStallReasonGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisResultKernelStall
extends AnalysisResult {
    private static final double THRESHOLD = 0.9;
    private final TimelineIntervalKernel kernel;
    private final Map<StallKind, Double> stallMap;

    public AnalysisResultKernelStall(AnalysisDescriptor desc, TimelineIntervalKernel kernel) {
        super(desc);
        this.kernel = kernel;
        this.stallMap = new HashMap<StallKind, Double>();
    }

    public void setStallPercentage(StallKind kind, double stall) {
        this.stallMap.put(kind, stall);
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public List<StallKind> getStallKinds() {
        LinkedList<StallKind> kinds = new LinkedList<StallKind>();
        StallKind[] stallKindArray = StallKind.values();
        int n = stallKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            StallKind kind = stallKindArray[n2];
            if (this.stallMap.containsKey((Object)kind)) {
                kinds.add(kind);
            }
            ++n2;
        }
        return kinds;
    }

    public double getStallPercent(StallKind kind) {
        Double val = this.stallMap.get((Object)kind);
        return val == null ? 0.0 : val;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        for (StallKind kind : this.stallMap.keySet()) {
            if (StallKind.OTHER.equals((Object)kind)) continue;
            desc = String.valueOf(desc) + "\n\t" + kind.getDescription();
        }
        return desc;
    }

    @Override
    public String getActionDescription(ResultOutput otpt) {
        Set<StallKind> primaryStalls = this.getPrimaryStalls();
        ArrayList<String> primaryStallStrs = new ArrayList<String>(primaryStalls.size());
        for (StallKind kind : primaryStalls) {
            primaryStallStrs.add(kind.toString());
        }
        String desc = super.getActionDescription(otpt);
        if (desc != null) {
            desc = desc.replace("%ISSUE%", primaryStalls.size() == 1 ? "issue" : "issues");
            desc = desc.replace("%ISSUES%", StringUtils.join(primaryStallStrs, ", "));
        }
        return desc;
    }

    public Set<StallKind> getPrimaryStalls() {
        StallKind max = null;
        for (StallKind kind : this.stallMap.keySet()) {
            if (max != null && !(this.stallMap.get((Object)max) < this.stallMap.get((Object)kind))) continue;
            max = kind;
        }
        if (max == null) {
            max = StallKind.DATA;
        }
        HashSet<StallKind> kinds = new HashSet<StallKind>();
        kinds.add(max);
        for (StallKind kind : this.stallMap.keySet()) {
            if (!(this.stallMap.get((Object)kind) / this.stallMap.get((Object)max) >= 0.9)) continue;
            kinds.add(kind);
        }
        return kinds;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelStallReasonGraphicFactory();
    }

    public static enum StallKind {
        FETCH("instruction fetch", String.format(ViperMessages.KernelLatency_Stall_InstFetchDesc, "Instruction Fetch - "), "stall_inst_fetch"),
        EXEC("execution dependency", String.format(ViperMessages.KernelLatency_Stall_ExecDependencyDesc, "Execution Dependency - "), "stall_exec_dependency"),
        DATA("memory dependency", String.format(ViperMessages.KernelLatency_Stall_DataRequestDesc, "Memory Dependency - "), "stall_data_request"),
        TEXTURE("texture", String.format(ViperMessages.KernelLatency_Stall_TextureDesc, "Texture - "), "stall_texture"),
        SYNC("synchronization", String.format(ViperMessages.KernelLatency_Stall_SyncDesc, "Synchronization - "), "stall_sync"),
        OTHER("other", String.format(ViperMessages.KernelLatency_Stall_OtherDesc, "Other - "), "stall_other"),
        COMPUTE("pipe busy", String.format(ViperMessages.KernelLatency_Stall_ComputeDesc, "Pipeline Busy - "), "stall_compute"),
        IMC("constant", String.format(ViperMessages.KernelLatency_Stall_ConstantDesc, "Constant - "), "stall_imc"),
        THROTTLE("memory throttle", String.format(ViperMessages.KernelLatency_Stall_MemoryThrottleDesc, "Memory Throttle - "), "stall_memory_throttle"),
        NOT_SELECTED("not selected", String.format(ViperMessages.KernelLatency_Stall_NotSelectedDesc, "Not Selected - "), "stall_not_selected");

        private final String name;
        private final String desc;
        private final String stallMetricName;

        private StallKind(String name, String desc, String stallMetricName) {
            this.name = name;
            this.desc = desc;
            this.stallMetricName = stallMetricName;
        }

        public String getStallMetricName() {
            return this.stallMetricName;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toChartString() {
            String name = this.toString();
            if (name == null) {
                return null;
            }
            return name.replace(' ', '\n');
        }

        public String toString() {
            return this.name;
        }

        public static StallKind[] getStallKinds(int major, int minor) {
            if (major >= 3) {
                return new StallKind[]{FETCH, EXEC, DATA, COMPUTE, TEXTURE, IMC, SYNC, THROTTLE, NOT_SELECTED, OTHER};
            }
            return new StallKind[]{FETCH, EXEC, DATA, TEXTURE, SYNC, COMPUTE, THROTTLE, OTHER};
        }
    }
}

