/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection;

import java.util.ArrayList;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.ui.widgets.services.ConnectorServiceElement;
import org.eclipse.rse.ui.widgets.services.ServerLauncherPropertiesServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public final class SubSystemConfigurator
implements ISubSystemConfigurator {
    private final ISubSystemConfigurationProxy proxy;
    private final int port;
    private final String user;

    public SubSystemConfigurator(ISubSystemConfigurationProxy proxy, String user, int port) {
        this.user = user;
        this.port = port;
        this.proxy = proxy;
    }

    public boolean applyValues(ISubSystem ss) {
        IConnectorService service = ss.getConnectorService();
        service.setUserId(this.user);
        service.setPort(this.port);
        service.commit();
        return true;
    }

    protected ServerLauncherPropertiesServiceElement[] getPropertiesServiceElement(ServiceElement[] _serviceElements) {
        ArrayList<ServerLauncherPropertiesServiceElement> results = new ArrayList<ServerLauncherPropertiesServiceElement>();
        int i = 0;
        while (i < _serviceElements.length) {
            ServiceElement[] children;
            ServiceElement el = _serviceElements[i];
            if (el.isSelected() && (children = el.getChildren()) != null) {
                int c = 0;
                while (c < children.length) {
                    ServiceElement[] cch;
                    ServiceElement child = children[c];
                    if (child instanceof ConnectorServiceElement && (cch = child.getChildren()) != null && cch.length > 0 && cch[0] instanceof ServerLauncherPropertiesServiceElement) {
                        ServerLauncherPropertiesServiceElement result = (ServerLauncherPropertiesServiceElement)cch[0];
                        results.add(result);
                    }
                    ++c;
                }
            }
            ++i;
        }
        return results.toArray(new ServerLauncherPropertiesServiceElement[results.size()]);
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        return this.proxy.getSubSystemConfiguration();
    }
}

