/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggregationSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;

public class AggrSortHelper {
    public static void sort(List sorts, IAggregationResultSet[] resultSet, IBindingValueFetcher fetcher) throws DataException {
        assert (sorts != null && sorts.size() > 0);
        try {
            ITargetSort[] targetSorts = new ITargetSort[sorts.size()];
            sorts.toArray(targetSorts);
            int baseIndex = -1;
            baseIndex = targetSorts[0] instanceof AggrSortDefinition ? AggrSortHelper.getBaseResultSetIndex(resultSet, ((AggrSortDefinition)targetSorts[0]).getAggrName(), targetSorts[0].getTargetLevel()) : AggrSortHelper.getBaseResultSetIndex(resultSet, targetSorts[0].getTargetLevel());
            IAggregationResultSet[] targetResultSet = new IAggregationResultSet[sorts.size()];
            int i = 0;
            while (i < targetSorts.length) {
                if (targetSorts[i] instanceof AggrSortDefinition) {
                    AggrSortDefinition sortDefn = (AggrSortDefinition)targetSorts[i];
                    DimLevel[] aggrLevels = sortDefn.getAggrLevels();
                    targetResultSet[i] = aggrLevels == null ? resultSet[baseIndex] : AggrSortHelper.getMatchedResultSet(resultSet, aggrLevels, sortDefn.getAggrName());
                }
                ++i;
            }
            IAggregationResultSet result = AggregationSortHelper.sort(resultSet[baseIndex], targetSorts, targetResultSet, fetcher);
            resultSet[baseIndex].close();
            resultSet[baseIndex] = result;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private static int getBaseResultSetIndex(IAggregationResultSet[] resultSet, DimLevel level) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            if (AggrSortHelper.isEdgeResultSet(resultSet[i]) && resultSet[i].getLevelIndex(level) >= 0) {
                return i;
            }
            ++i;
        }
        throw new DataException("Can't find the base aggregation result set for the target level:", level);
    }

    private static int getBaseResultSetIndex(IAggregationResultSet[] resultSet, String aggregationName, DimLevel level) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            if (AggrSortHelper.isEdgeResultSet(resultSet[i]) && resultSet[i].getLevelIndex(level) >= 0) {
                return i;
            }
            ++i;
        }
        throw new DataException("Can't find the base aggregation result set for the target level:", level);
    }

    private static boolean isEdgeResultSet(IAggregationResultSet resultSet) {
        return resultSet.getAggregationDefinition() == null || resultSet.getAggregationDefinition().getAggregationFunctions() == null;
    }

    private static IAggregationResultSet getMatchedResultSet(IAggregationResultSet[] resultSet, DimLevel[] levelNames, String aggregationName) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            IAggregationResultSet rSet = resultSet[i];
            if (levelNames.length == rSet.getLevelCount()) {
                boolean match = true;
                int j = 0;
                while (j < rSet.getLevelCount()) {
                    if (!levelNames[j].equals(rSet.getLevel(j))) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match && !AggrSortHelper.isEdgeResultSet(rSet) && AggrSortHelper.existAggregation(rSet.getAggregationDefinition(), aggregationName)) {
                    return rSet;
                }
            }
            ++i;
        }
        throw new DataException("data.olap.invalidSortDefinition");
    }

    private static boolean existAggregation(AggregationDefinition aggrDef, String aggregationName) {
        AggregationFunctionDefinition[] funcs = aggrDef.getAggregationFunctions();
        if (funcs == null) {
            return false;
        }
        int i = 0;
        while (i < funcs.length) {
            if (funcs[i].getName().equals(aggregationName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

