
#ifndef __KMARTIAN_H
#define __KMARTIAN_H

#include <linux/pci.h>		// pci_driver
#include <linux/proc_fs.h>	/*** proc entry */
#include <linux/wait.h>		/*** wait_queue */
#include <asm/atomic.h>

#include "../martian.h"
#include "fifo.h"
#include "mfifo.h"

#define MPREFIX			__stringify (KBUILD_MODNAME)

#define MINFO(fmt...)		printk (KERN_INFO MPREFIX ": " fmt)
#define MERROR(fmt...)		printk (KERN_ERR MPREFIX ": " fmt)

#define MARTIAN_DEBUG

#ifdef MARTIAN_DEBUG
#  define MDEBUG(fmt...) 	printk (KERN_DEBUG MPREFIX ": " fmt)
#  define ASSERT(cond, action)	do {if (! (cond)) { action }} while (0)
#else
#  define MDEBUG(arg...)	do {} while (0)	
#  define ASSERT(cond, action) 	do {} while (0)
#endif 	

struct martian_metrics {
	unsigned BaseAddress;
	unsigned CommAddress;

	unsigned int irq;

	unsigned short vendor, device;
	unsigned short subsystem_vendor;
	unsigned short subsystem_device;
	unsigned flags;
	// void *

	unsigned char s7e, s75;
	unsigned short s82, s84, s86, s88;
	unsigned char dsp_mars;
	unsigned char dsp_mars3;
};

struct martian {
	struct pci_dev *dev;
	struct proc_dir_entry *entry;
	unsigned long state;
	
	wait_queue_head_t wq;	/* to wait in read/poll */

	/* core variables; side-effect of some marsio */
	/* changes are done on kernel leaving */
	/* with this approach no trailing pointers in calls 
	 * for all dependencies, and no overhead for 
	 * numerous changes
	 */
	//u8 byte_f;

	/* isr data */
	mfifo_t dce_tx;
	mfifo_t dce_rx;
	mfifo_t pdm_rx;

	atomic_t count; 	/* interrupt counter */

	/* stats */
	struct irqcount icounts;

	/* resources */
	spinlock_t lock;

	/* common data pointer */
	struct martian_common *common;
	int index;

	// configuration info
	struct martian_metrics metrics;

	/* hardware */
	struct mparams {
		unsigned long flags;
		u8 dsp_mars;
		u8 dsp_mars3;

		u8  dp_version;
		u8  chip_version;
		u32 checksum;

		unsigned BaseAddress;
		unsigned BaseAddressData;
		unsigned BaseAddressIndex;
		unsigned BaseAddress2;

		unsigned short s82, s84, s86, s88;

		unsigned char s7e, s75, s7f;
		unsigned char DCPAudioOn;

		/* unsigned char scb; */

		/*
		unsigned char sa6, sa7;
		unsigned char s7f;
		unsigned char sdf, se0, se1, se2;
		unsigned char se3, se4, se5;
		unsigned char se6; // flags
		*/
	} params;
};

enum _mparams_flags {
	MPF_CPQ	    = 1,
	MPF_TOSHIBA = 2,
};

#define mars_lock(dev, flags)	spin_lock_irqsave (&dev->lock, flags)
#define mars_unlock(dev, flags)	spin_unlock_irqrestore (&dev->lock, flags)

static inline void mars_copy_mcb_dynamic(struct martian *mdev)
{
	struct martian_common *mcb = mdev->common;

	mcb->x_dsp_mars     = mdev->params.dsp_mars;
	mcb->x_dsp_mars3    = mdev->params.dsp_mars3;
	mcb->x_chip_version = mdev->params.chip_version;
}

#define MARTIAN_STATE_OPEN	0
#define KMSTATE_UREADY		1 
#define KMSTATE_FIFO_FAULT	2 

#define KMSETTING_SERVE_IRQS	16 
#define KMSETTING_TRUESMP	17 
#define KMSETTING_DEBUG		18

#endif	/* __KMARTIAN_H */
