/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection oracleConnection) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected OracleTypeCHAR(OracleConnection oracleConnection, int n2) {
        super(n2);
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        CHAR cHAR = object instanceof CHAR ? (CHAR)object : new CHAR(object, this.pickleCharacterSet);
        return cHAR;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                return super.toDatumArray(object, oracleConnection, l2, n2);
            }
            datumArray = this.cArrayToDatumArray(object, oracleConnection, l2, n2);
        }
        return datumArray;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        super.parseTDSrec(tDSReader);
        try {
            this.length = tDSReader.readUB2();
            this.form = tDSReader.readByte();
            this.characterSemantic = this.form & 0x80;
            this.form &= 0x7F;
            this.charset = tDSReader.readUB2();
            if (this.form == 2) {
                switch (this.typeCode) {
                    case 12: {
                        this.typeCode = -9;
                        break;
                    }
                    case 1: {
                        this.typeCode = -15;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
            sQLException2.fillInStackTrace();
            throw sQLException2;
        }
        if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
            return;
        }
        try {
            this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
        }
        catch (SQLException sQLException) {
            this.pickleNcharCharacterSet = (short)2000;
        }
        this.pickleCharaterSetId = this.pickleNcharCharacterSet;
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        CHAR cHAR = this.getDbCHAR(datum);
        if (this.characterSemantic != 0 && this.form != 2) {
            if (cHAR.getStringWithReplacement().length() > this.length) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + cHAR.getStringWithReplacement() + "\"");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else if (cHAR.getLength() > (long)this.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + cHAR.getStringWithReplacement() + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return super.pickle81(pickleContext, cHAR);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CHAR cHAR = null;
        switch (this.form) {
            case 1: 
            case 2: {
                cHAR = new CHAR(byArray, this.pickleCharacterSet);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(byArray, null);
            }
        }
        if (n2 == 1) {
            return cHAR;
        }
        if (n2 == 2) {
            return cHAR.stringValue();
        }
        if (n2 == 3) {
            return byArray;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private CHAR getDbCHAR(Datum datum) {
        CHAR cHAR = (CHAR)datum;
        CHAR cHAR2 = null;
        if (cHAR.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
            cHAR2 = cHAR;
        } else {
            try {
                cHAR2 = new CHAR(cHAR.toString(), this.pickleCharacterSet);
            }
            catch (SQLException sQLException) {
                cHAR2 = cHAR;
            }
        }
        return cHAR2;
    }

    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = new CHAR(new String(cArray[(int)l2 + i2 - 1]), this.pickleCharacterSet);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n4 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    datumArray[i3] = new CHAR(blArray[(int)l2 + i3 - 1], this.pickleCharacterSet);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n5 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                for (int i4 = 0; i4 < n5; ++i4) {
                    datumArray[i4] = new CHAR(sArray[(int)l2 + i4 - 1], this.pickleCharacterSet);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n6 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n6];
                for (int i5 = 0; i5 < n6; ++i5) {
                    datumArray[i5] = new CHAR(nArray[(int)l2 + i5 - 1], this.pickleCharacterSet);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n7 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                for (int i6 = 0; i6 < n7; ++i6) {
                    datumArray[i6] = new CHAR(new Long(lArray[(int)l2 + i6 - 1]), this.pickleCharacterSet);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n8 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n8];
                for (int i7 = 0; i7 < n8; ++i7) {
                    datumArray[i7] = new CHAR(new Float(fArray[(int)l2 + i7 - 1]), this.pickleCharacterSet);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n9 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                for (int i8 = 0; i8 < n9; ++i8) {
                    datumArray[i8] = new CHAR(new Double(dArray[(int)l2 + i8 - 1]), this.pickleCharacterSet);
                }
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumArray;
    }

    public int getLength() {
        return this.length;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.form);
        objectOutputStream.writeInt(this.charset);
        objectOutputStream.writeInt(this.length);
        objectOutputStream.writeInt(this.characterSemantic);
        objectOutputStream.writeShort(this.pickleCharaterSetId);
        objectOutputStream.writeShort(this.pickleNcharCharacterSet);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.form = objectInputStream.readInt();
        this.charset = objectInputStream.readInt();
        this.length = objectInputStream.readInt();
        this.characterSemantic = objectInputStream.readInt();
        this.pickleCharaterSetId = objectInputStream.readShort();
        this.pickleNcharCharacterSet = objectInputStream.readShort();
        this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    @Override
    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

