.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtGet-Class-Extension wid-get
.na
.TH XtGetClassExtension __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtGetClassExtension \- locate a class extension record
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
XtPointer XtGetClassExtension(WidgetClass \fIobject_class\fP, Cardinal
\fIbyte_offset\fP, XrmQuark \fItype\fP, long \fIversion\fP, Cardinal
\fIrecord_size\fP);
.SH ARGUMENTS
.IP \fIobject_class\fP 1i
Specifies the widget class containing the extension list to be searched.
.IP \fIbyte_offset\fP 1i
Specifies the offset in bytes form the base of the widget class of the
extension field to be searched.
.IP \fItype\fP 1i
Specifies the name of the class extension to be located.
.IP \fIversion\fP 1i
Specifies the minimum acceptable version of the class extension
required for a match.
.IP \fIrecord_size\fP 1i
Specifies the minimum acceptable length of the class extension record
required for match, or 0.
.SH DESCRIPTION
The list of extension records at the specified offset in the specified
\fIwidget_class\fP will be searched for a match on the specified
\fItype\fP, a version greater than or equal to the specified \fIversion\fP,
and a record size greater than or equal the specified \fIrecord_size\fP
if it is nonzero.
.B XtGetClassExtension
returns a pointer to a matching extension record or NULL if no match
is found.
The returned extension record is owned by the widget class
and must not be modified or freed by the caller, except possibly to
be modified by the widget class owner.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
