/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Copyright (C) 2024 Inochi Amaoto <inochiama@outlook.com>
 *
 */

#ifndef _DT_BINDINGS_PINCTRL_SG2044_H
#define _DT_BINDINGS_PINCTRL_SG2044_H

#define PINMUX(pin, mux) \
	(((pin) & 0xffff) | (((mux) & 0xff) << 16))

#define PIN_IIC0_SMBSUS_IN		0
#define PIN_IIC0_SMBSUS_OUT		1
#define PIN_IIC0_SMBALERT		2
#define PIN_IIC1_SMBSUS_IN		3
#define PIN_IIC1_SMBSUS_OUT		4
#define PIN_IIC1_SMBALERT		5
#define PIN_IIC2_SMBSUS_IN		6
#define PIN_IIC2_SMBSUS_OUT		7
#define PIN_IIC2_SMBALERT		8
#define PIN_IIC3_SMBSUS_IN		9
#define PIN_IIC3_SMBSUS_OUT		10
#define PIN_IIC3_SMBALERT		11
#define PIN_PCIE0_L0_RESET		12
#define PIN_PCIE0_L1_RESET		13
#define PIN_PCIE0_L0_WAKEUP		14
#define PIN_PCIE0_L1_WAKEUP		15
#define PIN_PCIE0_L0_CLKREQ_IN		16
#define PIN_PCIE0_L1_CLKREQ_IN		17
#define PIN_PCIE1_L0_RESET		18
#define PIN_PCIE1_L1_RESET		19
#define PIN_PCIE1_L0_WAKEUP		20
#define PIN_PCIE1_L1_WAKEUP		21
#define PIN_PCIE1_L0_CLKREQ_IN		22
#define PIN_PCIE1_L1_CLKREQ_IN		23
#define PIN_PCIE2_L0_RESET		24
#define PIN_PCIE2_L1_RESET		25
#define PIN_PCIE2_L0_WAKEUP		26
#define PIN_PCIE2_L1_WAKEUP		27
#define PIN_PCIE2_L0_CLKREQ_IN		28
#define PIN_PCIE2_L1_CLKREQ_IN		29
#define PIN_PCIE3_L0_RESET		30
#define PIN_PCIE3_L1_RESET		31
#define PIN_PCIE3_L0_WAKEUP		32
#define PIN_PCIE3_L1_WAKEUP		33
#define PIN_PCIE3_L0_CLKREQ_IN		34
#define PIN_PCIE3_L1_CLKREQ_IN		35
#define PIN_PCIE4_L0_RESET		36
#define PIN_PCIE4_L1_RESET		37
#define PIN_PCIE4_L0_WAKEUP		38
#define PIN_PCIE4_L1_WAKEUP		39
#define PIN_PCIE4_L0_CLKREQ_IN		40
#define PIN_PCIE4_L1_CLKREQ_IN		41
#define PIN_SPIF0_CLK_SEL1		42
#define PIN_SPIF0_CLK_SEL0		43
#define PIN_SPIF0_WP			44
#define PIN_SPIF0_HOLD			45
#define PIN_SPIF0_SDI			46
#define PIN_SPIF0_CS			47
#define PIN_SPIF0_SCK			48
#define PIN_SPIF0_SDO			49
#define PIN_SPIF1_CLK_SEL1		50
#define PIN_SPIF1_CLK_SEL0		51
#define PIN_SPIF1_WP			52
#define PIN_SPIF1_HOLD			53
#define PIN_SPIF1_SDI			54
#define PIN_SPIF1_CS			55
#define PIN_SPIF1_SCK			56
#define PIN_SPIF1_SDO			57
#define PIN_EMMC_WP			58
#define PIN_EMMC_CD			59
#define PIN_EMMC_RST			60
#define PIN_EMMC_PWR_EN			61
#define PIN_SDIO_CD			62
#define PIN_SDIO_WP			63
#define PIN_SDIO_RST			64
#define PIN_SDIO_PWR_EN			65
#define PIN_RGMII0_TXD0			66
#define PIN_RGMII0_TXD1			67
#define PIN_RGMII0_TXD2			68
#define PIN_RGMII0_TXD3			69
#define PIN_RGMII0_TXCTRL		70
#define PIN_RGMII0_RXD0			71
#define PIN_RGMII0_RXD1			72
#define PIN_RGMII0_RXD2			73
#define PIN_RGMII0_RXD3			74
#define PIN_RGMII0_RXCTRL		75
#define PIN_RGMII0_TXC			76
#define PIN_RGMII0_RXC			77
#define PIN_RGMII0_REFCLKO		78
#define PIN_RGMII0_IRQ			79
#define PIN_RGMII0_MDC			80
#define PIN_RGMII0_MDIO			81
#define PIN_PWM0			82
#define PIN_PWM1			83
#define PIN_PWM2			84
#define PIN_PWM3			85
#define PIN_FAN0			86
#define PIN_FAN1			87
#define PIN_FAN2			88
#define PIN_FAN3			89
#define PIN_IIC0_SDA			90
#define PIN_IIC0_SCL			91
#define PIN_IIC1_SDA			92
#define PIN_IIC1_SCL			93
#define PIN_IIC2_SDA			94
#define PIN_IIC2_SCL			95
#define PIN_IIC3_SDA			96
#define PIN_IIC3_SCL			97
#define PIN_UART0_TX			98
#define PIN_UART0_RX			99
#define PIN_UART0_RTS			100
#define PIN_UART0_CTS			101
#define PIN_UART1_TX			102
#define PIN_UART1_RX			103
#define PIN_UART1_RTS			104
#define PIN_UART1_CTS			105
#define PIN_UART2_TX			106
#define PIN_UART2_RX			107
#define PIN_UART2_RTS			108
#define PIN_UART2_CTS			109
#define PIN_UART3_TX			110
#define PIN_UART3_RX			111
#define PIN_UART3_RTS			112
#define PIN_UART3_CTS			113
#define PIN_SPI0_CS0			114
#define PIN_SPI0_CS1			115
#define PIN_SPI0_SDI			116
#define PIN_SPI0_SDO			117
#define PIN_SPI0_SCK			118
#define PIN_SPI1_CS0			119
#define PIN_SPI1_CS1			120
#define PIN_SPI1_SDI			121
#define PIN_SPI1_SDO			122
#define PIN_SPI1_SCK			123
#define PIN_JTAG0_TDO			124
#define PIN_JTAG0_TCK			125
#define PIN_JTAG0_TDI			126
#define PIN_JTAG0_TMS			127
#define PIN_JTAG0_TRST			128
#define PIN_JTAG0_SRST			129
#define PIN_JTAG1_TDO			130
#define PIN_JTAG1_TCK			131
#define PIN_JTAG1_TDI			132
#define PIN_JTAG1_TMS			133
#define PIN_JTAG1_TRST			134
#define PIN_JTAG1_SRST			135
#define PIN_JTAG2_TDO			136
#define PIN_JTAG2_TCK			137
#define PIN_JTAG2_TDI			138
#define PIN_JTAG2_TMS			139
#define PIN_JTAG2_TRST			140
#define PIN_JTAG2_SRST			141
#define PIN_JTAG3_TDO			142
#define PIN_JTAG3_TCK			143
#define PIN_JTAG3_TDI			144
#define PIN_JTAG3_TMS			145
#define PIN_JTAG3_TRST			146
#define PIN_JTAG3_SRST			147
#define PIN_GPIO0			148
#define PIN_GPIO1			149
#define PIN_GPIO2			150
#define PIN_GPIO3			151
#define PIN_GPIO4			152
#define PIN_GPIO5			153
#define PIN_GPIO6			154
#define PIN_GPIO7			155
#define PIN_GPIO8			156
#define PIN_GPIO9			157
#define PIN_GPIO10			158
#define PIN_GPIO11			159
#define PIN_GPIO12			160
#define PIN_GPIO13			161
#define PIN_GPIO14			162
#define PIN_GPIO15			163
#define PIN_GPIO16			164
#define PIN_GPIO17			165
#define PIN_GPIO18			166
#define PIN_GPIO19			167
#define PIN_GPIO20			168
#define PIN_GPIO21			169
#define PIN_GPIO22			170
#define PIN_GPIO23			171
#define PIN_GPIO24			172
#define PIN_GPIO25			173
#define PIN_GPIO26			174
#define PIN_GPIO27			175
#define PIN_GPIO28			176
#define PIN_GPIO29			177
#define PIN_GPIO30			178
#define PIN_GPIO31			179
#define PIN_MODE_SEL0			180
#define PIN_MODE_SEL1			181
#define PIN_MODE_SEL2			182
#define PIN_BOOT_SEL0			183
#define PIN_BOOT_SEL1			184
#define PIN_BOOT_SEL2			185
#define PIN_BOOT_SEL3			186
#define PIN_BOOT_SEL4			187
#define PIN_BOOT_SEL5			188
#define PIN_BOOT_SEL6			189
#define PIN_BOOT_SEL7			190
#define PIN_MULTI_SCKT			191
#define PIN_SCKT_ID0			192
#define PIN_SCKT_ID1			193
#define PIN_PLL_CLK_IN_MAIN		194
#define PIN_PLL_CLK_IN_DDR_0		195
#define PIN_PLL_CLK_IN_DDR_1		196
#define PIN_PLL_CLK_IN_DDR_2		197
#define PIN_PLL_CLK_IN_DDR_3		198
#define PIN_XTAL_32K			199
#define PIN_SYS_RST			200
#define PIN_PWR_BUTTON			201
#define PIN_TEST_EN			202
#define PIN_TEST_MODE_MBIST		203
#define PIN_TEST_MODE_SCAN		204
#define PIN_TEST_MODE_BSD		205
#define PIN_BISR_BYP			206

#endif /* _DT_BINDINGS_PINCTRL_SG2044_H */
