
set(TARGET_NAMES "static_lib" "shared_lib" "interface_lib")
set(static_lib_FOUND "0")
set(shared_lib_FOUND "0")
set(interface_lib_FOUND "0")

macro(checkExportTargets FOLDER_PATH)
  message("Checking folder: ${FOLDER_PATH}")
  file(GLOB sources_list LIST_DIRECTORIES true RELATIVE ${FOLDER_PATH} ${FOLDER_PATH}/*)
  message("Found files and folders: ${sources_list}")
  foreach(source ${sources_list})
    set(SOURCE_ABS "${FOLDER_PATH}/${source}")
    if(IS_DIRECTORY ${SOURCE_ABS})
      message("Found subfolder: ${source}")
      checkExportTargets(${SOURCE_ABS})
    else()
      message("Found file: ${source}")
      foreach(TARGET_NAME ${TARGET_NAMES})
        set(TARGETS_FILE "${TARGET_NAME}Targets.cmake")
        if(${source} STREQUAL ${TARGETS_FILE})
          message("Found ${TARGETS_FILE} in ${FOLDER_PATH}")
          string(TOUPPER ${TARGET_NAME} TARGET_NAME_UPPER)
          set(expected_macro "${TARGET_NAME_UPPER}_MACRO")
          set(expected_string "INTERFACE_AUTOMOC_MACRO_NAMES \"${expected_macro}\"")
          file(READ ${FOLDER_PATH}/${source} contents)
          if (NOT contents MATCHES ${expected_string})
            message(FATAL_ERROR "Expected ${expected_string} in ${FOLDER_PATH}/${source}")
          else()
            message("Found ${expected_string} in ${FOLDER_PATH}/${source}")
            set(${TARGET_NAME}_FOUND "1")
          endif()
        endif()
      endforeach()
    endif()
  endforeach()
endmacro()

checkExportTargets(${FOLDER_PATH})

foreach(TARGET_NAME ${TARGET_NAMES})
  # check if the target found equals the expected value
  if(NOT ${TARGET_NAME}_FOUND STREQUAL "1")
    message(FATAL_ERROR "Did not find ${TARGET_NAME}Targets.cmake")
  endif()
endforeach()
