package ONVIF::Device::Types::SupportInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Binary_of :ATTR(:get<Binary>);
my %String_of :ATTR(:get<String>);

__PACKAGE__->_factory(
    [ qw(        Binary
        String

    ) ],
    {
        'Binary' => \%Binary_of,
        'String' => \%String_of,
    },
    {
        'Binary' => 'ONVIF::Device::Types::AttachmentData',
        'String' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'Binary' => 'Binary',
        'String' => 'String',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::SupportInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SupportInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Binary


=item * String




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::SupportInformation
   Binary =>  { # ONVIF::Device::Types::AttachmentData
     Include =>  { # ONVIF::Device::Types::Include
     },
   },
   String =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

