#
# This script establishes list of primitive groups.
# You should run it when you update GAP to a new version whose small groups
# database changes.
#
# GAP fails on centers for 272, 480.

echo "
WARNING. The small groups database may take dozens of hours to build!

Modify this file if you really want to rebuild the database: comment out
the line 'exit', and create a subdirectory "small2".

"
exit

if [ ! -d small ] || [ ! -d small2 ]; then exit; fi
cd small2

echo "The new database is in subdirectory ./small2;
Copy it to ./small when finished.

"

rm -f * &>/dev/null
echo : >index

ulimit -d 64000
gap.sh <<@
IsDihedralGroup:=function(dgrp)
 local siz, gens, ords;
 siz:=Size(dgrp);
 if Gcd(siz,2)<>2 then return false; else siz:=siz/2; fi;
 gens:=SmallGeneratingSet(dgrp); ords:=List(gens,Order);
 if (ords=[2,siz] or ords=[siz,2]) and Order((gens[1]*gens[2])^2)=1 then 
  return true; else return false;
 fi;
end;
naturecode:=function(grp)
local a; a:=0;
 if IsCyclic(grp) then a:=1; elif
    IsAbelian(grp) then a:=2; elif
    IsDihedralGroup(grp) then a:=5; elif
    IsNilpotentGroup(grp) then a:=3; elif
    IsSolvableGroup(grp) then a:=4; elif
    IsSimpleGroup(grp) then a:=11; elif
    IsPerfectGroup(grp) then a:=12; fi;
 return a; end;

 first:=2;
 for s in [2..255] do
  n:=NumberSmallGroups(s);
  fac:=FactorsInt(s); first:=fac[1];
  AppendTo("index",":",n,", ",s,", ",fac,"\n");
  if n<=4000 then 
   Print("Archiving ",n," groups of order ",s," ...\n");
   for i in [1..n] do
    G:=SmallGroup(s,i);
    a:=naturecode(G);
    cj:=Size(ConjugacyClasses(G));
    ce:=AbelianInvariants(Center(G));
    ex:=Exponent(G);
    o2:=Number(List(G,Order),x->x=first);
    ab:=AbelianInvariants(G);
    if a=1 or a=2 then la:="--"; su:="--"; no:="--"; else 
    	cs:=ConjugacyClassesSubgroups(G);
	la:=Size(cs);
	su:=Sum(cs,Size);
	no:=Number(cs,x->Size(x)=1);
    fi;
    AppendTo(String(s),":",i,";",a,";",ex,";",ce,";",ab,";",cj,";",su,";",la,";",no,";",o2,"\n"); 
   od;
  fi;
 od;
@

echo : >gapserial
list=`ls [0-9]* | sort -n`
for i in $list
do
 cat $i | sed 's/\],/|/g;s/\[//g;s/\]//g;s/ //g' >$i..
 mv $i.. $i
 ../src/indsort $i
 awk -F ';' 'BEGIN {printf ":'$i' , "};
	{printf substr($1,2) ","};
	END {printf "\n"};
 ' $i >>gapserial
done

cat index | sed 's/\[//g;s/\]//g;s/ //g' >.index
mv .index index

exit

#    cs:=List(UpperCentralSeries(G),Size);
#    de:=List(DerivedSeries(G),AbelianInvariants);

