target=lagrange11 lagrange12

#if #TARGET(lagrange11) 
\title{Interpolation de Lagrange I (3 points)}
#endif
#if #TARGET(lagrange12) 
\title{Interpolation de Lagrange II (3 points)}
#endif

\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}
\precision{100000}
#if #TARGET(lagrange11) || #TARGET(lagrange12)

\text{fx=masses volumiques}
\text{tx=tempratures}
\text{enonce=Les \fx d'un matriau pour diffrentes \tx
  sont donnes par le tableau ci-dessous (<i>il ne s'agit pas de donnes
  relles</i>) :
}

94 205 371
929 902 860

\text{S = randint(88..95),randint(195..210),randint(350..380)}
\text{V = randint(920..930),randint(890..910),randint(850..870)}

#endif

#if #TARGET(lagrange12) 
\integer{S0= randitem(randint(\S[1]+10 .. \S[2]-10) , randint(\S[2]+10 .. \S[3]-10))}
#endif
\text{xrange=pari([0.8*vecmin([\S]),1.2*vecmax([\S])])}
\text{yrange=pari([0.8*vecmin([\V]),1.2*vecmax([\V])])}
 

\text{n=3}
\text{P = a*x^2 + b*x + c}
\matrix{M = pari(M=matrix(\n,\n) ; 
  M[1,] = [\S[1]^2,\S[1],1] ;
  M[2,] = [(\S[2])^2, \S[2],1] ; 
  M[3,] = [(\S[3])^2, \S[3],1] ; 
  M)}


\matrix{N = pari(floor(10000*[\M]^(-1)*[\V]~)~*0.0001)}
\matrix{N = pari(([\M]^(-1)*[\V]~)~)}
\function{f= (\N[1])*t^2 + (\N[2])*t + (\N[3]) }
\function{Psol=pari((\N[1])*x^2 + (\N[2])*x + (\N[3]))}
\function{Psolt=evalue(\Psol,x=t)}
\text{condition=pari(([\M]*[a,b,c]~)~-[\V])}


\text{dessin=xrange \xrange
yrange \yrange
dvline \S[1],0,red
dvline \S[2],0,red
dvline \S[3],0,red
hline 0,0,blue
disk \S[1],\V[1],7,green
disk \S[2],\V[2],7,green
disk \S[3],\V[3],7,green
}
copy \S[1],\V[1],-1,-1,-1,-1,cross.gif

\text{Dessin=draw(200,200
\dessin
hline 0,0,blue)
}

\function{D1 = pari((\V[2]-\V[1])/(\S[2]-\S[1])*(x-\S[1]) + \V[1])}
\function{D2 = pari((\V[3]-\V[2])/(\S[3]-\S[2])*(x-\S[2]) + \V[2])}
\function{D1t=evalue(\D1,x=t)}
\function{D2t=evalue(\D2,x=t)}


#if #TARGET(lagrange12) 
  \real{Vlag= evalue(\Psol,x=\S0)}
  \real{Vlin= \S0 < \S[2] ? evalue(\D1,x=\S0):evalue(\D2,x=\S0)}
#endif


\text{dessin=\dessin
trange \S[1],\S[2]
plot red,t,\R1
trange \S[2],\S[3]
plot red,t,\R2
trange \S[1],\S[2]
plot black,t,\D1t
trange \S[2],\S[3]
plot black,t,\D2t
}

\text{Dessin=draw(200,200
\dessin
hline 0,0,blue)
}
\text{style = <style type="text/css">
 .question {
  background-color: #FFFFAA;
  margin : 2% 5%;
  padding : 2%;
  text-align: center;}
  .reponse {background-color : #ffcc99;
          color : black;
          margin : 2% 5%;
          padding : 2%;
  }
 </style>}
 
#if #TARGET(lagrange11)
\steps{r1,r2
r3
r5,r6
r7
}

\statement{\style
\enonce
<p>
<table align="center" border=1>
   <tr><th>\tx</th><td>\S[1]</td><td>\S[2]</td><td>\S[3]</td></tr>
   <tr><th>\fx</th><td>\V[1]</td><td>\V[2]</td><td>\V[3]</td></tr>
 </table>
</p>
<p>
On dsire interpoler ces points 
par une fonction continue, c'est--dire trouver une fonction \(f) donnant 
la masse volumique en fonction de la temprature.
</p>
 <ol style="list-style: upper-alpha;"><li><dl>Interpolation par des segments de droite</dl>
\if{\step =1}{
On commence par relier les points par des segments. 
<div class="question">Donner les expressions
de la fonction d'interpolation dans les deux intervalles
</div>
<table align="center">
   <tr><td>\embed{reply1,15}</td> <td> sur l'intervalle [\S[1],\S[2]]</td></tr>
   <tr><td>\embed{reply2,15}</td> <td> sur l'intervalle [\S[2],\S[3]]</td></tr>
 </table>
}

\if{\step>=2}{
<li style=A><dl>Interpolation de Lagrange</dl>}
\if{\step=2}{
On prfrerait avoir une courbe plus <i>lisse</i>, c'est--dire par 
exemple drivable. Pour cela, on interpole les points  l'aide d'une
fonction polynme \(P) sur l'intervalle [0,\S[3]].
<div class="question">
De quel degr doit-on la prendre ? \embed{reply3,5}. 
</div>}
\if{\step=3}{
<div class="question">Ecrire le systme linaire que vrifient les coefficients
de \(P = \P). </div>
<ol><li>
Condition au premier point : 
\embed{reply4} = 0
</li>
<li>
Condition au deuxime point : 
\embed{reply5} = 0
</li>
<li>
Condition au troisime point : 
\embed{reply6} = 0
</li>
</ol>
}
\if{\step=4}{La matrice du systme est en effet \([\M]). 
<p>
<div class="question">Rsoudre le systme et donner le polynme solution : 
<p align="center">\embed{reply7}</p>
</div>
}
</ol>
<p align=center><img src=\Dessin></p>

}

\answer{}{\D1,y}{type=function}
\answer{}{\D2,y}{type=function}
\answer{}{2}
\answer{}{\condition[1],a,b,c,d}{type=equation}
\answer{}{\condition[2],a,b,c,d}{type=equation}
\answer{}{\condition[3],a,b,c,d}{type=equation}
\answer{}{\Psol,x}{type=function}


\function{R1=evalue(\reply1,x=t)}
\function{R2=evalue(\reply2,x=t)}
\function{Rep=evalue(\reply7,x=t)}
text{Rep = wims(replace internal = by -( in \Rep))}
\text{dessin2=\dessin
trange \S[1],\S[2]
plot black,t,\D1t
trange \S[2],\S[3]
plot black,t,\D2t
trange \S[1],\S[3]
plot red,t,\Rep
plot green,t,\Psolt
}

\text{Dessin2=draw(200,200
\dessin2
hline 0,0,blue)
}
\feedback{1=1}{
<div class="reponse">Il est possible que la fonction trouve ne soit pas 
une approximation trs raliste du problme initial. Par exemple,
on s'attend  trouver une fonction monotone, ce qui n'est pas toujours le cas.
<p align="center"><img src=\Dessin2></p>
}

#endif
#if #TARGET(lagrange12)
\statement{\style
\enonce
<p>
<table align="center" border=1>
   <tr><th>\tx</th><td>\S[1]</td><td>\S[2]</td><td>\S[3]</td></tr>
   <tr><th>\fx</th><td>\V[1]</td><td>\V[2]</td><td>\V[3]</td></tr>
 </table>
</p>

Donner la valeur de la masse volumique en \(T = \S0)

 <ol style="list-style: upper-alpha;"><li>si on interpole par des segments de droite
 (interpolation linaire) : \embed{reply1,15}
 </li>
 <li>si on interpole par un polynme (interpolation polynomiale de Lagrange)
 \embed{reply2,15}
 </li>
 </ol>
 }
\answer{Interpolation linaire}{\Vlin}
\answer{Interpolation polynomiale}{\Vlag}
#endif

Pour un  gaz parfait c'est en 1/T . 


temprature en fonction de l'altitude

masse volumique en fonction de l'altitude

Variations de la pression atmosphrique avec l'altitude :
