/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif


#if defined(__GNUC__)
//    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else




#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }


#include <string>


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1setSerialPortParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    bool arg5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = jarg5 ? true : false; 
    {
        try {
            (arg1)->setSerialPortParams(arg2,arg3,arg4,arg5);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1getBaudRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (int)(arg1)->getBaudRate();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1getDataBits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (int)(arg1)->getDataBits();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1getStopBits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (int)(arg1)->getStopBits();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1getParity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->getParity();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1notifyOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    bool arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            (arg1)->notifyOn(arg2,arg3);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isNotifyOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            result = (bool)(arg1)->isNotifyOn(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1waitForEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->waitForEvent();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1cancelWait(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->cancelWait();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1didEventOccur(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            result = (bool)(arg1)->didEventOccur(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1setDTR(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    {
        try {
            (arg1)->setDTR(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1setRTS(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    {
        try {
            (arg1)->setRTS(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isDTR(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isDTR();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isRTS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isRTS();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isCTS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isCTS();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isDSR(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isDSR();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isRI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isRI();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1isCD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->isCD();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1sendBreak(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            (arg1)->sendBreak(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT jlong JNICALL _Java_net_tinyos_comm_TOSCommJNI_new_1NativeSerial(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    NativeSerial *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        try {
            result = (NativeSerial *)new NativeSerial((char const *)arg1);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    *(NativeSerial **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_delete_1NativeSerial(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT void JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            (arg1)->close();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return ;
        }
    }
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1available(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (int)(arg1)->available();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1read_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    {
        try {
            result = (int)(arg1)->read();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1read_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2, jint jarg3, jint jarg4) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    signed char *arg2 ;
    int arg3 ;
    int arg4 ;
    int result;
    jbyte *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    if (!SWIG_JavaArrayInSchar(jenv, &jarr2, &arg2, jarg2)) return 0; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    {
        try {
            result = (int)(arg1)->read(arg2,arg3,arg4);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    SWIG_JavaArrayArgoutSchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1write_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            result = (int)(arg1)->write(arg2);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1write_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2, jint jarg3, jint jarg4) {
    jint jresult = 0 ;
    NativeSerial *arg1 = (NativeSerial *) 0 ;
    signed char *arg2 ;
    int arg3 ;
    int arg4 ;
    int result;
    jbyte *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(NativeSerial **)&jarg1; 
    if (!SWIG_JavaArrayInSchar(jenv, &jarr2, &arg2, jarg2)) return 0; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    {
        try {
            result = (int)(arg1)->write((signed char const (*))arg2,arg3,arg4);
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = (jint)result; 
    SWIG_JavaArrayArgoutSchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
    return jresult;
}


JNIEXPORT jstring JNICALL _Java_net_tinyos_comm_TOSCommJNI_NativeSerial_1getTOSCommMap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = NativeSerial::getTOSCommMap();
            
        } catch (comm_port_error &e) {
            jclass clazz = jenv->FindClass("java/lang/Exception");
            std::string s = "TOSComm JNI library runtime error: ";
            s += + e.what();
            jenv->ThrowNew( clazz, s.c_str() );
            return 0;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


#ifdef __cplusplus
}
#endif

