/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.ifthen;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserBoolean;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.ifthen.BeginConditionGroup;
import com.dickimawbooks.texparserlib.latex.ifthen.BinaryConditionalOperator;
import com.dickimawbooks.texparserlib.latex.ifthen.ConditionGroup;
import com.dickimawbooks.texparserlib.latex.ifthen.EndConditionGroup;
import com.dickimawbooks.texparserlib.latex.ifthen.IFand;
import com.dickimawbooks.texparserlib.latex.ifthen.IFisodd;
import com.dickimawbooks.texparserlib.latex.ifthen.IFnot;
import com.dickimawbooks.texparserlib.latex.ifthen.IFor;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenElse;
import com.dickimawbooks.texparserlib.latex.ifthen.UnaryConditionalOperator;
import java.io.IOException;
import java.util.Vector;

public class IfThenSty
extends LaTeXSty {
    private Vector<ControlSequence> localControlSequences;
    public static final String ERROR_INVALID_CONDITION = "ifthen.invalid.condition";

    public IfThenSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, "ifthen", laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new IfThenElse(this));
        this.addConditionalControlSequence(new IFisodd());
        this.addConditionalControlSequence(new IFand());
        this.addConditionalControlSequence(new IFand("AND"));
        this.addConditionalControlSequence(new IFor());
        this.addConditionalControlSequence(new IFor("OR"));
        this.addConditionalControlSequence(new IFnot());
        this.addConditionalControlSequence(new IFnot("NOT"));
        this.addConditionalControlSequence(new BeginConditionGroup());
        this.addConditionalControlSequence(new EndConditionGroup());
    }

    @Override
    public void processOption(String string) throws IOException {
    }

    @Override
    protected void preOptions() throws IOException {
    }

    public void addConditionalControlSequence(ControlSequence controlSequence) {
        if (this.localControlSequences == null) {
            this.localControlSequences = new Vector();
        }
        this.localControlSequences.add(controlSequence);
    }

    protected TeXBoolean popNumericalCondition(TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXParser teXParser = this.getListener().getParser();
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        TeXObject teXObject = teXObjectList.popToken(by);
        Numerical numerical2 = teXObjectList.popNumerical(teXParser);
        if (!(teXObject instanceof CharObject)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s %s", numerical, teXObject, numerical2));
        }
        int n = ((CharObject)teXObject).getCharCode();
        if (n == 61) {
            return new UserBoolean(numerical.number(teXParser) == numerical2.number(teXParser));
        }
        if (n == 60) {
            return new UserBoolean(numerical.number(teXParser) < numerical2.number(teXParser));
        }
        if (n == 62) {
            return new UserBoolean(numerical.number(teXParser) > numerical2.number(teXParser));
        }
        throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s %s", numerical, teXObject, numerical2));
    }

    protected TeXObject popCondition(TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXParser teXParser = this.getListener().getParser();
        TeXObject teXObject = teXObjectList.peekStack(by);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof ConditionGroup || teXObject instanceof TeXBoolean) {
            return teXObjectList.popToken(by);
        }
        return this.popNumericalCondition(teXObjectList);
    }

    protected boolean parseCondition(TeXObjectList teXObjectList) throws IOException {
        boolean bl;
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXParser teXParser = this.getListener().getParser();
        TeXObject teXObject = teXObjectList.peekStack(by);
        UnaryConditionalOperator unaryConditionalOperator = null;
        if (teXObject instanceof UnaryConditionalOperator) {
            unaryConditionalOperator = (UnaryConditionalOperator)teXObjectList.popToken(by);
            teXObject = this.popCondition(teXObjectList);
        } else {
            teXObject = this.popCondition(teXObjectList);
        }
        if (teXObject == null) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, teXObjectList.toString(teXParser));
        }
        if (teXObject instanceof TeXBoolean) {
            bl = ((TeXBoolean)teXObject).booleanValue();
        } else if (teXObject instanceof ConditionGroup) {
            bl = this.parseCondition((ConditionGroup)teXObject);
        } else {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, teXObject.toString(teXParser));
        }
        if (unaryConditionalOperator != null) {
            bl = unaryConditionalOperator.evaluate(bl);
        }
        while ((teXObject = teXObjectList.peekStack(by)) != null) {
            unaryConditionalOperator = teXObject instanceof UnaryConditionalOperator ? (UnaryConditionalOperator)teXObjectList.popToken(by) : null;
            teXObject = teXObjectList.popToken(by);
            if (teXObject == null) {
                if (unaryConditionalOperator == null) break;
                throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, unaryConditionalOperator.toString(teXParser));
            }
            if (!(teXObject instanceof BinaryConditionalOperator)) {
                if (unaryConditionalOperator == null) {
                    throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s", bl, teXObject.toString(teXParser)));
                }
                throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s %s", bl, unaryConditionalOperator.toString(teXParser), teXObject.toString(teXParser)));
            }
            BinaryConditionalOperator binaryConditionalOperator = (BinaryConditionalOperator)teXObject;
            teXObject = this.popCondition(teXObjectList);
            if (teXObject instanceof TeXBoolean) {
                bl = binaryConditionalOperator.evaluate(bl, ((TeXBoolean)teXObject).booleanValue());
                continue;
            }
            if (teXObject instanceof ConditionGroup) {
                bl = binaryConditionalOperator.evaluate(bl, this.parseCondition((ConditionGroup)teXObject));
                continue;
            }
            if (teXObject == null) {
                throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s %s", bl, binaryConditionalOperator.toString(teXParser)));
            }
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, String.format("%s %s %s", bl, binaryConditionalOperator.toString(teXParser), teXObject.toString(teXParser)));
        }
        return bl;
    }

    public boolean evaluate(TeXObject object) throws IOException {
        TeXParser teXParser = this.getListener().getParser();
        teXParser.startGroup();
        Object object2 = this.localControlSequences.iterator();
        while (object2.hasNext()) {
            ControlSequence controlSequence = object2.next();
            teXParser.putControlSequence(true, controlSequence);
        }
        if (object instanceof Expandable && (object2 = ((Expandable)object).expandfully(teXParser)) != null) {
            object = object2;
        }
        teXParser.endGroup();
        if (!(object instanceof TeXObjectList)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONDITION, object.toString(teXParser));
        }
        return this.parseCondition((TeXObjectList)object);
    }
}

