/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.AlignSpan;
import com.dickimawbooks.texparserlib.latex.MultiCell;
import java.io.IOException;
import java.util.Vector;

public class L2HAlignRow
extends AlignRow {
    private int[] hlines;

    public L2HAlignRow() {
    }

    public L2HAlignRow(int n) {
        super(n);
    }

    public L2HAlignRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this();
        this.parse(teXParser, teXObjectList);
    }

    @Override
    protected void startRow(TeXParser teXParser) throws IOException {
        Object object;
        this.hlines = new int[teXParser.getSettings().getAlignmentColumnCount()];
        for (int i = 0; i < this.hlines.length; ++i) {
            this.hlines[i] = 0;
        }
        TeXObjectList teXObjectList = this.getAlignSpanList();
        for (TeXObject teXObject : teXObjectList) {
            if (!(teXObject instanceof AlignSpan)) continue;
            object = (AlignSpan)teXObject;
            int n = ((AlignSpan)object).firstColumn();
            int n2 = ((AlignSpan)object).lastColumn();
            if (n == -1 || n2 == -1) {
                n = 1;
                n2 = this.hlines.length;
            }
            for (int i = n; i <= n2; ++i) {
                int n3 = i - 1;
                this.hlines[n3] = this.hlines[n3] + 1;
            }
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        teXParserListener.getWriteable().write("<tr>");
        if (this.isEmpty()) {
            for (int i = 0; i < this.hlines.length; ++i) {
                object = null;
                switch (this.hlines[i]) {
                    case 0: {
                        object = "border-top: none; ";
                        break;
                    }
                    case 1: {
                        object = "border-top: solid; ";
                        break;
                    }
                    default: {
                        object = "border-top: double; ";
                    }
                }
                if (object == null) {
                    teXParserListener.getWriteable().write("<td></td>");
                    continue;
                }
                teXParserListener.getWriteable().write("<td style=\"" + (String)object + "\"></td>");
            }
        }
    }

    @Override
    protected void endRow(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().writeln("</tr>");
    }

    public TeXDimension getDefaultColSep(TeXParser teXParser) throws TeXSyntaxException {
        Register register = teXParser.getSettings().getRegister("tabcolsep");
        if (register == null || !(register instanceof DimenRegister)) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", String.format("%ctabcolsep", teXParser.getEscChar()));
        }
        return ((DimenRegister)register).getDimension();
    }

    protected String getAlignStyle(TeXParser teXParser, TeXCellAlign teXCellAlign, TeXDimension teXDimension) {
        String string = "";
        int n = teXCellAlign.preRuleCount();
        int n2 = teXCellAlign.postRuleCount();
        switch (n) {
            case 0: {
                string = string + "border-left: none; ";
                break;
            }
            case 1: {
                string = string + "border-left: solid; ";
                break;
            }
            default: {
                string = string + "border-left: double; ";
            }
        }
        switch (n2) {
            case 0: {
                string = string + "border-right: none; ";
                break;
            }
            case 1: {
                string = string + "border-right: solid; ";
                break;
            }
            default: {
                string = string + "border-right: double; ";
            }
        }
        int n3 = teXParser.getSettings().getAlignmentColumn();
        switch (this.hlines[n3 - 1]) {
            case 0: {
                string = string + "border-top: none; ";
                break;
            }
            case 1: {
                string = string + "border-top: solid; ";
                break;
            }
            default: {
                string = string + "border-top: double; ";
            }
        }
        string = teXCellAlign.getBefore() == null ? string + "padding-left: " + teXDimension.format() + "; " : string + "padding-left: 0px; ";
        string = teXCellAlign.getAfter() == null ? string + "padding-right: " + teXDimension.format() + "; " : string + "padding-right: 0px; ";
        TeXDimension teXDimension2 = teXCellAlign.getWidth();
        if (teXDimension2 != null) {
            string = string + "width: " + teXDimension2.toString(teXParser) + "; ";
        }
        switch (teXCellAlign.getAlign()) {
            case 99: {
                string = string + "text-align: center; ";
                break;
            }
            case 108: {
                string = string + "text-align: left; ";
                break;
            }
            case 114: {
                string = string + "text-align: right; ";
            }
        }
        return string;
    }

    @Override
    protected void processCell(TeXParser teXParser, TeXCellAlign teXCellAlign, Group group) throws IOException {
        TeXObject teXObject;
        TeXCellAlign teXCellAlign2;
        Expandable expandable;
        TeXObject teXObject2;
        Writeable writeable = teXParser.getListener().getWriteable();
        TeXDimension teXDimension = this.getDefaultColSep(teXParser);
        if (teXDimension instanceof TeXGlue) {
            teXDimension = ((TeXGlue)teXDimension).getFixed();
        }
        String string = "";
        TeXObject teXObject3 = teXObject2 = group.isEmpty() ? group : group.peekStack();
        if (teXObject2 instanceof MultiCell) {
            expandable = (MultiCell)teXObject2;
            teXCellAlign2 = ((MultiCell)expandable).getAlignment();
            int n = ((MultiCell)expandable).getRowSpan();
            int n2 = ((MultiCell)expandable).getColumnSpan();
            if (n > 1) {
                string = " rowspan=\"" + n + "\"";
            }
            if (n2 > 1) {
                string = string + " colspan=\"" + n2 + "\"";
            }
        } else {
            teXCellAlign2 = teXCellAlign;
        }
        this.startCell(teXParser, string, this.getAlignStyle(teXParser, teXCellAlign2, teXDimension));
        expandable = new TeXObjectList();
        TeXObject teXObject4 = teXCellAlign2.getBefore();
        TeXObject teXObject5 = teXCellAlign2.getAfter();
        if (teXObject4 != null) {
            ((TeXObjectList)expandable).add((TeXObject)teXObject4.clone());
        }
        if ((teXObject = teXCellAlign2.getPreShift()) != null) {
            group.push((TeXObject)teXObject.clone());
        }
        ((TeXObjectList)expandable).add(group);
        TeXObject teXObject6 = teXCellAlign2.getPostShift();
        if (teXObject6 != null) {
            group.add((TeXObject)teXObject6.clone());
        }
        if (teXObject5 != null) {
            ((TeXObjectList)expandable).add((TeXObject)teXObject5.clone());
        }
        while (((Vector)((Object)expandable)).size() > 0) {
            ((TeXObjectList)expandable).pop().process(teXParser, (TeXObjectList)expandable);
        }
        this.endCell(teXParser);
    }

    protected void startCell(TeXParser teXParser, String string, String string2) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        writeable.write(String.format("<td%s style=\"%s\">", string, string2));
    }

    protected void endCell(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().writeln("</td>");
    }
}

