7.1 Controlando Sintetizadores en ejecución

# Controlando Sintetizadores en ejecución

Hasta el momento nos hemos concentrado en disparar nuevos sonidos y FXs.
Sin embargo, Sonic Pi te da la posibilidad de manipular y controlar sonidos
en ejecución. Esto lo hacemos al utilizar una variable para capturar una
referencia de un sintetizador:


```
s = play 60, release: 5
```

Aquí utilizamos una variable de ejecución local, `s` que representa el
sintetizador tocando la nota 60. Al ser *local* no puede ser accesada desde
otras ejecuciones, como sucede con las funciones.

Con `s`, utilizaremos la función `control`:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Es de notar que no se disparan 4 diferentes sintetizadores, sino que usando
uno al que le cambiamos los tonos 3 veces durante su ejecución.

Podemos pasar operandos para `control` como `amp`, `cutoff:` o `pan:`.

## Opciones no-controlables

Algunos de los operandos no pueden ser controlados una vez comenzado
el sintetizador. Este es el caso de los parámetros de sobres ADSR. Puedes
encontrar cuáles operandos sí pueden ser controlados en el sistema de ayuda.
Si la documentación dice *no puede ser cambiado una vez seteado*, es que no
puedes controlar los operandos cuando el sintetizador ha comenzado.
