
/*
 * slmon
 *
 * Copyright (C) 2000, 2001, 2002 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 * $Date: 2003/06/07 18:08:20 $
 * $Revision: 1.1.1.1 $
 *
 */

#ifndef SLMON_STAT_H
#define SLMON_STST_H

#include <glibtop/proclist.h>
#include <glibtop/procstate.h>
#include <glibtop/procmem.h>
#include <glibtop/procargs.h>
#include <glibtop/proctime.h>
#include <glibtop/netload.h>
#include <pwd.h>
#include <sys/types.h>

#include "defines.h"

int cpu_calc(int count);
void get_uptime(int *days, int *hours, int *minutes, int *seconds);
int users(void);
char *cpu_caption(int num);
slmon_proc *slmon_get_proclist(int *len);
int slmon_cmp_pcpu_asc(const void *one, const void *two);
int slmon_cmp_pcpu_desc(const void *one, const void *two);
int slmon_cmp_pmem_asc(const void *one, const void *two);
int slmon_cmp_pmem_desc(const void *one, const void *two);
int slmon_cmp_pid_asc(const void *one, const void *two);
int slmon_cmp_pid_desc(const void *one, const void *two);
int slmon_cmp_user_asc(const void *one, const void *two);
int slmon_cmp_user_desc(const void *one, const void *two);
void slmon_update_net_throughput(char *name, long in, long out);
struct slmon_net *slmon_net_new(void);
struct slmon_net *slmon_net_append(struct slmon_net * l, char *name);
struct slmon_net *slmon_net_remove(struct slmon_net * l, char *name);
void slmon_net_free(struct slmon_net * l);
struct slmon_net *slmon_net_last(struct slmon_net *l);
struct slmon_net *slmon_net_find(struct slmon_net *l, char *name);
#endif
