package provide DS9 1.0

######
# Begin autogenerated taccle (version 1.3) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

namespace eval zscale {
    variable yylval {}
    variable table
    variable rules
    variable token {}
    variable yycnt 0
    variable yyerr 0
    variable save_state 0

    namespace export yylex
}

proc zscale::YYABORT {} {
    return -code return 1
}

proc zscale::YYACCEPT {} {
    return -code return 0
}

proc zscale::YYERROR {} {
    variable yyerr
    set yyerr 1
}

proc zscale::yyclearin {} {
    variable token
    variable yycnt
    set token {}
    incr yycnt -1
}

proc zscale::yyerror {s} {
    puts stderr $s
}

proc zscale::setupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc zscale::unsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set zscale::table {
  11:265 shift
  5:0,target 10
  0:266,target 1
  9:0 reduce
  0:265 reduce
  1:270,target 8
  2:263 shift
  5:265,target 11
  0:266 shift
  0:267 shift
  0:265,target 13
  0:268 shift
  2:263,target 9
  6:0,target 8
  0:271 goto
  6:265 reduce
  0:273 goto
  8:265 reduce
  6:0 reduce
  8:265,target 14
  7:0,target 9
  12:0 reduce
  0:0,target 13
  10:0,target 16
  0:273,target 5
  10:265,target 16
  5:272,target 11
  8:0,target 14
  10:265 reduce
  6:265,target 8
  7:0 reduce
  3:263,target 10
  1:263 shift
  9:0,target 15
  0:271,target 4
  1:264 shift
  12:0,target 12
  3:263 shift
  0:0 reduce
  1:264,target 7
  9:265,target 15
  1:270 goto
  5:265 reduce
  4:0 accept
  7:265 reduce
  9:265 reduce
  1:263,target 6
  5:272 goto
  8:0 reduce
  10:0 reduce
  11:265,target 12
  0:268,target 3
  4:0,target 0
  7:265,target 9
  0:267,target 2
  5:0 reduce
}

array set zscale::rules {
  9,l 270
  11,l 272
  15,l 273
  2,l 269
  6,l 269
  12,l 271
  16,l 273
  3,l 269
  7,l 269
  13,l 273
  0,l 274
  4,l 269
  8,l 270
  10,l 271
  14,l 273
  1,l 269
  5,l 269
}

array set zscale::rules {
  5,dc 1
  0,dc 1
  12,dc 3
  8,dc 1
  3,dc 1
  15,dc 2
  10,dc 1
  6,dc 1
  1,dc 0
  13,dc 0
  9,dc 1
  4,dc 1
  16,dc 2
  11,dc 0
  7,dc 1
  2,dc 1
  14,dc 2
}

array set zscale::rules {
  13,line 55
  7,line 45
  10,line 51
  4,line 42
  1,line 39
  15,line 57
  9,line 48
  12,line 52
  6,line 44
  3,line 41
  14,line 56
  8,line 47
  11,line 51
  5,line 43
  2,line 40
  16,line 58
  11,e 1
}

array set zscale::lr1_table {
  0 {{0 0 0} {10 0 0} {12 0 0} {13 {0 265} 0} {14 {0 265} 0} {15 {0 265} 0} {16 {0 265} 0}}
  1 {{14 {0 265} 1} {8 {0 265} 0} {9 {0 265} 0}}
  2 {{15 {0 265} 1}}
  3 {{16 {0 265} 1}}
  4 {{0 0 1}}
  0,trans {{266 1} {267 2} {268 3} {271 4} {273 5}}
  5 {{10 0 1} {12 0 1} {11 265 0}}
  1,trans {{263 6} {264 7} {270 8}}
  2,trans {{263 9}}
  6 {{8 {0 265} 1}}
  3,trans {{263 10}}
  7 {{9 {0 265} 1}}
  4,trans {}
  8 {{14 {0 265} 2}}
  5,trans {{272 11}}
  10 {{16 {0 265} 2}}
  9 {{15 {0 265} 2}}
  6,trans {}
  11 {{12 0 2}}
  12 {{12 0 3}}
  7,trans {}
  8,trans {}
  10,trans {}
  9,trans {}
  11,trans {{265 12}}
  12,trans {}
}

array set zscale::token_id_table {
  264,line 15
  270,t 1
  269,t 1
  265,title string
  274,t 1
  261,line 11
  257,t 0
  270,title {}
  269,title {}
  273,line 54
  257,line 7
  262,t 0
  274,title {}
  270,line 46
  269,line 38
  259,title ON
  260,title OFF
  266,t 0
  271,t 1
  error error
  264,title float
  266,line 21
  error,line 37
  268,title LINE
  258,t 0
  263,line 14
  error,title {}
  273,title {}
  263,t 0
  259,line 9
  260,line 10
  258,title NO
  272,line 51
  267,t 0
  263,title integer
  272,t 1
  268,line 23
  267,title SAMPLE
  257 YES_
  258 NO_
  259,t 0
  259 ON_
  260 OFF_
  260,t 0
  272,title {}
  261 TRUE_
  265,line 17
  262 FALSE_
  263 INT_
  257,title YES
  264 REAL_
  264,t 0
  265 STRING_
  262,line 12
  266 CONTRAST_
  267 SAMPLE_
  0,t 0
  0 {$}
  262,title FALSE
  268 LINE_
  268,t 0
  274,line 59
  270 numeric
  269 yesno
  271 command
  error,t 0
  272 @PSEUDO1
  258,line 8
  273,t 1
  273 zscale
  266,title CONTRAST
  274 start'
  271,line 50
  271,title {}
  261,t 0
  267,line 22
  265,t 0
  261,title TRUE
}

proc zscale::yyparse {} {
    variable yylval
    variable table
    variable rules
    variable token
    variable yycnt
    variable lr1_table
    variable token_id_table
    variable yyerr
    variable save_state

    set yycnt 0
    set state_stack {0}
    set value_stack {{}}
    set token ""
    set accepted 0
    set yyerr 0
    set save_state 0

    while {$accepted == 0} {
        set state [lindex $state_stack end]
        if {$token == ""} {
            set yylval ""
            set token [yylex]
            set buflval $yylval
	    if {$token>0} {
	        incr yycnt
            }
        }
        if {![info exists table($state:$token)] || $yyerr} {
	    if {!$yyerr} {
	        set save_state $state
	    }
            # pop off states until error token accepted
            while {[llength $state_stack] > 0 && \
                       ![info exists table($state:error)]} {
                set state_stack [lrange $state_stack 0 end-1]
                set value_stack [lrange $value_stack 0 \
                                       [expr {[llength $state_stack] - 1}]]
                set state [lindex $state_stack end]
            }
            if {[llength $state_stack] == 0} {
 
	        set rr { }
                if {[info exists lr1_table($save_state,trans)] && [llength $lr1_table($save_state,trans)] >= 1} {
                    foreach trans $lr1_table($save_state,trans) {
                        foreach {tok_id nextstate} $trans {
			    set ss $token_id_table($tok_id,title)
			    if {$ss != {}} {
			        append rr "$ss, "
                            }
                        }
                    }
                }
		set rr [string trimleft $rr { }]
		set rr [string trimright $rr {, }]
                yyerror "parse error, expecting: $rr"


                return 1
            }
            lappend state_stack [set state $table($state:error,target)]
            lappend value_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists table($state:$token)]} {
                if {$token == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set yylval {}
                set token [yylex]
                set buflval $yylval
            }
            continue
        }
        switch -- $table($state:$token) {
            shift {
                lappend state_stack $table($state:$token,target)
                lappend value_stack $buflval
                set token ""
            }
            reduce {
                set rule $table($state:$token,target)
                set ll $rules($rule,l)
                if {[info exists rules($rule,e)]} {
                    set dc $rules($rule,e)
                } else {
                    set dc $rules($rule,dc)
                }
                set stackpointer [expr {[llength $state_stack]-$dc}]
                setupvalues $value_stack $stackpointer $dc
                set _ $1
                set yylval [lindex $value_stack end]
                switch -- $rule {
                    1 { set _ 1 }
                    2 { set _ 1 }
                    3 { set _ 1 }
                    4 { set _ 1 }
                    5 { set _ 0 }
                    6 { set _ 0 }
                    7 { set _ 0 }
                    8 { set _ $1 }
                    9 { set _ $1 }
                    11 { global ds9; if {!$ds9(init)} {YYERROR} else {yyclearin; YYACCEPT} }
                    13 { ProcessCmdSet scale mode zscale ChangeScaleMode }
                    14 { ProcessCmdSet zscale contrast $2 ChangeZScale }
                    15 { ProcessCmdSet zscale sample $2 ChangeZScale }
                    16 { ProcessCmdSet zscale line $2 ChangeZScale }
                }
                unsetupvalues $dc
                # pop off tokens from the stack if normal rule
                if {![info exists rules($rule,e)]} {
                    incr stackpointer -1
                    set state_stack [lrange $state_stack 0 $stackpointer]
                    set value_stack [lrange $value_stack 0 $stackpointer]
                }
                # now do the goto transition
                lappend state_stack $table([lindex $state_stack end]:$ll,target)
                lappend value_stack $_
            }
            accept {
                set accepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $table($state:$token)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

proc zscale::yyerror {msg} {
     variable yycnt
     variable yy_current_buffer
     variable index_

     ParserError $msg $yycnt $yy_current_buffer $index_
}
