/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.Start;

public class GenAnalyses
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private List altList = new TypedLinkedList(AltInfoCast.instance);
    private List tokenList = new TypedLinkedList(StringCast.instance);
    private String mainProduction;
    ElemInfo info;

    public GenAnalyses(ResolveAstIds resolveAstIds) {
        this.ast_ids = resolveAstIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("analyses.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open analyses.txt.");
        }
        this.pkgDir = new File(resolveAstIds.astIds.pkgDir, "analysis");
        String string = this.pkgName = resolveAstIds.astIds.pkgName.equals("") ? "analysis" : resolveAstIds.astIds.pkgName + ".analysis";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void inAAstProd(AAstProd aAstProd) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ast_ids.ast_names.get(aAstProd);
        }
    }

    public void inATokenDef(ATokenDef aTokenDef) {
        this.tokenList.add(this.ast_ids.astIds.names.get(aTokenDef));
    }

    public void inAAstAlt(AAstAlt aAstAlt) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    public void caseAProductions(AProductions aProductions) {
    }

    public void inAElem(AElem aElem) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ast_ids.ast_names.get(aElem);
        this.info.type = (String)this.ast_ids.ast_elemTypes.get(aElem);
        this.info.operator = 0;
        if (aElem.getUnOp() != null) {
            aElem.getUnOp().apply(new DepthFirstAdapter(){

                public void caseAStarUnOp(AStarUnOp aStarUnOp) {
                    GenAnalyses.this.info.operator = 1;
                }

                public void caseAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
                    GenAnalyses.this.info.operator = 2;
                }

                public void caseAPlusUnOp(APlusUnOp aPlusUnOp) {
                    GenAnalyses.this.info.operator = 3;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    public void outAAstAlt(AAstAlt aAstAlt) {
        AltInfo altInfo = new AltInfo();
        altInfo.name = (String)this.ast_ids.ast_names.get(aAstAlt);
        altInfo.elems.addAll(this.elemList);
        this.elemList = null;
        this.altList.add(altInfo);
    }

    public void outStart(Start start) {
        this.createAnalysis();
        this.createAnalysisAdapter();
        if (this.mainProduction != null) {
            this.createDepthFirstAdapter();
            this.createReversedDepthFirstAdapter();
        }
    }

    public void createAnalysis() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Analysis.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "AnalysisHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisStart", null);
                for (AltInfo altInfo : this.altList) {
                    this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{altInfo.name});
                }
                bufferedWriter.newLine();
            }
            Iterator iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createAnalysisAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "AnalysisAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "AnalysisAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterStart", null);
                for (AltInfo altInfo : this.altList) {
                    this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{altInfo.name});
                }
            }
            Iterator iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "DepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "DepthFirstAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node", this.mainProduction});
            for (AltInfo altInfo : this.altList) {
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                for (ElemInfo elemInfo : altInfo.elems) {
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createReversedDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "ReversedDepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node", this.mainProduction});
            for (AltInfo altInfo : this.altList) {
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                ListIterator listIterator = altInfo.elems.listIterator(altInfo.elems.size());
                while (listIterator.hasPrevious()) {
                    ElemInfo elemInfo = (ElemInfo)listIterator.previous();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class AltInfoCast
    implements Cast {
        static final AltInfoCast instance = new AltInfoCast();

        private AltInfoCast() {
        }

        public Object cast(Object object) {
            return (AltInfo)object;
        }
    }

    private static class AltInfo {
        String name;
        final List elems = new TypedLinkedList(ElemInfoCast.instance);

        private AltInfo() {
        }
    }

    private static class ElemInfoCast
    implements Cast {
        static final ElemInfoCast instance = new ElemInfoCast();

        private ElemInfoCast() {
        }

        public Object cast(Object object) {
            return (ElemInfo)object;
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }
}

