/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file GtkGUI.hxx
    \author Romain BONDUE
    \date 21/07/2005
    \warning This fils should only be included from GtkGUI.h */
#include "Module.h"



inline void nsGUI::CGtkGUI::StopScanning () throw()
{
    ::g_source_remove (m_SiteSurveyTabTimer);
    m_SiteSurveyTab.ScanningStopped();
    m_SiteSurveyTabTimer = 0;

} // StopScanning()


inline nsGUI::CGtkGUI::operator const ::GtkWindow* () const throw()
{
    return m_pWindow;

} // operator const ::GtkWindow* ()


inline nsGUI::CGtkGUI::operator ::GtkWindow* () throw()
{
    return m_pWindow;

} // operator const ::GtkWindow* ()


inline bool nsGUI::CGtkGUI::IsRoot () const throw()
{
    return m_Flags & IsRootF;

} // IsRoot()


inline void nsGUI::CGtkGUI::SetRoot () throw()
{
    m_Flags |= IsRootF;

} // SetRoot()


inline bool nsGUI::CGtkGUI::IsIgnored () const throw()
{
    return m_Flags & IsIgnoredF;

} // IsIgnored()


inline void nsGUI::CGtkGUI::IsIgnored (bool B) throw()
{
    if (B)
        m_Flags |= IsIgnoredF;
    else
        m_Flags &= ~IsIgnoredF;

} // IsIgnored()


inline bool nsGUI::CGtkGUI::IsStatsAvailable () const throw()
{
    return m_Flags & IsStatsAvailableF;

} // IsStatsAvailable()


inline void nsGUI::CGtkGUI::IsStatsAvailable (bool B) throw()
{
    if (B)
        m_Flags |= IsStatsAvailableF;
    else
        m_Flags &= ~IsStatsAvailableF;

} // IsStatsAvailable()
