///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*Prog:space
NAME: @code{space} - print a finite element space 
SYNOPSIS:
    @example
       @code{space} @var{filename}[.space]
    @end example
DESCRIPTION:       
  Read and re-output a finite element space.
EXAMPLE: 
    enter command as:
    @example
      space < my.space
    @end example
SPACE FORMAT:       
    This is the default space file format. 
    The file 
    starts with the header: the "space" keyword followed by 
    a line containing a format version number (i.e. 1 today), 
    and the number of degrees of freedom.
    Follows the numbering and an optional 'B' label, if the
    degree of freedom is blocked.
    A sample space is:

    @example
       space
       1 3
       0 B
       1 B
       0
       2 B
       1
    @end example

AUTHOR: Pierre.Saramito@imag.fr
SEE ALSO:
    class "space"(3), class "geo"(3), class "base"(3)
DATE:
    16 june 1997
End:
*/
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

void usage()
{
      cerr << "space: usage: space "
	   << "{-Igeodir}*"
	   << "-|filename[.space]"
	   << endl;
      exit (1);
}
int main(int argc, char**argv)
{
    if (argc <= 1) usage();
    //
    // load geo path
    //
    geo g;  
    int io = 1; 
    while (argv [io][0] == '-' && argv [io][1] == 'I') {
	append_dir_to_rheo_path (argv[io]+2);
	io++;
    }
    //
    // load space
    //
    space V;
    if (strcmp (argv[io], "-") == 0) {
	// input on standard input
        cerr << "! space: load geo from stdin\n";
        cin  >> V;
      
    } else {
	// input space on file
  	ifstream is (argv[io]);
        is >> V;
	is.close();
    }
    //
    // output space
    //
    cout << V;
    return 0;
}
